/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.GitwebType;
import com.google.gerrit.common.data.ParameterizedString;
import com.google.gerrit.extensions.common.WebLinkInfo;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.extensions.webui.BranchWebLink;
import com.google.gerrit.extensions.webui.FileHistoryWebLink;
import com.google.gerrit.extensions.webui.FileWebLink;
import com.google.gerrit.extensions.webui.ParentWebLink;
import com.google.gerrit.extensions.webui.PatchSetWebLink;
import com.google.gerrit.extensions.webui.ProjectWebLink;
import com.google.gerrit.extensions.webui.TagWebLink;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.GitwebCgiConfig;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitwebConfig {
    private static final Logger log = LoggerFactory.getLogger(GitwebConfig.class);
    private final String url;
    private final GitwebType type;

    public static boolean isDisabled(Config cfg) {
        return GitwebConfig.isEmptyString(cfg, "gitweb", null, "url") || GitwebConfig.isEmptyString(cfg, "gitweb", null, "cgi") || "disabled".equals(cfg.getString("gitweb", null, "type"));
    }

    private static boolean isEmptyString(Config cfg, String section, String subsection, String name) {
        String[] values = cfg.getStringList(section, subsection, name);
        return values.length > 0 && Strings.isNullOrEmpty(values[0]);
    }

    private static GitwebType typeFromConfig(Config cfg) {
        GitwebType defaultType = GitwebConfig.defaultType(cfg.getString("gitweb", null, "type"));
        if (defaultType == null) {
            return null;
        }
        GitwebType type = new GitwebType();
        type.setLinkName(MoreObjects.firstNonNull(cfg.getString("gitweb", null, "linkname"), defaultType.getLinkName()));
        type.setBranch(MoreObjects.firstNonNull(cfg.getString("gitweb", null, "branch"), defaultType.getBranch()));
        type.setTag(MoreObjects.firstNonNull(cfg.getString("gitweb", null, "tag"), defaultType.getTag()));
        type.setProject(MoreObjects.firstNonNull(cfg.getString("gitweb", null, "project"), defaultType.getProject()));
        type.setRevision(MoreObjects.firstNonNull(cfg.getString("gitweb", null, "revision"), defaultType.getRevision()));
        type.setRootTree(MoreObjects.firstNonNull(cfg.getString("gitweb", null, "roottree"), defaultType.getRootTree()));
        type.setFile(MoreObjects.firstNonNull(cfg.getString("gitweb", null, "file"), defaultType.getFile()));
        type.setFileHistory(MoreObjects.firstNonNull(cfg.getString("gitweb", null, "filehistory"), defaultType.getFileHistory()));
        type.setUrlEncode(cfg.getBoolean("gitweb", null, "urlencode", defaultType.getUrlEncode()));
        String pathSeparator = cfg.getString("gitweb", null, "pathSeparator");
        if (pathSeparator != null) {
            if (pathSeparator.length() == 1) {
                char c = pathSeparator.charAt(0);
                if (GitwebConfig.isValidPathSeparator(c)) {
                    type.setPathSeparator(MoreObjects.firstNonNull(Character.valueOf(c), Character.valueOf(defaultType.getPathSeparator())).charValue());
                } else {
                    log.warn("Invalid gitweb.pathSeparator: " + c);
                }
            } else {
                log.warn("gitweb.pathSeparator is not a single character: " + pathSeparator);
            }
        }
        return type;
    }

    private static GitwebType defaultType(String typeName) {
        GitwebType type = new GitwebType();
        switch (Strings.nullToEmpty(typeName)) {
            case "gitweb": {
                type.setLinkName("gitweb");
                type.setProject("?p=${project}.git;a=summary");
                type.setRevision("?p=${project}.git;a=commit;h=${commit}");
                type.setBranch("?p=${project}.git;a=shortlog;h=${branch}");
                type.setTag("?p=${project}.git;a=tag;h=${tag}");
                type.setRootTree("?p=${project}.git;a=tree;hb=${commit}");
                type.setFile("?p=${project}.git;hb=${commit};f=${file}");
                type.setFileHistory("?p=${project}.git;a=history;hb=${branch};f=${file}");
                break;
            }
            case "cgit": {
                type.setLinkName("cgit");
                type.setProject("${project}.git/summary");
                type.setRevision("${project}.git/commit/?id=${commit}");
                type.setBranch("${project}.git/log/?h=${branch}");
                type.setTag("${project}.git/tag/?h=${tag}");
                type.setRootTree("${project}.git/tree/?h=${commit}");
                type.setFile("${project}.git/tree/${file}?h=${commit}");
                type.setFileHistory("${project}.git/log/${file}?h=${branch}");
                break;
            }
            case "custom": {
                type.setLinkName("gitweb");
                type.setProject("");
                type.setRevision("");
                type.setBranch("");
                type.setTag("");
                type.setRootTree("");
                type.setFile("");
                type.setFileHistory("");
                break;
            }
            default: {
                return null;
            }
        }
        return type;
    }

    @Inject
    GitwebConfig(GitwebCgiConfig cgiConfig, @GerritServerConfig Config cfg, @Nullable @CanonicalWebUrl String gerritUrl) throws MalformedURLException {
        if (GitwebConfig.isDisabled(cfg)) {
            this.type = null;
            this.url = null;
        } else {
            String cfgUrl = cfg.getString("gitweb", null, "url");
            this.type = GitwebConfig.typeFromConfig(cfg);
            if (this.type == null) {
                this.url = null;
            } else if (cgiConfig.getGitwebCgi() == null) {
                this.url = cfgUrl;
            } else {
                String baseGerritUrl;
                if (gerritUrl != null) {
                    URL u = new URL(gerritUrl);
                    baseGerritUrl = u.getPath();
                } else {
                    baseGerritUrl = "/";
                }
                this.url = MoreObjects.firstNonNull(cfgUrl, baseGerritUrl + "gitweb");
            }
        }
    }

    @Nullable
    public GitwebType getGitwebType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    static boolean isValidPathSeparator(char c) {
        switch (c) {
            case '(': 
            case ')': 
            case '*': {
                return true;
            }
        }
        return false;
    }

    @Singleton
    static class GitwebLinks
    implements BranchWebLink,
    FileHistoryWebLink,
    FileWebLink,
    PatchSetWebLink,
    ParentWebLink,
    ProjectWebLink,
    TagWebLink {
        private final String url;
        private final GitwebType type;
        private final ParameterizedString branch;
        private final ParameterizedString file;
        private final ParameterizedString fileHistory;
        private final ParameterizedString project;
        private final ParameterizedString revision;
        private final ParameterizedString tag;

        @Inject
        GitwebLinks(GitwebConfig config, GitwebType type) {
            this.url = config.getUrl();
            this.type = type;
            this.branch = GitwebLinks.parse(type.getBranch());
            this.file = GitwebLinks.parse(MoreObjects.firstNonNull(Strings.emptyToNull(type.getFile()), Strings.nullToEmpty(type.getRootTree())));
            this.fileHistory = GitwebLinks.parse(type.getFileHistory());
            this.project = GitwebLinks.parse(type.getProject());
            this.revision = GitwebLinks.parse(type.getRevision());
            this.tag = GitwebLinks.parse(type.getTag());
        }

        @Override
        public WebLinkInfo getBranchWebLink(String projectName, String branchName) {
            if (this.branch != null) {
                return this.link(this.branch.replace("project", this.encode(projectName)).replace("branch", this.encode(branchName)).toString());
            }
            return null;
        }

        @Override
        public WebLinkInfo getTagWebLink(String projectName, String tagName) {
            if (this.tag != null) {
                return this.link(this.tag.replace("project", this.encode(projectName)).replace("tag", this.encode(tagName)).toString());
            }
            return null;
        }

        @Override
        public WebLinkInfo getFileHistoryWebLink(String projectName, String revision, String fileName) {
            if (this.fileHistory != null) {
                return this.link(this.fileHistory.replace("project", this.encode(projectName)).replace("branch", this.encode(revision)).replace("file", this.encode(fileName)).toString());
            }
            return null;
        }

        @Override
        public WebLinkInfo getFileWebLink(String projectName, String revision, String fileName) {
            if (this.file != null) {
                return this.link(this.file.replace("project", this.encode(projectName)).replace("commit", this.encode(revision)).replace("file", this.encode(fileName)).toString());
            }
            return null;
        }

        @Override
        public WebLinkInfo getPatchSetWebLink(String projectName, String commit) {
            if (this.revision != null) {
                return this.link(this.revision.replace("project", this.encode(projectName)).replace("commit", this.encode(commit)).toString());
            }
            return null;
        }

        @Override
        public WebLinkInfo getParentWebLink(String projectName, String commit) {
            return this.getPatchSetWebLink(projectName, commit);
        }

        @Override
        public WebLinkInfo getProjectWeblink(String projectName) {
            if (this.project != null) {
                return this.link(this.project.replace("project", this.encode(projectName)).toString());
            }
            return null;
        }

        private String encode(String val) {
            if (this.type.getUrlEncode()) {
                return Url.encode(this.type.replacePathSeparator(val));
            }
            return val;
        }

        private WebLinkInfo link(String rest) {
            return new WebLinkInfo(this.type.getLinkName(), null, this.url + rest, null);
        }

        private static ParameterizedString parse(String pattern) {
            if (!Strings.isNullOrEmpty(pattern)) {
                return new ParameterizedString(pattern);
            }
            return null;
        }
    }

    public static class LegacyModule
    extends AbstractModule {
        private final Config cfg;

        public LegacyModule(Config cfg) {
            this.cfg = cfg;
        }

        @Override
        protected void configure() {
            GitwebType type = GitwebConfig.typeFromConfig(this.cfg);
            if (type != null) {
                this.bind(GitwebType.class).toInstance(type);
                if (!Strings.isNullOrEmpty(type.getBranch())) {
                    DynamicSet.bind(this.binder(), BranchWebLink.class).to(GitwebLinks.class);
                }
                if (!Strings.isNullOrEmpty(type.getTag())) {
                    DynamicSet.bind(this.binder(), TagWebLink.class).to(GitwebLinks.class);
                }
                if (!Strings.isNullOrEmpty(type.getFile()) || !Strings.isNullOrEmpty(type.getRootTree())) {
                    DynamicSet.bind(this.binder(), FileWebLink.class).to(GitwebLinks.class);
                }
                if (!Strings.isNullOrEmpty(type.getFileHistory())) {
                    DynamicSet.bind(this.binder(), FileHistoryWebLink.class).to(GitwebLinks.class);
                }
                if (!Strings.isNullOrEmpty(type.getRevision())) {
                    DynamicSet.bind(this.binder(), PatchSetWebLink.class).to(GitwebLinks.class);
                    DynamicSet.bind(this.binder(), ParentWebLink.class).to(GitwebLinks.class);
                }
                if (!Strings.isNullOrEmpty(type.getProject())) {
                    DynamicSet.bind(this.binder(), ProjectWebLink.class).to(GitwebLinks.class);
                }
            }
        }
    }
}

