/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.fixes;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LineIdentifier {
    private static final Pattern LINE_SEPARATOR_PATTERN = Pattern.compile("\\R");
    private final Matcher lineSeparatorMatcher;
    private int nextLineNumber;
    private int nextLineStartIndex;
    private int currentLineStartIndex;
    private int currentLineEndIndex;

    LineIdentifier(String string) {
        Preconditions.checkNotNull(string);
        this.lineSeparatorMatcher = LINE_SEPARATOR_PATTERN.matcher(string);
        this.reset();
    }

    public int getStartIndexOfLine(int lineNumber) {
        this.findLine(lineNumber);
        return this.currentLineStartIndex;
    }

    public int getLengthOfLine(int lineNumber) {
        this.findLine(lineNumber);
        return this.currentLineEndIndex - this.currentLineStartIndex;
    }

    private void findLine(int targetLineNumber) {
        if (targetLineNumber <= 0) {
            throw new StringIndexOutOfBoundsException("Line number must be positive");
        }
        if (targetLineNumber < this.nextLineNumber) {
            this.reset();
        }
        while (this.nextLineNumber < targetLineNumber + 1 && this.lineSeparatorMatcher.find()) {
            this.currentLineStartIndex = this.nextLineStartIndex;
            this.currentLineEndIndex = this.lineSeparatorMatcher.start();
            this.nextLineStartIndex = this.lineSeparatorMatcher.end();
            ++this.nextLineNumber;
        }
        if (this.nextLineNumber == targetLineNumber) {
            this.currentLineStartIndex = this.nextLineStartIndex;
            this.currentLineEndIndex = this.lineSeparatorMatcher.regionEnd();
        }
        if (this.nextLineNumber < targetLineNumber) {
            throw new StringIndexOutOfBoundsException(String.format("Line %d isn't available", targetLineNumber));
        }
    }

    private void reset() {
        this.nextLineNumber = 1;
        this.nextLineStartIndex = 0;
        this.currentLineStartIndex = 0;
        this.currentLineEndIndex = 0;
        this.lineSeparatorMatcher.reset();
    }
}

