/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.receive;

import com.google.common.base.Preconditions;
import com.google.gerrit.server.git.receive.HookUtil;
import java.util.Map;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.BaseReceivePack;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;

class AllRefsWatcher
implements AdvertiseRefsHook {
    private Map<String, Ref> allRefs;

    AllRefsWatcher() {
    }

    @Override
    public void advertiseRefs(BaseReceivePack rp) throws ServiceMayNotContinueException {
        this.allRefs = HookUtil.ensureAllRefsAdvertised(rp);
    }

    @Override
    public void advertiseRefs(UploadPack uploadPack) {
        throw new UnsupportedOperationException();
    }

    Map<String, Ref> getAllRefs() {
        Preconditions.checkState(this.allRefs != null, "getAllRefs() only valid after refs were advertised");
        return this.allRefs;
    }
}

