/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.receive;

import com.google.common.collect.SetMultimap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.Capable;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.HackPushNegotiateHook;
import com.google.gerrit.server.git.MultiProgressMonitor;
import com.google.gerrit.server.git.ProjectRunnable;
import com.google.gerrit.server.git.TransferConfig;
import com.google.gerrit.server.git.VisibleRefFilter;
import com.google.gerrit.server.git.receive.AllRefsWatcher;
import com.google.gerrit.server.git.receive.LazyPostReceiveHookChain;
import com.google.gerrit.server.git.receive.MessageSender;
import com.google.gerrit.server.git.receive.ReceiveCommits;
import com.google.gerrit.server.git.receive.ReceiveCommitsAdvertiseRefsHook;
import com.google.gerrit.server.git.receive.ReceiveCommitsExecutor;
import com.google.gerrit.server.git.receive.ReceiveConfig;
import com.google.gerrit.server.git.receive.ReceiveRefFilter;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.project.ContributorAgreementsChecker;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gerrit.server.util.MagicBranch;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.inject.Inject;
import com.google.inject.PrivateModule;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.AdvertiseRefsHookChain;
import org.eclipse.jgit.transport.PreReceiveHook;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncReceiveCommits
implements PreReceiveHook {
    private static final Logger log = LoggerFactory.getLogger(AsyncReceiveCommits.class);
    private static final String TIMEOUT_NAME = "ReceiveCommitsOverallTimeout";
    private final ReceiveCommits rc;
    private final ReceivePack rp;
    private final ExecutorService executor;
    private final RequestScopePropagator scopePropagator;
    private final ReceiveConfig receiveConfig;
    private final ContributorAgreementsChecker contributorAgreements;
    private final long timeoutMillis;
    private final ProjectControl projectControl;
    private final Repository repo;
    private final AllRefsWatcher allRefsWatcher;

    @Inject
    AsyncReceiveCommits(ReceiveCommits.Factory factory, PermissionBackend permissionBackend, VisibleRefFilter.Factory refFilterFactory, Provider<InternalChangeQuery> queryProvider, @ReceiveCommitsExecutor ExecutorService executor, RequestScopePropagator scopePropagator, ReceiveConfig receiveConfig, TransferConfig transferConfig, Provider<LazyPostReceiveHookChain> lazyPostReceive, ContributorAgreementsChecker contributorAgreements, @Named(value="ReceiveCommitsOverallTimeout") long timeoutMillis, @Assisted ProjectControl projectControl, @Assisted Repository repo, @Assisted @Nullable MessageSender messageSender, @Assisted SetMultimap<ReviewerStateInternal, Account.Id> extraReviewers) throws PermissionBackendException {
        this.executor = executor;
        this.scopePropagator = scopePropagator;
        this.receiveConfig = receiveConfig;
        this.contributorAgreements = contributorAgreements;
        this.timeoutMillis = timeoutMillis;
        this.projectControl = projectControl;
        this.repo = repo;
        IdentifiedUser user = projectControl.getUser().asIdentifiedUser();
        ProjectState state = projectControl.getProjectState();
        Project.NameKey projectName = projectControl.getProject().getNameKey();
        this.rp = new ReceivePack(repo);
        this.rp.setAllowCreates(true);
        this.rp.setAllowDeletes(true);
        this.rp.setAllowNonFastForwards(true);
        this.rp.setRefLogIdent(user.newRefLogIdent());
        this.rp.setTimeout(transferConfig.getTimeout());
        this.rp.setMaxObjectSizeLimit(state.getEffectiveMaxObjectSizeLimit().value);
        this.rp.setCheckReceivedObjects(state.getConfig().getCheckReceivedObjects());
        this.rp.setRefFilter(new ReceiveRefFilter());
        this.rp.setAllowPushOptions(true);
        this.rp.setPreReceiveHook(this);
        this.rp.setPostReceiveHook(lazyPostReceive.get());
        try {
            permissionBackend.user(user).project(projectName).check(ProjectPermission.READ);
        }
        catch (AuthException e) {
            this.rp.setCheckReferencedObjectsAreReachable(receiveConfig.checkReferencedObjectsAreReachable);
        }
        ArrayList<AdvertiseRefsHook> advHooks = new ArrayList<AdvertiseRefsHook>(4);
        this.allRefsWatcher = new AllRefsWatcher();
        advHooks.add(this.allRefsWatcher);
        advHooks.add(refFilterFactory.create(state, repo).setShowMetadata(false));
        advHooks.add(new ReceiveCommitsAdvertiseRefsHook(queryProvider, projectName));
        advHooks.add(new HackPushNegotiateHook());
        this.rp.setAdvertiseRefsHook(AdvertiseRefsHookChain.newChain(advHooks));
        this.rc = factory.create(projectControl, this.rp, this.allRefsWatcher, extraReviewers);
        this.rc.init();
        this.rc.setMessageSender(messageSender);
    }

    public Capable canUpload() throws IOException {
        Capable result = this.projectControl.canPushToAtLeastOneRef();
        if (result != Capable.OK) {
            return result;
        }
        try {
            this.contributorAgreements.check(this.projectControl.getProject().getNameKey(), this.projectControl.getUser());
        }
        catch (AuthException e) {
            return new Capable(e.getMessage());
        }
        if (this.receiveConfig.checkMagicRefs) {
            return MagicBranch.checkMagicBranchRefs(this.repo, this.projectControl.getProject());
        }
        return Capable.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPreReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
        if (commands.stream().anyMatch(c -> c.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED)) {
            return;
        }
        Worker w = new Worker(commands);
        try {
            w.progress.waitFor(this.executor.submit(this.scopePropagator.wrap(w)), this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            log.warn("Error in ReceiveCommits while processing changes for project {}", (Object)this.projectControl.getProject().getName(), (Object)e);
            rp.sendError("internal error while processing changes");
            for (ReceiveCommand c2 : commands) {
                if (c2.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                c2.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "internal error");
            }
        }
        finally {
            w.sendMessages();
        }
    }

    public ReceivePack getReceivePack() {
        return this.rp;
    }

    private class Worker
    implements ProjectRunnable {
        final MultiProgressMonitor progress;
        private final Collection<ReceiveCommand> commands;

        private Worker(Collection<ReceiveCommand> commands) {
            this.commands = commands;
            this.progress = new MultiProgressMonitor(new MessageSenderOutputStream(), "Processing changes");
        }

        @Override
        public void run() {
            AsyncReceiveCommits.this.rc.processCommands(this.commands, this.progress);
        }

        @Override
        public Project.NameKey getProjectNameKey() {
            return AsyncReceiveCommits.this.rc.getProject().getNameKey();
        }

        @Override
        public String getRemoteName() {
            return null;
        }

        @Override
        public boolean hasCustomizedPrint() {
            return true;
        }

        public String toString() {
            return "receive-commits";
        }

        void sendMessages() {
            AsyncReceiveCommits.this.rc.sendMessages();
        }

        private class MessageSenderOutputStream
        extends OutputStream {
            private MessageSenderOutputStream() {
            }

            @Override
            public void write(int b) {
                AsyncReceiveCommits.this.rc.getMessageSender().sendBytes(new byte[]{(byte)b});
            }

            @Override
            public void write(byte[] what, int off, int len) {
                AsyncReceiveCommits.this.rc.getMessageSender().sendBytes(what, off, len);
            }

            @Override
            public void write(byte[] what) {
                AsyncReceiveCommits.this.rc.getMessageSender().sendBytes(what);
            }

            @Override
            public void flush() {
                AsyncReceiveCommits.this.rc.getMessageSender().flush();
            }
        }
    }

    public static class Module
    extends PrivateModule {
        @Override
        public void configure() {
            this.install(new FactoryModuleBuilder().build(Factory.class));
            this.expose(Factory.class);
            this.install(new FactoryModuleBuilder().build(ReceiveCommits.Factory.class));
        }

        @Provides
        @Singleton
        @Named(value="ReceiveCommitsOverallTimeout")
        long getTimeoutMillis(@GerritServerConfig Config cfg) {
            return ConfigUtil.getTimeUnit(cfg, "receive", null, "timeout", TimeUnit.MINUTES.toMillis(4L), TimeUnit.MILLISECONDS);
        }
    }

    public static interface Factory {
        public AsyncReceiveCommits create(ProjectControl var1, Repository var2, @Nullable MessageSender var3, SetMultimap<ReviewerStateInternal, Account.Id> var4);
    }
}

