/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.receive;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.gerrit.common.FooterConstants;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.extensions.api.changes.HashtagsInput;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.api.changes.SubmitInput;
import com.google.gerrit.extensions.api.projects.ProjectConfigEntryType;
import com.google.gerrit.extensions.client.GeneralPreferencesInfo;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.Sequences;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.account.AccountsUpdate;
import com.google.gerrit.server.change.ChangeInserter;
import com.google.gerrit.server.change.HashtagsUtil;
import com.google.gerrit.server.change.SetHashtagsOp;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.PluginConfig;
import com.google.gerrit.server.config.ProjectConfigEntry;
import com.google.gerrit.server.edit.ChangeEdit;
import com.google.gerrit.server.edit.ChangeEditUtil;
import com.google.gerrit.server.events.CommitReceivedEvent;
import com.google.gerrit.server.git.BanCommit;
import com.google.gerrit.server.git.ChangeReportFormatter;
import com.google.gerrit.server.git.GroupCollector;
import com.google.gerrit.server.git.MergeOp;
import com.google.gerrit.server.git.MergeOpRepoManager;
import com.google.gerrit.server.git.MergedByPushOp;
import com.google.gerrit.server.git.MultiProgressMonitor;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.git.ReceivePackInitializer;
import com.google.gerrit.server.git.SubmoduleException;
import com.google.gerrit.server.git.SubmoduleOp;
import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.ValidationError;
import com.google.gerrit.server.git.receive.AllRefsWatcher;
import com.google.gerrit.server.git.receive.ChangeProgressOp;
import com.google.gerrit.server.git.receive.MessageSender;
import com.google.gerrit.server.git.receive.ReceiveConfig;
import com.google.gerrit.server.git.receive.ReplaceOp;
import com.google.gerrit.server.git.validators.CommitValidationException;
import com.google.gerrit.server.git.validators.CommitValidationMessage;
import com.google.gerrit.server.git.validators.CommitValidators;
import com.google.gerrit.server.git.validators.RefOperationValidationException;
import com.google.gerrit.server.git.validators.RefOperationValidators;
import com.google.gerrit.server.git.validators.ValidationMessage;
import com.google.gerrit.server.index.change.ChangeIndexer;
import com.google.gerrit.server.mail.MailUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.CreateRefControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gerrit.server.ssh.SshInfo;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.RepoContext;
import com.google.gerrit.server.update.RepoOnlyOp;
import com.google.gerrit.server.update.UpdateException;
import com.google.gerrit.server.util.LabelVote;
import com.google.gerrit.server.util.MagicBranch;
import com.google.gerrit.server.util.RequestId;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.gerrit.util.cli.CmdLineParser;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.util.Providers;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.FooterLine;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReceiveCommits {
    private static final Logger log = LoggerFactory.getLogger(ReceiveCommits.class);
    private static final Function<Exception, RestApiException> INSERT_EXCEPTION = new Function<Exception, RestApiException>(){

        @Override
        public RestApiException apply(Exception input) {
            if (input instanceof RestApiException) {
                return (RestApiException)input;
            }
            if (input instanceof ExecutionException && input.getCause() instanceof RestApiException) {
                return (RestApiException)input.getCause();
            }
            return new RestApiException("Error inserting change/patchset", input);
        }
    };
    private final AccountResolver accountResolver;
    private final AccountsUpdate.Server accountsUpdate;
    private final AllProjectsName allProjectsName;
    private final BatchUpdate.Factory batchUpdateFactory;
    private final ChangeEditUtil editUtil;
    private final ChangeIndexer indexer;
    private final ChangeInserter.Factory changeInserterFactory;
    private final ChangeNotes.Factory notesFactory;
    private final CmdLineParser.Factory optionParserFactory;
    private final CommitValidators.Factory commitValidatorsFactory;
    private final DynamicMap<ProjectConfigEntry> pluginConfigEntries;
    private final DynamicSet<ReceivePackInitializer> initializers;
    private final IdentifiedUser user;
    private final MergedByPushOp.Factory mergedByPushOpFactory;
    private final NotesMigration notesMigration;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final PatchSetUtil psUtil;
    private final PermissionBackend permissionBackend;
    private final ProjectCache projectCache;
    private final Provider<InternalChangeQuery> queryProvider;
    private final Provider<MergeOp> mergeOpProvider;
    private final Provider<MergeOpRepoManager> ormProvider;
    private final ReceiveConfig receiveConfig;
    private final RefOperationValidators.Factory refValidatorsFactory;
    private final ReplaceOp.Factory replaceOpFactory;
    private final RequestScopePropagator requestScopePropagator;
    private final ReviewDb db;
    private final Sequences seq;
    private final SetHashtagsOp.Factory hashtagsFactory;
    private final SshInfo sshInfo;
    private final SubmoduleOp.Factory subOpFactory;
    private final TagCache tagCache;
    private final CreateRefControl createRefControl;
    private final AllRefsWatcher allRefsWatcher;
    private final ImmutableSetMultimap<ReviewerStateInternal, Account.Id> extraReviewers;
    private final ProjectControl projectControl;
    private final ReceivePack rp;
    private final LabelTypes labelTypes;
    private final NoteMap rejectCommits;
    private final PermissionBackend.ForProject permissions;
    private final Project project;
    private final Repository repo;
    private final RequestId receiveId;
    private final List<UpdateGroupsRequest> updateGroups;
    private final List<ValidationMessage> messages;
    private final ListMultimap<ReceiveError, String> errors;
    private final ListMultimap<String, String> pushOptions;
    private final Map<Change.Id, ReplaceRequest> replaceByChange;
    private final Set<ObjectId> validCommits;
    private final List<ReceiveCommand> actualCommands;
    private List<CreateRequest> newChanges;
    private ListMultimap<Change.Id, Ref> refsByChange;
    private ListMultimap<ObjectId, Ref> refsById;
    private MagicBranchInput magicBranch;
    private boolean newChangeForAllNotInTarget;
    private String setFullNameTo;
    private boolean setChangeAsPrivate;
    private MultiProgressMonitor.Task newProgress;
    private MultiProgressMonitor.Task replaceProgress;
    private MultiProgressMonitor.Task closeProgress;
    private MultiProgressMonitor.Task commandProgress;
    private MessageSender messageSender;
    private final ChangeReportFormatter changeFormatter;

    @Inject
    ReceiveCommits(AccountResolver accountResolver, AccountsUpdate.Server accountsUpdate, AllProjectsName allProjectsName, BatchUpdate.Factory batchUpdateFactory, ChangeEditUtil editUtil, ChangeIndexer indexer, ChangeInserter.Factory changeInserterFactory, ChangeNotes.Factory notesFactory, CmdLineParser.Factory optionParserFactory, CommitValidators.Factory commitValidatorsFactory, DynamicMap<ProjectConfigEntry> pluginConfigEntries, DynamicSet<ReceivePackInitializer> initializers, MergedByPushOp.Factory mergedByPushOpFactory, NotesMigration notesMigration, PatchSetInfoFactory patchSetInfoFactory, PatchSetUtil psUtil, PermissionBackend permissionBackend, ProjectCache projectCache, Provider<InternalChangeQuery> queryProvider, Provider<MergeOp> mergeOpProvider, Provider<MergeOpRepoManager> ormProvider, ReceiveConfig receiveConfig, RefOperationValidators.Factory refValidatorsFactory, ReplaceOp.Factory replaceOpFactory, RequestScopePropagator requestScopePropagator, ReviewDb db, Sequences seq, SetHashtagsOp.Factory hashtagsFactory, SshInfo sshInfo, SubmoduleOp.Factory subOpFactory, TagCache tagCache, CreateRefControl createRefControl, DynamicItem<ChangeReportFormatter> changeFormatterProvider, @Assisted ProjectControl projectControl, @Assisted ReceivePack rp, @Assisted AllRefsWatcher allRefsWatcher, @Assisted SetMultimap<ReviewerStateInternal, Account.Id> extraReviewers) throws IOException {
        this.accountResolver = accountResolver;
        this.accountsUpdate = accountsUpdate;
        this.allProjectsName = allProjectsName;
        this.batchUpdateFactory = batchUpdateFactory;
        this.changeInserterFactory = changeInserterFactory;
        this.commitValidatorsFactory = commitValidatorsFactory;
        this.changeFormatter = changeFormatterProvider.get();
        this.user = projectControl.getUser().asIdentifiedUser();
        this.db = db;
        this.editUtil = editUtil;
        this.hashtagsFactory = hashtagsFactory;
        this.indexer = indexer;
        this.initializers = initializers;
        this.mergeOpProvider = mergeOpProvider;
        this.mergedByPushOpFactory = mergedByPushOpFactory;
        this.notesFactory = notesFactory;
        this.notesMigration = notesMigration;
        this.optionParserFactory = optionParserFactory;
        this.ormProvider = ormProvider;
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.permissionBackend = permissionBackend;
        this.pluginConfigEntries = pluginConfigEntries;
        this.projectCache = projectCache;
        this.psUtil = psUtil;
        this.queryProvider = queryProvider;
        this.receiveConfig = receiveConfig;
        this.refValidatorsFactory = refValidatorsFactory;
        this.replaceOpFactory = replaceOpFactory;
        this.requestScopePropagator = requestScopePropagator;
        this.seq = seq;
        this.sshInfo = sshInfo;
        this.subOpFactory = subOpFactory;
        this.tagCache = tagCache;
        this.createRefControl = createRefControl;
        this.allRefsWatcher = allRefsWatcher;
        this.extraReviewers = ImmutableSetMultimap.copyOf(extraReviewers);
        this.projectControl = projectControl;
        this.rp = rp;
        this.repo = rp.getRepository();
        this.project = projectControl.getProject();
        this.labelTypes = projectControl.getProjectState().getLabelTypes();
        this.permissions = permissionBackend.user(this.user).project(this.project.getNameKey());
        this.receiveId = RequestId.forProject(this.project.getNameKey());
        this.rejectCommits = BanCommit.loadRejectCommitsMap(rp.getRepository(), rp.getRevWalk());
        this.actualCommands = new ArrayList<ReceiveCommand>();
        this.errors = LinkedListMultimap.create();
        this.messages = new ArrayList<ValidationMessage>();
        this.pushOptions = LinkedListMultimap.create();
        this.replaceByChange = new LinkedHashMap<Change.Id, ReplaceRequest>();
        this.updateGroups = new ArrayList<UpdateGroupsRequest>();
        this.validCommits = new HashSet<ObjectId>();
        this.newChanges = Collections.emptyList();
        this.newChangeForAllNotInTarget = projectControl.getProjectState().isCreateNewChangeForAllNotInTarget();
        this.messageSender = new ReceivePackMessageSender();
    }

    void init() {
        for (ReceivePackInitializer i : this.initializers) {
            i.init(this.projectControl.getProject().getNameKey(), this.rp);
        }
    }

    void setMessageSender(MessageSender ms) {
        this.messageSender = ms != null ? ms : new ReceivePackMessageSender();
    }

    MessageSender getMessageSender() {
        if (this.messageSender == null) {
            this.setMessageSender(null);
        }
        return this.messageSender;
    }

    Project getProject() {
        return this.project;
    }

    private void addMessage(String message) {
        this.messages.add(new CommitValidationMessage(message, false));
    }

    void addError(String error) {
        this.messages.add(new CommitValidationMessage(error, true));
    }

    void sendMessages() {
        for (ValidationMessage m : this.messages) {
            if (m.isError()) {
                this.messageSender.sendError(m.getMessage());
                continue;
            }
            this.messageSender.sendMessage(m.getMessage());
        }
    }

    void processCommands(Collection<ReceiveCommand> commands, MultiProgressMonitor progress) {
        this.newProgress = progress.beginSubTask("new", 0);
        this.replaceProgress = progress.beginSubTask("updated", 0);
        this.closeProgress = progress.beginSubTask("closed", 0);
        this.commandProgress = progress.beginSubTask("refs", 0);
        try {
            this.parseCommands(commands);
        }
        catch (PermissionBackendException | NoSuchProjectException | IOException err) {
            for (ReceiveCommand cmd : this.actualCommands) {
                if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "internal server error");
            }
            this.logError(String.format("Failed to process refs in %s", this.project.getName()), err);
        }
        if (this.magicBranch != null && this.magicBranch.cmd.getResult() == ReceiveCommand.Result.NOT_ATTEMPTED) {
            this.selectNewAndReplacedChangesFromMagicBranch();
        }
        this.preparePatchSetsForReplace();
        this.insertChangesAndPatchSets();
        this.newProgress.end();
        this.replaceProgress.end();
        if (!this.errors.isEmpty()) {
            this.logDebug("Handling error conditions: {}", this.errors.keySet());
            for (Object error : this.errors.keySet()) {
                this.rp.sendMessage(this.buildError((ReceiveError)((Object)error), (List<String>)this.errors.get(error)));
            }
            this.rp.sendMessage(String.format("User: %s", ReceiveCommits.displayName(this.user)));
            this.rp.sendMessage("Please read the documentation and contact an administrator\nif you feel the configuration is incorrect");
        }
        HashSet<Branch.NameKey> branches = new HashSet<Branch.NameKey>();
        for (ReceiveCommand c : this.actualCommands) {
            if (c.getResult() != ReceiveCommand.Result.OK || !ReceiveCommits.isHead(c) && !ReceiveCommits.isConfig(c)) continue;
            switch (c.getType()) {
                case CREATE: 
                case UPDATE: 
                case UPDATE_NONFASTFORWARD: {
                    this.autoCloseChanges(c);
                    branches.add(new Branch.NameKey(this.project.getNameKey(), c.getRefName()));
                    break;
                }
            }
        }
        if (!branches.isEmpty()) {
            try (MergeOpRepoManager orm = this.ormProvider.get();){
                orm.setContext(this.db, TimeUtil.nowTs(), this.user, this.receiveId);
                SubmoduleOp op = this.subOpFactory.create(branches, orm);
                op.updateSuperProjects();
            }
            catch (SubmoduleException e) {
                this.logError("Can't update the superprojects", e);
            }
        }
        this.updateAccountInfo();
        this.closeProgress.end();
        this.commandProgress.end();
        progress.end();
        this.reportMessages();
    }

    private void reportMessages() {
        List updated;
        List created = this.newChanges.stream().filter(r -> r.change != null).collect(Collectors.toList());
        if (!created.isEmpty()) {
            this.addMessage("");
            this.addMessage("New Changes:");
            for (CreateRequest c : created) {
                this.addMessage(this.changeFormatter.newChange(ChangeReportFormatter.Input.builder().setChange(c.change).build()));
            }
            this.addMessage("");
        }
        if (!(updated = this.replaceByChange.values().stream().filter(r -> !r.skip && r.inputCommand.getResult() == ReceiveCommand.Result.OK).sorted(Comparator.comparingInt(r -> r.notes.getChangeId().get())).collect(Collectors.toList())).isEmpty()) {
            this.addMessage("");
            this.addMessage("Updated Changes:");
            boolean edit = this.magicBranch != null && (this.magicBranch.edit || this.magicBranch.draft);
            for (ReplaceRequest u : updated) {
                String subject;
                Change change = u.notes.getChange();
                if (edit) {
                    try {
                        subject = this.rp.getRevWalk().parseCommit(u.newCommitId).getShortMessage();
                    }
                    catch (IOException e) {
                        this.logWarn("failed to get subject for edit patch set", e);
                        subject = change.getSubject();
                    }
                } else {
                    subject = u.info.getSubject();
                }
                boolean isPrivate = change.isPrivate();
                boolean wip = change.isWorkInProgress();
                if (this.magicBranch != null) {
                    if (this.magicBranch.isPrivate) {
                        isPrivate = true;
                    } else if (this.magicBranch.removePrivate) {
                        isPrivate = false;
                    }
                    if (this.magicBranch.workInProgress) {
                        wip = true;
                    } else if (this.magicBranch.ready) {
                        wip = false;
                    }
                }
                ChangeReportFormatter.Input input = ChangeReportFormatter.Input.builder().setChange(change).setSubject(subject).setIsEdit(edit).setIsPrivate(isPrivate).setIsWorkInProgress(wip).build();
                this.addMessage(this.changeFormatter.changeUpdated(input));
            }
            this.addMessage("");
        }
        if (this.magicBranch != null && this.magicBranch.publish) {
            this.addMessage("Pushing to refs/publish/* is deprecated, use refs/for/* instead.");
        }
    }

    private void insertChangesAndPatchSets() {
        ReceiveCommand magicBranchCmd;
        ReceiveCommand receiveCommand = magicBranchCmd = this.magicBranch != null ? this.magicBranch.cmd : null;
        if (magicBranchCmd != null && magicBranchCmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
            this.logWarn(String.format("Skipping change updates on %s because ref update failed: %s %s", new Object[]{this.project.getName(), magicBranchCmd.getResult(), Strings.nullToEmpty(magicBranchCmd.getMessage())}));
            return;
        }
        try (BatchUpdate bu = this.batchUpdateFactory.create(this.db, this.project.getNameKey(), this.user.materializedCopy(), TimeUtil.nowTs());
             ObjectInserter ins = this.repo.newObjectInserter();
             ObjectReader reader = ins.newReader();
             RevWalk rw = new RevWalk(reader);){
            bu.setRepository(this.repo, rw, ins).updateChangesInParallel();
            bu.setRequestId(this.receiveId);
            bu.setRefLogMessage("push");
            this.logDebug("Adding {} replace requests", this.newChanges.size());
            for (ReplaceRequest replace : this.replaceByChange.values()) {
                replace.addOps(bu, this.replaceProgress);
            }
            this.logDebug("Adding {} create requests", this.newChanges.size());
            for (CreateRequest create : this.newChanges) {
                create.addOps(bu);
            }
            this.logDebug("Adding {} group update requests", this.newChanges.size());
            this.updateGroups.forEach(r -> ((UpdateGroupsRequest)r).addOps(bu));
            this.logDebug("Adding {} additional ref updates", this.actualCommands.size());
            this.actualCommands.forEach(c -> bu.addRepoOnlyOp(new UpdateOneRefOp((ReceiveCommand)c)));
            this.logDebug("Executing batch", new Object[0]);
            try {
                bu.execute();
            }
            catch (UpdateException e) {
                throw INSERT_EXCEPTION.apply(e);
            }
            if (magicBranchCmd != null) {
                magicBranchCmd.setResult(ReceiveCommand.Result.OK);
            }
            for (ReplaceRequest replace : this.replaceByChange.values()) {
                String rejectMessage = replace.getRejectMessage();
                if (rejectMessage == null) {
                    if (replace.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                    replace.inputCommand.setResult(ReceiveCommand.Result.OK);
                    continue;
                }
                this.logDebug("Rejecting due to message from ReplaceOp", new Object[0]);
                this.reject(replace.inputCommand, rejectMessage);
            }
        }
        catch (ResourceConflictException e) {
            this.addMessage(e.getMessage());
            this.reject(magicBranchCmd, "conflict");
        }
        catch (RestApiException | IOException err) {
            this.logError("Can't insert change/patch set for " + this.project.getName(), err);
            this.reject(magicBranchCmd, "internal server error: " + err.getMessage());
        }
        if (this.magicBranch != null && this.magicBranch.submit) {
            try {
                this.submit(this.newChanges, this.replaceByChange.values());
            }
            catch (ResourceConflictException e) {
                this.addMessage(e.getMessage());
                this.reject(magicBranchCmd, "conflict");
            }
            catch (RestApiException | PermissionBackendException | UpdateException | OrmException | IOException | ConfigInvalidException e) {
                this.logError("Error submitting changes to " + this.project.getName(), e);
                this.reject(magicBranchCmd, "error during submit");
            }
        }
    }

    private String buildError(ReceiveError error, List<String> branches) {
        StringBuilder sb = new StringBuilder();
        if (branches.size() == 1) {
            sb.append("Branch ").append(branches.get(0)).append(":\n");
            sb.append(error.get());
            return sb.toString();
        }
        sb.append("Branches");
        String delim = " ";
        for (String branch : branches) {
            sb.append(delim).append(branch);
            delim = ", ";
        }
        return sb.append(":\n").append(error.get()).toString();
    }

    private static String displayName(IdentifiedUser user) {
        String displayName = user.getUserName();
        if (displayName == null) {
            displayName = user.getAccount().getPreferredEmail();
        }
        return displayName;
    }

    private void parseCommands(Collection<ReceiveCommand> commands) throws PermissionBackendException, NoSuchProjectException, IOException {
        List<String> optionList = this.rp.getPushOptions();
        if (optionList != null) {
            for (String option : optionList) {
                int e = option.indexOf(61);
                if (e > 0) {
                    this.pushOptions.put(option.substring(0, e), option.substring(e + 1));
                    continue;
                }
                this.pushOptions.put(option, "");
            }
        }
        this.logDebug("Parsing {} commands", commands.size());
        block15: for (ReceiveCommand cmd : commands) {
            Matcher m;
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
                this.logDebug("Already processed by core: {} {}", new Object[]{cmd.getResult(), cmd});
                continue;
            }
            if (!Repository.isValidRefName(cmd.getRefName()) || cmd.getRefName().contains("//")) {
                this.reject(cmd, "not valid ref");
                continue;
            }
            if (MagicBranch.isMagicBranch(cmd.getRefName())) {
                this.parseMagicBranch(cmd);
                continue;
            }
            if (this.projectControl.getProjectState().isAllUsers() && "refs/users/self".equals(cmd.getRefName())) {
                String newName = RefNames.refsUsers(this.user.getAccountId());
                this.logDebug("Swapping out command for {} to {}", "refs/users/self", newName);
                final ReceiveCommand orgCmd = cmd;
                cmd = new ReceiveCommand(cmd.getOldId(), cmd.getNewId(), newName, cmd.getType()){

                    @Override
                    public void setResult(ReceiveCommand.Result s, String m) {
                        super.setResult(s, m);
                        orgCmd.setResult(s, m);
                    }
                };
            }
            if ((m = CommitValidators.NEW_PATCHSET_PATTERN.matcher(cmd.getRefName())).matches()) {
                Change.Id changeId = Change.Id.parse(m.group(1));
                this.parseReplaceCommand(cmd, changeId);
                continue;
            }
            switch (cmd.getType()) {
                case CREATE: {
                    this.parseCreate(cmd);
                    break;
                }
                case UPDATE: {
                    this.parseUpdate(cmd);
                    break;
                }
                case DELETE: {
                    this.parseDelete(cmd);
                    break;
                }
                case UPDATE_NONFASTFORWARD: {
                    this.parseRewind(cmd);
                    break;
                }
                default: {
                    this.reject(cmd, "prohibited by Gerrit: unknown command type " + (Object)((Object)cmd.getType()));
                    continue block15;
                }
            }
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED || !ReceiveCommits.isConfig(cmd)) continue;
            this.logDebug("Processing {} command", cmd.getRefName());
            if (!this.projectControl.isOwner()) {
                this.reject(cmd, "not project owner");
                continue;
            }
            switch (cmd.getType()) {
                case CREATE: 
                case UPDATE: 
                case UPDATE_NONFASTFORWARD: {
                    try {
                        ProjectConfig cfg = new ProjectConfig(this.project.getNameKey());
                        cfg.load(this.rp.getRevWalk(), cmd.getNewId());
                        if (!cfg.getValidationErrors().isEmpty()) {
                            this.addError("Invalid project configuration:");
                            for (ValidationError err : cfg.getValidationErrors()) {
                                this.addError("  " + err.getMessage());
                            }
                            this.reject(cmd, "invalid project configuration");
                            this.logError("User " + this.user.getUserName() + " tried to push invalid project configuration " + cmd.getNewId().name() + " for " + this.project.getName());
                            continue block15;
                        }
                        Project.NameKey newParent = cfg.getProject().getParent(this.allProjectsName);
                        Project.NameKey oldParent = this.project.getParent(this.allProjectsName);
                        if (oldParent == null) {
                            if (newParent != null) {
                                this.reject(cmd, "invalid project configuration: root project cannot have parent");
                                continue block15;
                            }
                        } else {
                            if (!oldParent.equals(newParent)) {
                                try {
                                    this.permissionBackend.user(this.user).check(GlobalPermission.ADMINISTRATE_SERVER);
                                }
                                catch (AuthException e) {
                                    this.reject(cmd, "invalid project configuration: only Gerrit admin can set parent");
                                    continue block15;
                                }
                            }
                            if (this.projectCache.get(newParent) == null) {
                                this.reject(cmd, "invalid project configuration: parent does not exist");
                                continue block15;
                            }
                        }
                        for (DynamicMap.Entry<ProjectConfigEntry> entry : this.pluginConfigEntries) {
                            PluginConfig pluginCfg = cfg.getPluginConfig(entry.getPluginName());
                            ProjectConfigEntry configEntry = entry.getProvider().get();
                            String value = pluginCfg.getString(entry.getExportName());
                            String oldValue = this.projectControl.getProjectState().getConfig().getPluginConfig(entry.getPluginName()).getString(entry.getExportName());
                            if (configEntry.getType() == ProjectConfigEntryType.ARRAY) {
                                oldValue = Arrays.stream(this.projectControl.getProjectState().getConfig().getPluginConfig(entry.getPluginName()).getStringList(entry.getExportName())).collect(Collectors.joining("\n"));
                            }
                            if ((value == null ? oldValue != null : !value.equals(oldValue)) && !configEntry.isEditable(this.projectControl.getProjectState())) {
                                this.reject(cmd, String.format("invalid project configuration: Not allowed to set parameter '%s' of plugin '%s' on project '%s'.", entry.getExportName(), entry.getPluginName(), this.project.getName()));
                                continue;
                            }
                            if (!ProjectConfigEntryType.LIST.equals((Object)configEntry.getType()) || value == null || configEntry.getPermittedValues().contains(value)) continue;
                            this.reject(cmd, String.format("invalid project configuration: The value '%s' is not permitted for parameter '%s' of plugin '%s'.", value, entry.getExportName(), entry.getPluginName()));
                        }
                        continue block15;
                    }
                    catch (Exception e) {
                        this.reject(cmd, "invalid project configuration");
                        this.logError("User " + this.user.getUserName() + " tried to push invalid project configuration " + cmd.getNewId().name() + " for " + this.project.getName(), e);
                        continue block15;
                    }
                }
                case DELETE: {
                    break;
                }
                default: {
                    this.reject(cmd, "prohibited by Gerrit: don't know how to handle config update of type " + (Object)((Object)cmd.getType()));
                    continue block15;
                }
            }
        }
    }

    private void parseCreate(ReceiveCommand cmd) throws PermissionBackendException, NoSuchProjectException, IOException {
        RevObject obj;
        try {
            obj = this.rp.getRevWalk().parseAny(cmd.getNewId());
        }
        catch (IOException err) {
            this.logError("Invalid object " + cmd.getNewId().name() + " for " + cmd.getRefName() + " creation", err);
            this.reject(cmd, "invalid object");
            return;
        }
        this.logDebug("Creating {}", cmd);
        if (ReceiveCommits.isHead(cmd) && !this.isCommit(cmd)) {
            return;
        }
        Branch.NameKey branch = new Branch.NameKey(this.project.getName(), cmd.getRefName());
        try {
            this.createRefControl.checkCreateRef(Providers.of(this.user), this.rp.getRepository(), branch, obj);
        }
        catch (AuthException denied) {
            this.reject(cmd, "prohibited by Gerrit: " + denied.getMessage());
            return;
        }
        if (!this.validRefOperation(cmd)) {
            return;
        }
        this.validateNewCommits(new Branch.NameKey(this.project.getNameKey(), cmd.getRefName()), cmd);
        this.actualCommands.add(cmd);
    }

    private void parseUpdate(ReceiveCommand cmd) throws PermissionBackendException {
        boolean ok;
        this.logDebug("Updating {}", cmd);
        try {
            this.permissions.ref(cmd.getRefName()).check(RefPermission.UPDATE);
            ok = true;
        }
        catch (AuthException err) {
            ok = false;
        }
        if (ok) {
            if (ReceiveCommits.isHead(cmd) && !this.isCommit(cmd)) {
                return;
            }
            if (!this.validRefOperation(cmd)) {
                return;
            }
            this.validateNewCommits(new Branch.NameKey(this.project.getNameKey(), cmd.getRefName()), cmd);
            this.actualCommands.add(cmd);
        } else {
            if ("refs/meta/config".equals(cmd.getRefName())) {
                this.errors.put(ReceiveError.CONFIG_UPDATE, "refs/meta/config");
            } else {
                this.errors.put(ReceiveError.UPDATE, cmd.getRefName());
            }
            this.reject(cmd, "prohibited by Gerrit: ref update access denied");
        }
    }

    private boolean isCommit(ReceiveCommand cmd) {
        RevObject obj;
        try {
            obj = this.rp.getRevWalk().parseAny(cmd.getNewId());
        }
        catch (IOException err) {
            this.logError("Invalid object " + cmd.getNewId().name() + " for " + cmd.getRefName(), err);
            this.reject(cmd, "invalid object");
            return false;
        }
        if (obj instanceof RevCommit) {
            return true;
        }
        this.reject(cmd, "not a commit");
        return false;
    }

    private void parseDelete(ReceiveCommand cmd) throws PermissionBackendException {
        this.logDebug("Deleting {}", cmd);
        if (cmd.getRefName().startsWith("refs/changes/")) {
            this.errors.put(ReceiveError.DELETE_CHANGES, cmd.getRefName());
            this.reject(cmd, "cannot delete changes");
        } else if (this.canDelete(cmd)) {
            if (!this.validRefOperation(cmd)) {
                return;
            }
            this.actualCommands.add(cmd);
        } else if ("refs/meta/config".equals(cmd.getRefName())) {
            this.reject(cmd, "cannot delete project configuration");
        } else {
            this.errors.put(ReceiveError.DELETE, cmd.getRefName());
            this.reject(cmd, "cannot delete references");
        }
    }

    private boolean canDelete(ReceiveCommand cmd) throws PermissionBackendException {
        try {
            this.permissions.ref(cmd.getRefName()).check(RefPermission.DELETE);
            return true;
        }
        catch (AuthException e) {
            return false;
        }
    }

    private void parseRewind(ReceiveCommand cmd) throws PermissionBackendException {
        boolean ok;
        RevCommit newObject;
        try {
            newObject = this.rp.getRevWalk().parseCommit(cmd.getNewId());
        }
        catch (IncorrectObjectTypeException notCommit) {
            newObject = null;
        }
        catch (IOException err) {
            this.logError("Invalid object " + cmd.getNewId().name() + " for " + cmd.getRefName() + " forced update", err);
            this.reject(cmd, "invalid object");
            return;
        }
        this.logDebug("Rewinding {}", cmd);
        if (newObject != null) {
            this.validateNewCommits(new Branch.NameKey(this.project.getNameKey(), cmd.getRefName()), cmd);
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
                return;
            }
        }
        try {
            this.permissions.ref(cmd.getRefName()).check(RefPermission.FORCE_UPDATE);
            ok = true;
        }
        catch (AuthException err) {
            ok = false;
        }
        if (ok) {
            if (!this.validRefOperation(cmd)) {
                return;
            }
            this.actualCommands.add(cmd);
        } else {
            cmd.setResult(ReceiveCommand.Result.REJECTED_NONFASTFORWARD, " need 'Force Push' privilege.");
        }
    }

    @Nullable
    ListMultimap<String, String> getPushOptions() {
        return ImmutableListMultimap.copyOf(this.pushOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMagicBranch(ReceiveCommand cmd) throws PermissionBackendException {
        RevCommit tip;
        String ref;
        CmdLineParser clp;
        if (this.magicBranch != null) {
            this.reject(cmd, "duplicate request");
            return;
        }
        this.logDebug("Found magic branch {}", cmd.getRefName());
        this.magicBranch = new MagicBranchInput(this.user, cmd, this.labelTypes, this.notesMigration);
        this.magicBranch.reviewer.addAll(this.extraReviewers.get((Object)ReviewerStateInternal.REVIEWER));
        this.magicBranch.cc.addAll(this.extraReviewers.get((Object)ReviewerStateInternal.CC));
        this.magicBranch.clp = clp = this.optionParserFactory.create(this.magicBranch);
        try {
            ref = this.magicBranch.parse(clp, this.repo, this.rp.getAdvertisedRefs().keySet(), this.pushOptions);
        }
        catch (CmdLineException e) {
            if (!clp.wasHelpRequestedByOption()) {
                this.logDebug("Invalid branch syntax", new Object[0]);
                this.reject(cmd, e.getMessage());
                return;
            }
            ref = null;
        }
        if (this.magicBranch.topic != null && this.magicBranch.topic.length() > 2048) {
            this.reject(cmd, String.format("topic length exceeds the limit (%s)", 2048));
        }
        if (clp.wasHelpRequestedByOption()) {
            StringWriter w = new StringWriter();
            w.write("\nHelp for refs/for/branch:\n\n");
            clp.printUsage(w, null);
            this.addMessage(w.toString());
            this.reject(cmd, "see help");
            return;
        }
        if (this.projectControl.getProjectState().isAllUsers() && "refs/users/self".equals(ref)) {
            this.logDebug("Handling {}", "refs/users/self");
            ref = RefNames.refsUsers(this.user.getAccountId());
        }
        if (!(this.rp.getAdvertisedRefs().containsKey(ref) || ref.equals(ReceiveCommits.readHEAD(this.repo)) || ref.equals("refs/meta/config"))) {
            this.logDebug("Ref {} not found", ref);
            if (ref.startsWith("refs/heads/")) {
                String n = ref.substring("refs/heads/".length());
                this.reject(cmd, "branch " + n + " not found");
            } else {
                this.reject(cmd, ref + " not found");
            }
            return;
        }
        this.magicBranch.dest = new Branch.NameKey(this.project.getNameKey(), ref);
        this.magicBranch.perm = this.permissions.ref(ref);
        if (!this.projectControl.getProject().getState().permitsWrite()) {
            this.reject(cmd, "project state does not permit write");
            return;
        }
        try {
            this.magicBranch.perm.check(RefPermission.CREATE_CHANGE);
        }
        catch (AuthException denied) {
            this.errors.put(ReceiveError.CODE_REVIEW, ref);
            this.reject(cmd, denied.getMessage());
            return;
        }
        if (this.magicBranch.draft && !this.receiveConfig.allowDrafts) {
            this.errors.put(ReceiveError.CODE_REVIEW, ref);
            this.reject(cmd, "draft workflow is disabled");
            return;
        }
        if (this.magicBranch.isPrivate && this.magicBranch.removePrivate) {
            this.reject(cmd, "the options 'private' and 'remove-private' are mutually exclusive");
            return;
        }
        boolean privateByDefault = this.projectCache.get(this.project.getNameKey()).isPrivateByDefault();
        boolean bl = this.setChangeAsPrivate = this.magicBranch.draft || this.magicBranch.isPrivate || privateByDefault && !this.magicBranch.removePrivate;
        if (this.receiveConfig.disablePrivateChanges && this.setChangeAsPrivate) {
            this.reject(cmd, "private changes are disabled");
            return;
        }
        if (this.magicBranch.workInProgress && this.magicBranch.ready) {
            this.reject(cmd, "the options 'wip' and 'ready' are mutually exclusive");
            return;
        }
        if (this.magicBranch.publishComments && this.magicBranch.noPublishComments) {
            this.reject(cmd, "the options 'publish-comments' and 'no-publish-comments' are mutually exclusive");
            return;
        }
        if (this.magicBranch.submit) {
            try {
                this.permissions.ref(ref).check(RefPermission.UPDATE_BY_SUBMIT);
            }
            catch (AuthException e) {
                this.reject(cmd, e.getMessage());
                return;
            }
        }
        RevWalk walk = this.rp.getRevWalk();
        try {
            tip = walk.parseCommit(this.magicBranch.cmd.getNewId());
            this.logDebug("Tip of push: {}", tip.name());
        }
        catch (IOException ex) {
            this.magicBranch.cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT);
            this.logError("Invalid pack upload; one or more objects weren't sent", ex);
            return;
        }
        String destBranch = this.magicBranch.dest.get();
        try {
            Object branchTip;
            if (this.magicBranch.merged) {
                if (this.magicBranch.base != null) {
                    this.reject(cmd, "cannot use merged with base");
                    return;
                }
                branchTip = this.readBranchTip(cmd, this.magicBranch.dest);
                if (branchTip == null) {
                    return;
                }
                if (!walk.isMergedInto(tip, (RevCommit)branchTip)) {
                    this.reject(cmd, "not merged into branch");
                    return;
                }
            }
            if (tip.getParentCount() > 1 || this.magicBranch.base != null || this.magicBranch.merged || tip.getParentCount() == 0) {
                this.logDebug("Forcing newChangeForAllNotInTarget = false", new Object[0]);
                this.newChangeForAllNotInTarget = false;
            }
            if (this.magicBranch.base != null) {
                this.logDebug("Handling %base: {}", this.magicBranch.base);
                this.magicBranch.baseCommit = Lists.newArrayListWithCapacity(this.magicBranch.base.size());
                for (ObjectId id : this.magicBranch.base) {
                    try {
                        this.magicBranch.baseCommit.add(walk.parseCommit(id));
                    }
                    catch (IncorrectObjectTypeException notCommit) {
                        this.reject(cmd, "base must be a commit");
                        return;
                    }
                    catch (MissingObjectException e) {
                        this.reject(cmd, "base not found");
                        return;
                    }
                    catch (IOException e) {
                        this.logWarn(String.format("Project %s cannot read %s", this.project.getName(), id.name()), e);
                        this.reject(cmd, "internal server error");
                        return;
                    }
                }
            } else if (this.newChangeForAllNotInTarget) {
                branchTip = this.readBranchTip(cmd, this.magicBranch.dest);
                if (branchTip == null) {
                    return;
                }
                this.magicBranch.baseCommit = Collections.singletonList(branchTip);
                this.logDebug("Set baseCommit = {}", this.magicBranch.baseCommit.get(0).name());
            }
        }
        catch (IOException ex) {
            this.logWarn(String.format("Error walking to %s in project %s", destBranch, this.project.getName()), ex);
            this.reject(cmd, "internal server error");
            return;
        }
        try {
            Ref targetRef = this.rp.getAdvertisedRefs().get(this.magicBranch.dest.get());
            if (targetRef == null || targetRef.getObjectId() == null) {
                this.logDebug("Branch is unborn", new Object[0]);
                return;
            }
            RevCommit h = walk.parseCommit(targetRef.getObjectId());
            this.logDebug("Current branch tip: {}", h.name());
            RevFilter oldRevFilter = walk.getRevFilter();
            try {
                walk.reset();
                walk.setRevFilter(RevFilter.MERGE_BASE);
                walk.markStart(tip);
                walk.markStart(h);
                if (walk.next() == null) {
                    this.reject(this.magicBranch.cmd, "no common ancestry");
                }
            }
            finally {
                walk.reset();
                walk.setRevFilter(oldRevFilter);
            }
        }
        catch (IOException e) {
            this.magicBranch.cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT);
            this.logError("Invalid pack upload; one or more objects weren't sent", e);
        }
    }

    private static String readHEAD(Repository repo) {
        try {
            return repo.getFullBranch();
        }
        catch (IOException e) {
            log.error("Cannot read HEAD symref", e);
            return null;
        }
    }

    private RevCommit readBranchTip(ReceiveCommand cmd, Branch.NameKey branch) throws IOException {
        Ref r = this.allRefs().get(branch.get());
        if (r == null) {
            this.reject(cmd, branch.get() + " not found");
            return null;
        }
        return this.rp.getRevWalk().parseCommit(r.getObjectId());
    }

    private void parseReplaceCommand(ReceiveCommand cmd, Change.Id changeId) {
        Change changeEnt;
        RevCommit newCommit;
        this.logDebug("Parsing replace command", new Object[0]);
        if (cmd.getType() != ReceiveCommand.Type.CREATE) {
            this.reject(cmd, "invalid usage");
            return;
        }
        try {
            newCommit = this.rp.getRevWalk().parseCommit(cmd.getNewId());
            this.logDebug("Replacing with {}", newCommit);
        }
        catch (IOException e) {
            this.logError("Cannot parse " + cmd.getNewId().name() + " as commit", e);
            this.reject(cmd, "invalid commit");
            return;
        }
        try {
            changeEnt = this.notesFactory.createChecked(this.db, this.project.getNameKey(), changeId).getChange();
        }
        catch (NoSuchChangeException e) {
            this.logError("Change not found " + changeId, e);
            this.reject(cmd, "change " + changeId + " not found");
            return;
        }
        catch (OrmException e) {
            this.logError("Cannot lookup existing change " + changeId, e);
            this.reject(cmd, "database error");
            return;
        }
        if (!this.project.getNameKey().equals(changeEnt.getProject())) {
            this.reject(cmd, "change " + changeId + " does not belong to project " + this.project.getName());
            return;
        }
        this.logDebug("Replacing change {}", changeEnt.getId());
        this.requestReplace(cmd, true, changeEnt, newCommit);
    }

    private boolean requestReplace(ReceiveCommand cmd, boolean checkMergedInto, Change change, RevCommit newCommit) {
        if (change.getStatus().isClosed()) {
            this.reject(cmd, this.changeFormatter.changeClosed(ChangeReportFormatter.Input.builder().setChange(change).build()));
            return false;
        }
        ReplaceRequest req = new ReplaceRequest(change.getId(), newCommit, cmd, checkMergedInto);
        if (this.replaceByChange.containsKey(req.ontoChange)) {
            this.reject(cmd, "duplicate request");
            return false;
        }
        this.replaceByChange.put(req.ontoChange, req);
        return true;
    }

    private void selectNewAndReplacedChangesFromMagicBranch() {
        this.logDebug("Finding new and replaced changes", new Object[0]);
        this.newChanges = new ArrayList<CreateRequest>();
        ListMultimap<ObjectId, Ref> existing = this.changeRefsById();
        GroupCollector groupCollector = GroupCollector.create(this.changeRefsById(), this.db, this.psUtil, this.notesFactory, this.project.getNameKey());
        try {
            RevCommit c;
            RevCommit start = this.setUpWalkForSelectingChanges();
            if (start == null) {
                return;
            }
            LinkedHashMap<RevCommit, ChangeLookup> pending = new LinkedHashMap<RevCommit, ChangeLookup>();
            HashSet<Change.Key> newChangeIds = new HashSet<Change.Key>();
            int maxBatchChanges = this.receiveConfig.getEffectiveMaxBatchChangesLimit(this.user);
            int total = 0;
            int alreadyTracked = 0;
            boolean rejectImplicitMerges = start.getParentCount() == 1 && this.projectCache.get(this.project.getNameKey()).isRejectImplicitMerges() && !this.magicBranch.merged;
            HashSet<RevCommit> mergedParents = rejectImplicitMerges ? new HashSet<RevCommit>() : null;
            while ((c = this.rp.getRevWalk().next()) != null) {
                List<String> idList;
                String idStr;
                boolean commitAlreadyTracked;
                ++total;
                this.rp.getRevWalk().parseBody(c);
                String name = c.name();
                groupCollector.visit(c);
                Collection existingRefs = existing.get((Object)c);
                if (rejectImplicitMerges) {
                    Collections.addAll(mergedParents, c.getParents());
                    mergedParents.remove(c);
                }
                boolean bl = commitAlreadyTracked = !existingRefs.isEmpty();
                if (commitAlreadyTracked) {
                    ++alreadyTracked;
                    for (Ref ref : existingRefs) {
                        this.updateGroups.add(new UpdateGroupsRequest(ref, c));
                    }
                    if (!this.newChangeForAllNotInTarget && this.magicBranch.base == null) continue;
                }
                String string = idStr = !(idList = c.getFooterLines(FooterConstants.CHANGE_ID)).isEmpty() ? idList.get(idList.size() - 1).trim() : null;
                if (idStr != null) {
                    pending.put(c, new ChangeLookup(c, new Change.Key(idStr)));
                } else {
                    pending.put(c, new ChangeLookup(c));
                }
                int n = pending.size() + this.newChanges.size();
                if (maxBatchChanges != 0 && n > maxBatchChanges) {
                    this.logDebug("{} changes exceeds limit of {}", n, maxBatchChanges);
                    this.reject(this.magicBranch.cmd, "the number of pushed changes in a batch exceeds the max limit " + maxBatchChanges);
                    this.newChanges = Collections.emptyList();
                    return;
                }
                if (commitAlreadyTracked) {
                    boolean changeExistsOnDestBranch = false;
                    for (ChangeData cd2 : ((ChangeLookup)pending.get((Object)c)).destChanges) {
                        if (!cd2.change().getDest().equals(this.magicBranch.dest)) continue;
                        changeExistsOnDestBranch = true;
                        break;
                    }
                    if (changeExistsOnDestBranch) continue;
                    this.logDebug("Creating new change for {} even though it is already tracked", name);
                }
                if (!this.validCommit(this.rp.getRevWalk(), this.magicBranch.perm, this.magicBranch.dest, this.magicBranch.cmd, c)) {
                    this.newChanges = Collections.emptyList();
                    this.logDebug("Aborting early due to invalid commit", new Object[0]);
                    return;
                }
                if (this.newChangeForAllNotInTarget && c.getParentCount() > 1) {
                    this.reject(this.magicBranch.cmd, "Pushing merges in commit chains with 'all not in target' is not allowed,\nto override please set the base manually");
                    this.logDebug("Rejecting merge commit {} with newChangeForAllNotInTarget", name);
                }
                if (!idList.isEmpty()) continue;
                this.newChanges.add(new CreateRequest(c, this.magicBranch.dest.get()));
            }
            this.logDebug("Finished initial RevWalk with {} commits total: {} already tracked, {} new changes with no Change-Id, and {} deferred lookups", total, alreadyTracked, this.newChanges.size(), pending.size());
            if (rejectImplicitMerges) {
                this.rejectImplicitMerges(mergedParents);
            }
            Iterator itr = pending.values().iterator();
            while (itr.hasNext()) {
                ChangeLookup p = (ChangeLookup)itr.next();
                if (p.changeKey == null) continue;
                if (newChangeIds.contains(p.changeKey)) {
                    this.logDebug("Multiple commits with Change-Id {}", p.changeKey);
                    this.reject(this.magicBranch.cmd, "same Change-Id in multiple changes.\nSquash the commits with the same Change-Id or ensure Change-Ids are unique for each commit");
                    this.newChanges = Collections.emptyList();
                    return;
                }
                List<ChangeData> changes = p.destChanges;
                if (changes.size() > 1) {
                    this.logDebug("Multiple changes in branch {} with Change-Id {}: {}", this.magicBranch.dest, p.changeKey, changes.stream().map(cd -> cd.getId().toString()).collect(Collectors.joining()));
                    this.reject(this.magicBranch.cmd, p.changeKey.get() + " has duplicates");
                    this.newChanges = Collections.emptyList();
                    return;
                }
                if (changes.size() == 1) {
                    RevId currentPs = changes.get(0).currentPatchSet().getRevision();
                    if (p.commit.name().equals(currentPs.get())) {
                        if (pending.size() == 1) {
                            this.reject(this.magicBranch.cmd, "commit(s) already exists (as current patchset)");
                        } else {
                            itr.remove();
                            continue;
                        }
                    }
                    if (this.requestReplace(this.magicBranch.cmd, false, changes.get(0).change(), p.commit)) continue;
                    this.newChanges = Collections.emptyList();
                    return;
                }
                if (changes.size() == 0) {
                    if (!ReceiveCommits.isValidChangeId(p.changeKey.get())) {
                        this.reject(this.magicBranch.cmd, "invalid Change-Id");
                        this.newChanges = Collections.emptyList();
                        return;
                    }
                    if (this.foundInExistingRef(existing.get((Object)p.commit))) {
                        if (pending.size() == 1) {
                            this.reject(this.magicBranch.cmd, "commit(s) already exists (as current patchset)");
                            this.newChanges = Collections.emptyList();
                            return;
                        }
                        itr.remove();
                        continue;
                    }
                    newChangeIds.add(p.changeKey);
                }
                this.newChanges.add(new CreateRequest(p.commit, this.magicBranch.dest.get()));
            }
            this.logDebug("Finished deferred lookups with {} updates and {} new changes", this.replaceByChange.size(), this.newChanges.size());
        }
        catch (IOException e) {
            this.magicBranch.cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT);
            this.logError("Invalid pack upload; one or more objects weren't sent", e);
            this.newChanges = Collections.emptyList();
            return;
        }
        catch (OrmException e) {
            this.logError("Cannot query database to locate prior changes", e);
            this.reject(this.magicBranch.cmd, "database error");
            this.newChanges = Collections.emptyList();
            return;
        }
        if (this.newChanges.isEmpty() && this.replaceByChange.isEmpty()) {
            this.reject(this.magicBranch.cmd, "no new changes");
            return;
        }
        if (!this.newChanges.isEmpty() && this.magicBranch.edit) {
            this.reject(this.magicBranch.cmd, "edit is not supported for new changes");
            return;
        }
        try {
            SortedSetMultimap<ObjectId, String> groups = groupCollector.getGroups();
            ImmutableList<Integer> newIds = this.seq.nextChangeIds(this.newChanges.size());
            for (int i = 0; i < this.newChanges.size(); ++i) {
                CreateRequest create = this.newChanges.get(i);
                create.setChangeId((Integer)newIds.get(i));
                create.groups = ImmutableList.copyOf(groups.get((Object)create.commit));
            }
            for (ReplaceRequest replace : this.replaceByChange.values()) {
                replace.groups = ImmutableList.copyOf(groups.get((Object)replace.newCommitId));
            }
            for (UpdateGroupsRequest update : this.updateGroups) {
                update.groups = ImmutableList.copyOf(groups.get((Object)update.commit));
            }
            this.logDebug("Finished updating groups from GroupCollector", new Object[0]);
        }
        catch (OrmException e) {
            this.logError("Error collecting groups for changes", e);
            this.reject(this.magicBranch.cmd, "internal server error");
            return;
        }
    }

    private boolean foundInExistingRef(Collection<Ref> existingRefs) throws OrmException {
        for (Ref ref : existingRefs) {
            ChangeNotes notes = this.notesFactory.create(this.db, this.project.getNameKey(), Change.Id.fromRef(ref.getName()));
            Change change = notes.getChange();
            if (!change.getDest().equals(this.magicBranch.dest)) continue;
            this.logDebug("Found change {} from existing refs.", change.getKey());
            CheckedFuture<?, IOException> possiblyIgnoredError = this.indexer.indexAsync(this.project.getNameKey(), change.getId());
            return true;
        }
        return false;
    }

    private RevCommit setUpWalkForSelectingChanges() throws IOException {
        RevWalk rw = this.rp.getRevWalk();
        RevCommit start = rw.parseCommit(this.magicBranch.cmd.getNewId());
        rw.reset();
        rw.sort(RevSort.TOPO);
        rw.sort(RevSort.REVERSE, true);
        this.rp.getRevWalk().markStart(start);
        if (this.magicBranch.baseCommit != null) {
            this.markExplicitBasesUninteresting();
        } else if (this.magicBranch.merged) {
            this.logDebug("Marking parents of merged commit {} uninteresting", start.name());
            for (RevCommit c : start.getParents()) {
                rw.markUninteresting(c);
            }
        } else {
            this.markHeadsAsUninteresting(rw, this.magicBranch.dest != null ? this.magicBranch.dest.get() : null);
        }
        return start;
    }

    private void markExplicitBasesUninteresting() throws IOException {
        this.logDebug("Marking {} base commits uninteresting", this.magicBranch.baseCommit.size());
        for (RevCommit c : this.magicBranch.baseCommit) {
            this.rp.getRevWalk().markUninteresting(c);
        }
        Ref targetRef = this.allRefs().get(this.magicBranch.dest.get());
        if (targetRef != null) {
            this.logDebug("Marking target ref {} ({}) uninteresting", this.magicBranch.dest.get(), targetRef.getObjectId().name());
            this.rp.getRevWalk().markUninteresting(this.rp.getRevWalk().parseCommit(targetRef.getObjectId()));
        }
    }

    private void rejectImplicitMerges(Set<RevCommit> mergedParents) throws IOException {
        Ref targetRef;
        if (!mergedParents.isEmpty() && (targetRef = this.allRefs().get(this.magicBranch.dest.get())) != null) {
            RevWalk rw = this.rp.getRevWalk();
            RevCommit tip = rw.parseCommit(targetRef.getObjectId());
            boolean containsImplicitMerges = true;
            for (RevCommit p : mergedParents) {
                containsImplicitMerges &= !rw.isMergedInto(p, tip);
            }
            if (containsImplicitMerges) {
                RevCommit c;
                rw.reset();
                for (RevCommit p : mergedParents) {
                    rw.markStart(p);
                }
                rw.markUninteresting(tip);
                while ((c = rw.next()) != null) {
                    rw.parseBody(c);
                    this.messages.add(new CommitValidationMessage("ERROR: Implicit Merge of " + c.abbreviate(7).name() + " " + c.getShortMessage(), false));
                }
                this.reject(this.magicBranch.cmd, "implicit merges detected");
            }
        }
    }

    private void markHeadsAsUninteresting(RevWalk rw, @Nullable String forRef) {
        int i = 0;
        for (Ref ref : this.allRefs().values()) {
            if (!ref.getName().startsWith("refs/heads/") && !ref.getName().equals(forRef) || ref.getObjectId() == null) continue;
            try {
                rw.markUninteresting(rw.parseCommit(ref.getObjectId()));
                ++i;
            }
            catch (IOException e) {
                this.logWarn(String.format("Invalid ref %s in %s", ref.getName(), this.project.getName()), e);
            }
        }
        this.logDebug("Marked {} heads as uninteresting", i);
    }

    private static boolean isValidChangeId(String idStr) {
        return idStr.matches("^I[0-9a-fA-F]{40}$") && !idStr.matches("^I00*$");
    }

    private void submit(Collection<CreateRequest> create, Collection<ReplaceRequest> replace) throws OrmException, RestApiException, UpdateException, IOException, ConfigInvalidException, PermissionBackendException {
        HashMap<ObjectId, Change> bySha = Maps.newHashMapWithExpectedSize(create.size() + replace.size());
        for (CreateRequest createRequest : create) {
            Preconditions.checkNotNull(createRequest.change, "cannot submit new change %s; op may not have run", (Object)createRequest.changeId);
            bySha.put(createRequest.commit, createRequest.change);
        }
        for (ReplaceRequest replaceRequest : replace) {
            bySha.put(replaceRequest.newCommitId, replaceRequest.notes.getChange());
        }
        Change tipChange = (Change)bySha.get(this.magicBranch.cmd.getNewId());
        Preconditions.checkNotNull(tipChange, "tip of push does not correspond to a change; found these changes: %s", bySha);
        this.logDebug("Processing submit with tip change {} ({})", tipChange.getId(), this.magicBranch.cmd.getNewId());
        try (MergeOp mergeOp = this.mergeOpProvider.get();){
            mergeOp.merge(this.db, tipChange, this.user, false, new SubmitInput(), false);
        }
    }

    private void preparePatchSetsForReplace() {
        try {
            this.readChangesForReplace();
            Iterator<ReplaceRequest> itr = this.replaceByChange.values().iterator();
            while (itr.hasNext()) {
                ReplaceRequest replaceRequest = itr.next();
                if (replaceRequest.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                replaceRequest.validate(false);
                if (!replaceRequest.skip || replaceRequest.cmd != null) continue;
                itr.remove();
            }
        }
        catch (OrmException err) {
            this.logError(String.format("Cannot read database before replacement for project %s", this.project.getName()), err);
            for (ReplaceRequest req : this.replaceByChange.values()) {
                if (req.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                req.inputCommand.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "internal server error");
            }
        }
        catch (PermissionBackendException | IOException err) {
            this.logError(String.format("Cannot read repository before replacement for project %s", this.project.getName()), err);
            for (ReplaceRequest req : this.replaceByChange.values()) {
                if (req.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                req.inputCommand.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "internal server error");
            }
        }
        this.logDebug("Read {} changes to replace", this.replaceByChange.size());
        if (this.magicBranch != null && this.magicBranch.cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
            for (ReplaceRequest replaceRequest : this.replaceByChange.values()) {
                if (replaceRequest.inputCommand != this.magicBranch.cmd || replaceRequest.cmd == null) continue;
                replaceRequest.cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "aborted");
            }
            for (CreateRequest createRequest : this.newChanges) {
                createRequest.cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "aborted");
            }
        }
    }

    private void readChangesForReplace() throws OrmException {
        List<ChangeNotes> allNotes = this.notesFactory.create(this.db, this.replaceByChange.values().stream().map(r -> r.ontoChange).collect(Collectors.toList()));
        Iterator iterator = allNotes.iterator();
        while (iterator.hasNext()) {
            ChangeNotes notes;
            this.replaceByChange.get((Object)notes.getChangeId()).notes = notes = (ChangeNotes)iterator.next();
        }
    }

    private List<Ref> refs(Change.Id changeId) {
        return this.refsByChange().get((Object)changeId);
    }

    private void initChangeRefMaps() {
        if (this.refsByChange == null) {
            int estRefsPerChange = 4;
            this.refsById = MultimapBuilder.hashKeys().arrayListValues().build();
            this.refsByChange = MultimapBuilder.hashKeys(this.allRefs().size() / estRefsPerChange).arrayListValues(estRefsPerChange).build();
            for (Ref ref : this.allRefs().values()) {
                PatchSet.Id psId;
                ObjectId obj = ref.getObjectId();
                if (obj == null || (psId = PatchSet.Id.fromRef(ref.getName())) == null) continue;
                this.refsById.put(obj, ref);
                this.refsByChange.put(psId.getParentKey(), ref);
            }
        }
    }

    private ListMultimap<Change.Id, Ref> refsByChange() {
        this.initChangeRefMaps();
        return this.refsByChange;
    }

    private ListMultimap<ObjectId, Ref> changeRefsById() {
        this.initChangeRefMaps();
        return this.refsById;
    }

    static boolean parentsEqual(RevCommit a, RevCommit b) {
        if (a.getParentCount() != b.getParentCount()) {
            return false;
        }
        for (int i = 0; i < a.getParentCount(); ++i) {
            if (a.getParent(i).equals(b.getParent(i))) continue;
            return false;
        }
        return true;
    }

    static boolean authorEqual(RevCommit a, RevCommit b) {
        PersonIdent aAuthor = a.getAuthorIdent();
        PersonIdent bAuthor = b.getAuthorIdent();
        if (aAuthor == null && bAuthor == null) {
            return true;
        }
        if (aAuthor == null || bAuthor == null) {
            return false;
        }
        return ReceiveCommits.eq(aAuthor.getName(), bAuthor.getName()) && ReceiveCommits.eq(aAuthor.getEmailAddress(), bAuthor.getEmailAddress());
    }

    static boolean eq(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    private boolean validRefOperation(ReceiveCommand cmd) {
        RefOperationValidators refValidators = this.refValidatorsFactory.create(this.getProject(), this.user, cmd);
        try {
            this.messages.addAll(refValidators.validateForRefOperation());
        }
        catch (RefOperationValidationException e) {
            this.messages.addAll(Lists.newArrayList(e.getMessages()));
            this.reject(cmd, e.getMessage());
            return false;
        }
        return true;
    }

    private void validateNewCommits(Branch.NameKey branch, ReceiveCommand cmd) throws PermissionBackendException {
        PermissionBackend.ForRef perm = this.permissions.ref(branch.get());
        if (!"refs/meta/config".equals(cmd.getRefName()) && !MagicBranch.isMagicBranch(cmd.getRefName()) && !CommitValidators.NEW_PATCHSET_PATTERN.matcher(cmd.getRefName()).matches() && this.pushOptions.containsKey("skip-validation")) {
            try {
                perm.check(RefPermission.SKIP_VALIDATION);
                if (!Iterables.isEmpty(this.rejectCommits)) {
                    throw new AuthException("reject-commits prevents skip-validation");
                }
                this.logDebug("Short-circuiting new commit validation", new Object[0]);
            }
            catch (AuthException denied) {
                this.reject(cmd, denied.getMessage());
            }
            return;
        }
        boolean missingFullName = Strings.isNullOrEmpty(this.user.getAccount().getFullName());
        RevWalk walk = this.rp.getRevWalk();
        walk.reset();
        walk.sort(RevSort.NONE);
        try {
            RevCommit c;
            RevObject parsedObject = walk.parseAny(cmd.getNewId());
            if (!(parsedObject instanceof RevCommit)) {
                return;
            }
            ListMultimap<ObjectId, Ref> existing = this.changeRefsById();
            walk.markStart((RevCommit)parsedObject);
            this.markHeadsAsUninteresting(walk, cmd.getRefName());
            int limit = this.receiveConfig.maxBatchCommits;
            int n = 0;
            while ((c = walk.next()) != null) {
                if (++n > limit) {
                    this.logDebug("Number of new commits exceeds limit of {}", limit);
                    this.addMessage("Cannot push more than " + limit + " commits to " + branch.get() + " without " + "skip-validation" + " option");
                    this.reject(cmd, "too many commits");
                    return;
                }
                if (existing.keySet().contains(c)) continue;
                if (!this.validCommit(walk, perm, branch, cmd, c)) break;
                if (!missingFullName || !this.user.hasEmailAddress(c.getCommitterIdent().getEmailAddress())) continue;
                this.logDebug("Will update full name of caller", new Object[0]);
                this.setFullNameTo = c.getCommitterIdent().getName();
                missingFullName = false;
            }
            this.logDebug("Validated {} new commits", n);
        }
        catch (IOException err) {
            cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT);
            this.logError("Invalid pack upload; one or more objects weren't sent", err);
        }
    }

    private String messageForCommit(RevCommit c, String msg) {
        return String.format("commit %s: %s", c.abbreviate(7).name(), msg);
    }

    private boolean validCommit(RevWalk rw, PermissionBackend.ForRef perm, Branch.NameKey branch, ReceiveCommand cmd, ObjectId id) throws IOException {
        if (this.validCommits.contains(id)) {
            return true;
        }
        RevCommit c = rw.parseCommit(id);
        rw.parseBody(c);
        try (CommitReceivedEvent receiveEvent = new CommitReceivedEvent(cmd, this.project, branch.get(), rw.getObjectReader(), c, this.user);){
            boolean isMerged = this.magicBranch != null && cmd.getRefName().equals(this.magicBranch.cmd.getRefName()) && this.magicBranch.merged;
            CommitValidators validators = isMerged ? this.commitValidatorsFactory.forMergedCommits(perm, this.user.asIdentifiedUser()) : this.commitValidatorsFactory.forReceiveCommits(perm, branch, this.user.asIdentifiedUser(), this.sshInfo, this.repo, rw);
            for (CommitValidationMessage m : validators.validate(receiveEvent)) {
                this.messages.add(new CommitValidationMessage(this.messageForCommit(c, m.getMessage()), m.isError()));
            }
        }
        catch (CommitValidationException e) {
            this.logDebug("Commit validation failed on {}", c.name());
            for (CommitValidationMessage m : e.getMessages()) {
                this.messages.add(new CommitValidationMessage(this.messageForCommit(c, m.getMessage()), m.isError()));
            }
            this.reject(cmd, this.messageForCommit(c, e.getMessage()));
            return false;
        }
        this.validCommits.add(c.copy());
        return true;
    }

    private void autoCloseChanges(ReceiveCommand cmd) {
        this.logDebug("Starting auto-closing of changes", new Object[0]);
        String refName = cmd.getRefName();
        Preconditions.checkState(!MagicBranch.isMagicBranch(refName), "shouldn't be auto-closing changes on magic branch %s", (Object)refName);
        try (BatchUpdate bu = this.batchUpdateFactory.create(this.db, this.projectControl.getProject().getNameKey(), this.user, TimeUtil.nowTs());
             ObjectInserter ins = this.repo.newObjectInserter();
             ObjectReader reader = ins.newReader();
             RevWalk rw = new RevWalk(reader);){
            RevCommit c;
            bu.setRepository(this.repo, rw, ins).updateChangesInParallel();
            bu.setRequestId(this.receiveId);
            RevCommit newTip = rw.parseCommit(cmd.getNewId());
            Branch.NameKey branch = new Branch.NameKey(this.project.getNameKey(), refName);
            rw.reset();
            rw.markStart(newTip);
            if (!ObjectId.zeroId().equals(cmd.getOldId())) {
                rw.markUninteresting(rw.parseCommit(cmd.getOldId()));
            }
            ListMultimap<ObjectId, Ref> byCommit = this.changeRefsById();
            Map<Change.Key, ChangeNotes> byKey = null;
            ArrayList<ReplaceRequest> replaceAndClose = new ArrayList<ReplaceRequest>();
            int existingPatchSets = 0;
            int newPatchSets = 0;
            block23: while ((c = rw.next()) != null) {
                rw.parseBody(c);
                for (Ref ref : byCommit.get((Object)c.copy())) {
                    PatchSet.Id psId = PatchSet.Id.fromRef(ref.getName());
                    Optional<ChangeData> cd = this.byLegacyId(psId.getParentKey());
                    if (!cd.isPresent() || !cd.get().change().getDest().equals(branch)) continue;
                    ++existingPatchSets;
                    bu.addOp(psId.getParentKey(), this.mergedByPushOpFactory.create(this.requestScopePropagator, psId, refName));
                    continue block23;
                }
                for (String changeId : c.getFooterLines(FooterConstants.CHANGE_ID)) {
                    ChangeNotes onto;
                    if (byKey == null) {
                        byKey = this.openChangesByKeyByBranch(branch);
                    }
                    if ((onto = byKey.get(new Change.Key(changeId.trim()))) == null) continue;
                    ++newPatchSets;
                    ReplaceRequest req = new ReplaceRequest(onto.getChangeId(), c, cmd, false);
                    req.notes = onto;
                    replaceAndClose.add(req);
                    continue block23;
                }
            }
            for (final ReplaceRequest req : replaceAndClose) {
                Change.Id id = req.notes.getChangeId();
                if (!req.validate(true)) {
                    this.logDebug("Not closing {} because validation failed", id);
                    continue;
                }
                req.addOps(bu, null);
                bu.addOp(id, this.mergedByPushOpFactory.create(this.requestScopePropagator, req.psId, refName).setPatchSetProvider(new Provider<PatchSet>(){

                    @Override
                    public PatchSet get() {
                        return req.replaceOp.getPatchSet();
                    }
                }));
                bu.addOp(id, new ChangeProgressOp(this.closeProgress));
            }
            this.logDebug("Auto-closing {} changes with existing patch sets and {} with new patch sets", existingPatchSets, newPatchSets);
            bu.execute();
        }
        catch (RestApiException e) {
            this.logError("Can't insert patchset", e);
        }
        catch (PermissionBackendException | UpdateException | OrmException | IOException e) {
            this.logError("Can't scan for changes to close", e);
        }
    }

    private void updateAccountInfo() {
        if (this.setFullNameTo == null) {
            return;
        }
        this.logDebug("Updating full name of caller", new Object[0]);
        try {
            Account account = this.accountsUpdate.create().update(this.user.getAccountId(), a -> {
                if (Strings.isNullOrEmpty(a.getFullName())) {
                    a.setFullName(this.setFullNameTo);
                }
            });
            if (account != null) {
                this.user.getAccount().setFullName(account.getFullName());
            }
        }
        catch (IOException | ConfigInvalidException e) {
            this.logWarn("Failed to update full name of caller", e);
        }
    }

    private Map<Change.Key, ChangeNotes> openChangesByKeyByBranch(Branch.NameKey branch) throws OrmException {
        HashMap<Change.Key, ChangeNotes> r = new HashMap<Change.Key, ChangeNotes>();
        for (ChangeData cd : this.queryProvider.get().byBranchOpen(branch)) {
            try {
                r.put(cd.change().getKey(), cd.notes());
            }
            catch (NoSuchChangeException noSuchChangeException) {}
        }
        return r;
    }

    private Optional<ChangeData> byLegacyId(Change.Id legacyId) throws OrmException {
        List<ChangeData> res = this.queryProvider.get().byLegacyChangeId(legacyId);
        if (res.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(res.get(0));
    }

    private Map<String, Ref> allRefs() {
        return this.allRefsWatcher.getAllRefs();
    }

    private void reject(@Nullable ReceiveCommand cmd, String why) {
        if (cmd != null) {
            cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, why);
            this.commandProgress.update(1);
        }
    }

    private static boolean isHead(ReceiveCommand cmd) {
        return cmd.getRefName().startsWith("refs/heads/");
    }

    private static boolean isConfig(ReceiveCommand cmd) {
        return cmd.getRefName().equals("refs/meta/config");
    }

    private void logDebug(String msg, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug(this.receiveId + msg, args);
        }
    }

    private void logWarn(String msg, Throwable t) {
        if (log.isWarnEnabled()) {
            if (t != null) {
                log.warn(this.receiveId + msg, t);
            } else {
                log.warn(this.receiveId + msg);
            }
        }
    }

    private void logWarn(String msg) {
        this.logWarn(msg, null);
    }

    private void logError(String msg, Throwable t) {
        if (log.isErrorEnabled()) {
            if (t != null) {
                log.error(this.receiveId + msg, t);
            } else {
                log.error(this.receiveId + msg);
            }
        }
    }

    private void logError(String msg) {
        this.logError(msg, null);
    }

    private static class ReindexOnlyOp
    implements BatchUpdateOp {
        private ReindexOnlyOp() {
        }

        @Override
        public boolean updateChange(ChangeContext ctx) {
            return true;
        }
    }

    private class UpdateOneRefOp
    implements RepoOnlyOp {
        private final ReceiveCommand cmd;

        private UpdateOneRefOp(ReceiveCommand cmd) {
            this.cmd = Preconditions.checkNotNull(cmd);
        }

        @Override
        public void updateRepo(RepoContext ctx) throws IOException {
            ctx.addRefUpdate(this.cmd);
        }

        @Override
        public void postUpdate(Context ctx) {
            String refName = this.cmd.getRefName();
            if (this.cmd.getType() == ReceiveCommand.Type.UPDATE) {
                ReceiveCommits.this.logDebug("Updating tag cache on fast-forward of {}", new Object[]{this.cmd.getRefName()});
                ReceiveCommits.this.tagCache.updateFastForward(ReceiveCommits.this.project.getNameKey(), refName, this.cmd.getOldId(), this.cmd.getNewId());
            }
            if (ReceiveCommits.isConfig(this.cmd)) {
                ReceiveCommits.this.logDebug("Reloading project in cache", new Object[0]);
                ReceiveCommits.this.projectCache.evict(ReceiveCommits.this.project);
                ProjectState ps = ReceiveCommits.this.projectCache.get(ReceiveCommits.this.project.getNameKey());
                try {
                    ReceiveCommits.this.logDebug("Updating project description", new Object[0]);
                    ReceiveCommits.this.repo.setGitwebDescription(ps.getProject().getDescription());
                }
                catch (IOException e) {
                    log.warn("cannot update description of " + ReceiveCommits.this.project.getName(), e);
                }
            }
        }
    }

    private class UpdateGroupsRequest {
        private final PatchSet.Id psId;
        private final RevCommit commit;
        List<String> groups = ImmutableList.of();

        UpdateGroupsRequest(Ref ref, RevCommit commit) {
            this.psId = Preconditions.checkNotNull(PatchSet.Id.fromRef(ref.getName()));
            this.commit = commit;
        }

        private void addOps(BatchUpdate bu) {
            bu.addOp(this.psId.getParentKey(), new BatchUpdateOp(){

                @Override
                public boolean updateChange(ChangeContext ctx) throws OrmException {
                    PatchSet ps = ReceiveCommits.this.psUtil.get(ctx.getDb(), ctx.getNotes(), UpdateGroupsRequest.this.psId);
                    List<String> oldGroups = ps.getGroups();
                    if (oldGroups == null ? UpdateGroupsRequest.this.groups == null : UpdateGroupsRequest.this.sameGroups(oldGroups, UpdateGroupsRequest.this.groups)) {
                        return false;
                    }
                    ReceiveCommits.this.psUtil.setGroups(ctx.getDb(), ctx.getUpdate(UpdateGroupsRequest.this.psId), ps, UpdateGroupsRequest.this.groups);
                    return true;
                }
            });
        }

        private boolean sameGroups(List<String> a, List<String> b) {
            return Sets.newHashSet(a).equals(Sets.newHashSet(b));
        }
    }

    private class ReplaceRequest {
        final Change.Id ontoChange;
        final ObjectId newCommitId;
        final ReceiveCommand inputCommand;
        final boolean checkMergedInto;
        ChangeNotes notes;
        BiMap<RevCommit, PatchSet.Id> revisions;
        PatchSet.Id psId;
        ReceiveCommand prev;
        ReceiveCommand cmd;
        PatchSetInfo info;
        boolean skip;
        private PatchSet.Id priorPatchSet;
        List<String> groups = ImmutableList.of();
        private ReplaceOp replaceOp;

        ReplaceRequest(Change.Id toChange, RevCommit newCommit, ReceiveCommand cmd, boolean checkMergedInto) {
            this.ontoChange = toChange;
            this.newCommitId = newCommit.copy();
            this.inputCommand = Preconditions.checkNotNull(cmd);
            this.checkMergedInto = checkMergedInto;
            this.revisions = HashBiMap.create();
            for (Ref ref : ReceiveCommits.this.refs(toChange)) {
                try {
                    this.revisions.forcePut(ReceiveCommits.this.rp.getRevWalk().parseCommit(ref.getObjectId()), PatchSet.Id.fromRef(ref.getName()));
                }
                catch (IOException err) {
                    ReceiveCommits.this.logWarn(String.format("Project %s contains invalid change ref %s", ReceiveCommits.this.project.getName(), ref.getName()), err);
                }
            }
        }

        boolean validate(boolean autoClose) throws IOException, OrmException, PermissionBackendException {
            if (!autoClose && this.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
                return false;
            }
            if (this.notes == null) {
                ReceiveCommits.this.reject(this.inputCommand, "change " + this.ontoChange + " not found");
                return false;
            }
            Change change = this.notes.getChange();
            this.priorPatchSet = change.currentPatchSetId();
            if (!this.revisions.containsValue(this.priorPatchSet)) {
                ReceiveCommits.this.reject(this.inputCommand, "change " + this.ontoChange + " missing revisions");
                return false;
            }
            RevCommit newCommit = ReceiveCommits.this.rp.getRevWalk().parseCommit(this.newCommitId);
            RevCommit priorCommit = (RevCommit)this.revisions.inverse().get(this.priorPatchSet);
            try {
                ((PermissionBackend.ForChange)ReceiveCommits.this.permissions.change(this.notes).database(ReceiveCommits.this.db)).check(ChangePermission.ADD_PATCH_SET);
            }
            catch (AuthException no) {
                ReceiveCommits.this.reject(this.inputCommand, "cannot add patch set to " + this.ontoChange + ".");
                return false;
            }
            if (change.getStatus().isClosed()) {
                ReceiveCommits.this.reject(this.inputCommand, "change " + this.ontoChange + " closed");
                return false;
            }
            if (this.revisions.containsKey(newCommit)) {
                ReceiveCommits.this.reject(this.inputCommand, "commit already exists (in the change)");
                return false;
            }
            for (Ref r : ReceiveCommits.this.rp.getRepository().getRefDatabase().getRefs("refs/changes").values()) {
                if (!r.getObjectId().equals(newCommit)) continue;
                ReceiveCommits.this.reject(this.inputCommand, "commit already exists (in the project)");
                return false;
            }
            for (RevCommit prior : this.revisions.keySet()) {
                if (!ReceiveCommits.this.rp.getRevWalk().isMergedInto(prior, newCommit)) continue;
                ReceiveCommits.this.reject(this.inputCommand, "same Change-Id in multiple changes.\nSquash the commits with the same Change-Id or ensure Change-Ids are unique for each commit");
                return false;
            }
            PermissionBackend.ForRef perm = ReceiveCommits.this.permissions.ref(change.getDest().get());
            if (!ReceiveCommits.this.validCommit(ReceiveCommits.this.rp.getRevWalk(), perm, change.getDest(), this.inputCommand, newCommit)) {
                return false;
            }
            ReceiveCommits.this.rp.getRevWalk().parseBody(priorCommit);
            if (newCommit.getTree().equals(priorCommit.getTree())) {
                boolean messageEq = ReceiveCommits.eq(newCommit.getFullMessage(), priorCommit.getFullMessage());
                boolean parentsEq = ReceiveCommits.parentsEqual(newCommit, priorCommit);
                boolean authorEq = ReceiveCommits.authorEqual(newCommit, priorCommit);
                ObjectReader reader = ReceiveCommits.this.rp.getRevWalk().getObjectReader();
                if (messageEq && parentsEq && authorEq && !autoClose) {
                    ReceiveCommits.this.addMessage(String.format("(W) No changes between prior commit %s and new commit %s", reader.abbreviate(priorCommit).name(), reader.abbreviate(newCommit).name()));
                } else {
                    StringBuilder msg = new StringBuilder();
                    msg.append("(I) ");
                    msg.append(reader.abbreviate(newCommit).name());
                    msg.append(":");
                    msg.append(" no files changed");
                    if (!authorEq) {
                        msg.append(", author changed");
                    }
                    if (!messageEq) {
                        msg.append(", message updated");
                    }
                    if (!parentsEq) {
                        msg.append(", was rebased");
                    }
                    ReceiveCommits.this.addMessage(msg.toString());
                }
            }
            if (!(ReceiveCommits.this.magicBranch == null || !((ReceiveCommits)ReceiveCommits.this).magicBranch.workInProgress && !((ReceiveCommits)ReceiveCommits.this).magicBranch.ready || ((ReceiveCommits)ReceiveCommits.this).magicBranch.workInProgress == change.isWorkInProgress() || ReceiveCommits.this.user.getAccountId().equals(change.getOwner()) || ReceiveCommits.this.permissionBackend.user(ReceiveCommits.this.user).test(GlobalPermission.ADMINISTRATE_SERVER) || ReceiveCommits.this.projectControl.isOwner())) {
                ReceiveCommits.this.reject(this.inputCommand, "only change owner or project owner can modify Work-in-Progress");
                return false;
            }
            if (ReceiveCommits.this.magicBranch != null && (((ReceiveCommits)ReceiveCommits.this).magicBranch.edit || ((ReceiveCommits)ReceiveCommits.this).magicBranch.draft)) {
                return this.newEdit();
            }
            this.newPatchSet();
            return true;
        }

        private boolean newEdit() {
            this.psId = this.notes.getChange().currentPatchSetId();
            Optional<ChangeEdit> edit = null;
            try {
                edit = ReceiveCommits.this.editUtil.byChange(this.notes, ReceiveCommits.this.user);
            }
            catch (AuthException | IOException e) {
                ReceiveCommits.this.logError("Cannot retrieve edit", e);
                return false;
            }
            if (edit.isPresent()) {
                if (edit.get().getBasePatchSet().getId().equals(this.psId)) {
                    this.cmd = new ReceiveCommand(edit.get().getEditCommit(), this.newCommitId, edit.get().getRefName());
                } else {
                    this.prev = new ReceiveCommand(edit.get().getEditCommit(), ObjectId.zeroId(), edit.get().getRefName());
                    this.createEditCommand();
                }
            } else {
                this.createEditCommand();
            }
            return true;
        }

        private void createEditCommand() {
            this.cmd = new ReceiveCommand(ObjectId.zeroId(), this.newCommitId, RefNames.refsEdit(ReceiveCommits.this.user.getAccountId(), this.notes.getChangeId(), this.psId));
        }

        private void newPatchSet() throws IOException, OrmException {
            RevCommit newCommit = ReceiveCommits.this.rp.getRevWalk().parseCommit(this.newCommitId);
            this.psId = ChangeUtil.nextPatchSetIdFromAllRefsMap(ReceiveCommits.this.allRefs(), this.notes.getChange().currentPatchSetId());
            this.info = ReceiveCommits.this.patchSetInfoFactory.get(ReceiveCommits.this.rp.getRevWalk(), newCommit, this.psId);
            this.cmd = new ReceiveCommand(ObjectId.zeroId(), this.newCommitId, this.psId.toRefName());
        }

        void addOps(BatchUpdate bu, @Nullable MultiProgressMonitor.Task progress) throws IOException {
            if (ReceiveCommits.this.magicBranch != null && (((ReceiveCommits)ReceiveCommits.this).magicBranch.edit || ((ReceiveCommits)ReceiveCommits.this).magicBranch.draft)) {
                bu.addOp(this.notes.getChangeId(), new ReindexOnlyOp());
                if (this.prev != null) {
                    bu.addRepoOnlyOp(new UpdateOneRefOp(this.prev));
                }
                bu.addRepoOnlyOp(new UpdateOneRefOp(this.cmd));
                return;
            }
            RevWalk rw = ReceiveCommits.this.rp.getRevWalk();
            RevCommit newCommit = rw.parseCommit(this.newCommitId);
            rw.parseBody(newCommit);
            RevCommit priorCommit = (RevCommit)this.revisions.inverse().get(this.priorPatchSet);
            this.replaceOp = ReceiveCommits.this.replaceOpFactory.create(ReceiveCommits.this.projectControl, this.notes.getChange().getDest(), this.checkMergedInto, this.priorPatchSet, priorCommit, this.psId, newCommit, this.info, this.groups, ReceiveCommits.this.magicBranch, ReceiveCommits.this.rp.getPushCertificate()).setRequestScopePropagator(ReceiveCommits.this.requestScopePropagator);
            bu.addOp(this.notes.getChangeId(), this.replaceOp);
            if (progress != null) {
                bu.addOp(this.notes.getChangeId(), new ChangeProgressOp(progress));
            }
        }

        String getRejectMessage() {
            return this.replaceOp != null ? this.replaceOp.getRejectMessage() : null;
        }
    }

    private class CreateRequest {
        final RevCommit commit;
        private final String refName;
        Change.Id changeId;
        ReceiveCommand cmd;
        ChangeInserter ins;
        List<String> groups = ImmutableList.of();
        Change change;

        CreateRequest(RevCommit commit, String refName) {
            this.commit = commit;
            this.refName = refName;
        }

        private void setChangeId(int id) {
            this.possiblyOverrideWorkInProgress();
            this.changeId = new Change.Id(id);
            this.ins = ReceiveCommits.this.changeInserterFactory.create(this.changeId, this.commit, this.refName).setTopic(((ReceiveCommits)ReceiveCommits.this).magicBranch.topic).setPrivate(ReceiveCommits.this.setChangeAsPrivate).setWorkInProgress(((ReceiveCommits)ReceiveCommits.this).magicBranch.workInProgress).setValidate(false);
            if (((ReceiveCommits)ReceiveCommits.this).magicBranch.merged) {
                this.ins.setStatus(Change.Status.MERGED);
            }
            this.cmd = new ReceiveCommand(ObjectId.zeroId(), this.commit, this.ins.getPatchSetId().toRefName());
            if (ReceiveCommits.this.rp.getPushCertificate() != null) {
                this.ins.setPushCertificate(ReceiveCommits.this.rp.getPushCertificate().toTextWithSignature());
            }
        }

        private void possiblyOverrideWorkInProgress() {
            if (((ReceiveCommits)ReceiveCommits.this).magicBranch.workInProgress || ((ReceiveCommits)ReceiveCommits.this).magicBranch.ready) {
                return;
            }
            ((ReceiveCommits)ReceiveCommits.this).magicBranch.workInProgress = ReceiveCommits.this.projectCache.get(ReceiveCommits.this.project.getNameKey()).isWorkInProgressByDefault() || MoreObjects.firstNonNull(((ReceiveCommits)ReceiveCommits.this).user.getAccount().getGeneralPreferencesInfo().workInProgressByDefault, false) != false;
        }

        private void addOps(BatchUpdate bu) throws RestApiException {
            Preconditions.checkState(this.changeId != null, "must call setChangeId before addOps");
            try {
                RevWalk rw = ReceiveCommits.this.rp.getRevWalk();
                rw.parseBody(this.commit);
                final PatchSet.Id psId = this.ins.setGroups(this.groups).getPatchSetId();
                Account.Id me = ReceiveCommits.this.user.getAccountId();
                List<FooterLine> footerLines = this.commit.getFooterLines();
                MailUtil.MailRecipients recipients = new MailUtil.MailRecipients();
                HashMap<String, Short> approvals = new HashMap();
                Preconditions.checkNotNull(ReceiveCommits.this.magicBranch);
                recipients.add(ReceiveCommits.this.magicBranch.getMailRecipients());
                approvals = ((ReceiveCommits)ReceiveCommits.this).magicBranch.labels;
                recipients.add(MailUtil.getRecipientsFromFooters(ReceiveCommits.this.accountResolver, footerLines));
                recipients.remove(me);
                StringBuilder msg = new StringBuilder(ApprovalsUtil.renderMessageWithApprovals(psId.get(), approvals, Collections.emptyMap()));
                msg.append('.');
                if (!Strings.isNullOrEmpty(((ReceiveCommits)ReceiveCommits.this).magicBranch.message)) {
                    msg.append("\n").append(((ReceiveCommits)ReceiveCommits.this).magicBranch.message);
                }
                bu.insertChange(this.ins.setReviewers(recipients.getReviewers()).setExtraCC(recipients.getCcOnly()).setApprovals(approvals).setMessage(msg.toString()).setNotify(ReceiveCommits.this.magicBranch.getNotify()).setAccountsToNotify(ReceiveCommits.this.magicBranch.getAccountsToNotify()).setRequestScopePropagator(ReceiveCommits.this.requestScopePropagator).setSendMail(true).setPatchSetDescription(((ReceiveCommits)ReceiveCommits.this).magicBranch.message));
                if (!((ReceiveCommits)ReceiveCommits.this).magicBranch.hashtags.isEmpty()) {
                    bu.addOp(this.changeId, ReceiveCommits.this.hashtagsFactory.create(new HashtagsInput(((ReceiveCommits)ReceiveCommits.this).magicBranch.hashtags)).setFireEvent(false));
                }
                if (!Strings.isNullOrEmpty(((ReceiveCommits)ReceiveCommits.this).magicBranch.topic)) {
                    bu.addOp(this.changeId, new BatchUpdateOp(){

                        @Override
                        public boolean updateChange(ChangeContext ctx) {
                            ctx.getUpdate(psId).setTopic(((ReceiveCommits)ReceiveCommits.this).magicBranch.topic);
                            return true;
                        }
                    });
                }
                bu.addOp(this.changeId, new BatchUpdateOp(){

                    @Override
                    public boolean updateChange(ChangeContext ctx) {
                        CreateRequest.this.change = ctx.getChange();
                        return false;
                    }
                });
                bu.addOp(this.changeId, new ChangeProgressOp(ReceiveCommits.this.newProgress));
            }
            catch (Exception e) {
                throw (RestApiException)INSERT_EXCEPTION.apply(e);
            }
        }
    }

    private class ChangeLookup {
        final RevCommit commit;
        final Change.Key changeKey;
        final List<ChangeData> destChanges;

        ChangeLookup(RevCommit c, Change.Key key) throws OrmException {
            this.commit = c;
            this.changeKey = key;
            this.destChanges = ((InternalChangeQuery)ReceiveCommits.this.queryProvider.get()).byBranchKey(((ReceiveCommits)ReceiveCommits.this).magicBranch.dest, key);
        }

        ChangeLookup(RevCommit c) throws OrmException {
            this.commit = c;
            this.destChanges = ((InternalChangeQuery)ReceiveCommits.this.queryProvider.get()).byBranchCommit(((ReceiveCommits)ReceiveCommits.this).magicBranch.dest, c.getName());
            this.changeKey = null;
        }
    }

    static class MagicBranchInput {
        private static final Splitter COMMAS = Splitter.on(',').omitEmptyStrings();
        final ReceiveCommand cmd;
        final LabelTypes labelTypes;
        final NotesMigration notesMigration;
        private final boolean defaultPublishComments;
        Branch.NameKey dest;
        PermissionBackend.ForRef perm;
        Set<Account.Id> reviewer = Sets.newLinkedHashSet();
        Set<Account.Id> cc = Sets.newLinkedHashSet();
        Map<String, Short> labels = new HashMap<String, Short>();
        String message;
        List<RevCommit> baseCommit;
        CmdLineParser clp;
        Set<String> hashtags = new HashSet<String>();
        @Option(name="--base", metaVar="BASE", usage="merge base of changes")
        List<ObjectId> base;
        @Option(name="--topic", metaVar="NAME", usage="attach topic to changes")
        String topic;
        @Option(name="--draft", usage="Will be removed. Before that, this option will be mapped to '--private'for new changes and '--edit' for existing changes")
        boolean draft;
        boolean publish;
        @Option(name="--private", usage="mark new/updated change as private")
        boolean isPrivate;
        @Option(name="--remove-private", usage="remove privacy flag from updated change")
        boolean removePrivate;
        @Option(name="--wip", aliases={"-work-in-progress"}, usage="mark change as work in progress")
        boolean workInProgress;
        @Option(name="--ready", usage="mark change as ready")
        boolean ready;
        @Option(name="--edit", aliases={"-e"}, usage="upload as change edit")
        boolean edit;
        @Option(name="--submit", usage="immediately submit the change")
        boolean submit;
        @Option(name="--merged", usage="create single change for a merged commit")
        boolean merged;
        @Option(name="--publish-comments", usage="publish all draft comments on updated changes")
        private boolean publishComments;
        @Option(name="--no-publish-comments", aliases={"--np"}, usage="do not publish draft comments")
        private boolean noPublishComments;
        @Option(name="--notify", usage="Notify handling that defines to whom email notifications should be sent. Allowed values are NONE, OWNER, OWNER_REVIEWERS, ALL. If not set, the default is ALL.")
        private NotifyHandling notify;
        @Option(name="--notify-to", metaVar="USER", usage="user that should be notified")
        List<Account.Id> tos = new ArrayList<Account.Id>();
        @Option(name="--notify-cc", metaVar="USER", usage="user that should be CC'd")
        List<Account.Id> ccs = new ArrayList<Account.Id>();
        @Option(name="--notify-bcc", metaVar="USER", usage="user that should be BCC'd")
        List<Account.Id> bccs = new ArrayList<Account.Id>();

        @Option(name="--reviewer", aliases={"-r"}, metaVar="EMAIL", usage="add reviewer to changes")
        void reviewer(Account.Id id) {
            this.reviewer.add(id);
        }

        @Option(name="--cc", metaVar="EMAIL", usage="notify user by CC")
        void cc(Account.Id id) {
            this.cc.add(id);
        }

        @Option(name="--label", aliases={"-l"}, metaVar="LABEL+VALUE", usage="label(s) to assign (defaults to +1 if no value provided")
        void addLabel(String token) throws CmdLineException {
            LabelVote v = LabelVote.parse(token);
            try {
                LabelType.checkName(v.label());
                ApprovalsUtil.checkLabel(this.labelTypes, v.label(), v.value());
            }
            catch (BadRequestException e) {
                throw this.clp.reject(e.getMessage());
            }
            this.labels.put(v.label(), v.value());
        }

        @Option(name="--message", aliases={"-m"}, metaVar="MESSAGE", usage="Comment message to apply to the review")
        void addMessage(String token) {
            this.message = token.replace("_", " ");
            try {
                this.message = URLDecoder.decode(this.message, StandardCharsets.UTF_8.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }

        @Option(name="--hashtag", aliases={"-t"}, metaVar="HASHTAG", usage="add hashtag to changes")
        void addHashtag(String token) throws CmdLineException {
            if (!this.notesMigration.readChanges()) {
                throw this.clp.reject("cannot add hashtags; noteDb is disabled");
            }
            String hashtag = HashtagsUtil.cleanupHashtag(token);
            if (!hashtag.isEmpty()) {
                this.hashtags.add(hashtag);
            }
        }

        MagicBranchInput(IdentifiedUser user, ReceiveCommand cmd, LabelTypes labelTypes, NotesMigration notesMigration) {
            this.cmd = cmd;
            this.draft = cmd.getRefName().startsWith("refs/drafts/");
            this.publish = cmd.getRefName().startsWith("refs/publish/");
            this.labelTypes = labelTypes;
            this.notesMigration = notesMigration;
            GeneralPreferencesInfo prefs = user.getAccount().getGeneralPreferencesInfo();
            this.defaultPublishComments = prefs != null ? MoreObjects.firstNonNull(user.getAccount().getGeneralPreferencesInfo().publishCommentsOnPush, false) : false;
        }

        MailUtil.MailRecipients getMailRecipients() {
            return new MailUtil.MailRecipients(this.reviewer, this.cc);
        }

        ListMultimap<RecipientType, Account.Id> getAccountsToNotify() {
            Multimap accountsToNotify = MultimapBuilder.hashKeys().arrayListValues().build();
            accountsToNotify.putAll(RecipientType.TO, this.tos);
            accountsToNotify.putAll(RecipientType.CC, this.ccs);
            accountsToNotify.putAll(RecipientType.BCC, this.bccs);
            return accountsToNotify;
        }

        boolean shouldPublishComments() {
            if (this.publishComments) {
                return true;
            }
            if (this.noPublishComments) {
                return false;
            }
            return this.defaultPublishComments;
        }

        String parse(CmdLineParser clp, Repository repo, Set<String> refs, ListMultimap<String, String> pushOptions) throws CmdLineException {
            String name;
            String ref = RefNames.fullName(MagicBranch.getDestBranchName(this.cmd.getRefName()));
            LinkedListMultimap<String, String> options = LinkedListMultimap.create(pushOptions);
            int optionStart = ref.indexOf(37);
            if (0 < optionStart) {
                for (String s : COMMAS.split(ref.substring(optionStart + 1))) {
                    int e = s.indexOf(61);
                    if (0 < e) {
                        options.put(s.substring(0, e), s.substring(e + 1));
                        continue;
                    }
                    options.put(s, "");
                }
                ref = ref.substring(0, optionStart);
            }
            if (!options.isEmpty()) {
                clp.parseOptionMap(options);
            }
            String head = ReceiveCommits.readHEAD(repo);
            int split = ref.length();
            while (!refs.contains(name = ref.substring(0, split)) && !name.equals(head)) {
                if ((split = name.lastIndexOf(47, split - 1)) > "refs/".length()) continue;
                return ref;
            }
            if (split < ref.length()) {
                this.topic = Strings.emptyToNull(ref.substring(split + 1));
            }
            return ref.substring(0, split);
        }

        NotifyHandling getNotify() {
            if (this.notify != null) {
                return this.notify;
            }
            if (this.workInProgress) {
                return NotifyHandling.OWNER;
            }
            return NotifyHandling.ALL;
        }

        NotifyHandling getNotify(ChangeNotes notes) {
            if (this.notify != null) {
                return this.notify;
            }
            if (this.workInProgress || !this.ready && notes.getChange().isWorkInProgress()) {
                return NotifyHandling.OWNER;
            }
            return NotifyHandling.ALL;
        }
    }

    private class ReceivePackMessageSender
    implements MessageSender {
        private ReceivePackMessageSender() {
        }

        @Override
        public void sendMessage(String what) {
            ReceiveCommits.this.rp.sendMessage(what);
        }

        @Override
        public void sendError(String what) {
            ReceiveCommits.this.rp.sendError(what);
        }

        @Override
        public void sendBytes(byte[] what) {
            this.sendBytes(what, 0, what.length);
        }

        @Override
        public void sendBytes(byte[] what, int off, int len) {
            try {
                ReceiveCommits.this.rp.getMessageOutputStream().write(what, off, len);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void flush() {
            try {
                ReceiveCommits.this.rp.getMessageOutputStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static interface Factory {
        public ReceiveCommits create(ProjectControl var1, ReceivePack var2, AllRefsWatcher var3, SetMultimap<ReviewerStateInternal, Account.Id> var4);
    }

    private static enum ReceiveError {
        CONFIG_UPDATE("You are not allowed to perform this operation.\nConfiguration changes can only be pushed by project owners\nwho also have 'Push' rights on refs/meta/config"),
        UPDATE("You are not allowed to perform this operation.\nTo push into this reference you need 'Push' rights."),
        DELETE("You need 'Delete Reference' rights or 'Push' rights with the \n'Force Push' flag set to delete references."),
        DELETE_CHANGES("Cannot delete from 'refs/changes/'"),
        CODE_REVIEW("You need 'Push' rights to upload code review requests.\nVerify that you are pushing to the right branch.");

        private final String value;

        private ReceiveError(String value) {
            this.value = value;
        }

        String get() {
            return this.value;
        }
    }
}

