/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.strategy.FastForwardOp;
import com.google.gerrit.server.git.strategy.MergeOneOp;
import com.google.gerrit.server.git.strategy.SubmitDryRun;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import com.google.gerrit.server.git.strategy.SubmitStrategyOp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MergeAlways
extends SubmitStrategy {
    MergeAlways(SubmitStrategy.Arguments args) {
        super(args);
    }

    @Override
    public List<SubmitStrategyOp> buildOps(Collection<CodeReviewCommit> toMerge) throws IntegrationException {
        List<CodeReviewCommit> sorted = this.args.mergeUtil.reduceToMinimalMerge(this.args.mergeSorter, toMerge);
        ArrayList<SubmitStrategyOp> ops = new ArrayList<SubmitStrategyOp>(sorted.size());
        if (this.args.mergeTip.getInitialTip() == null && !sorted.isEmpty()) {
            CodeReviewCommit first = sorted.remove(0);
            ops.add(new FastForwardOp(this.args, first));
        }
        while (!sorted.isEmpty()) {
            CodeReviewCommit n = sorted.remove(0);
            ops.add(new MergeOneOp(this.args, n));
        }
        return ops;
    }

    static boolean dryRun(SubmitDryRun.Arguments args, CodeReviewCommit mergeTip, CodeReviewCommit toMerge) throws IntegrationException {
        return args.mergeUtil.canMerge(args.mergeSorter, args.repo, mergeTip, toMerge);
    }
}

