/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.extensions.client.ListGroupsOption;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.common.GroupOptionsInfo;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.ListMembers;
import com.google.gerrit.server.group.ListSubgroups;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.EnumSet;

public class GroupJson {
    private final GroupBackend groupBackend;
    private final GroupControl.Factory groupControlFactory;
    private final Provider<ListMembers> listMembers;
    private final Provider<ListSubgroups> listSubgroups;
    private EnumSet<ListGroupsOption> options;

    public static GroupOptionsInfo createOptions(GroupDescription.Basic group) {
        GroupOptionsInfo options = new GroupOptionsInfo();
        if (GroupJson.isInternalGroup(group) && ((GroupDescription.Internal)group).isVisibleToAll()) {
            options.visibleToAll = true;
        }
        return options;
    }

    @Inject
    GroupJson(GroupBackend groupBackend, GroupControl.Factory groupControlFactory, Provider<ListMembers> listMembers, Provider<ListSubgroups> listSubgroups) {
        this.groupBackend = groupBackend;
        this.groupControlFactory = groupControlFactory;
        this.listMembers = listMembers;
        this.listSubgroups = listSubgroups;
        this.options = EnumSet.noneOf(ListGroupsOption.class);
    }

    public GroupJson addOption(ListGroupsOption o) {
        this.options.add(o);
        return this;
    }

    public GroupJson addOptions(Collection<ListGroupsOption> o) {
        this.options.addAll(o);
        return this;
    }

    public GroupInfo format(GroupResource rsrc) throws OrmException {
        GroupInfo info = this.init(rsrc.getGroup());
        this.initMembersAndSubgroups(rsrc, info);
        return info;
    }

    public GroupInfo format(GroupDescription.Basic group) throws OrmException {
        GroupInfo info = this.init(group);
        if (this.options.contains((Object)ListGroupsOption.MEMBERS) || this.options.contains((Object)ListGroupsOption.INCLUDES)) {
            GroupResource rsrc = new GroupResource(this.groupControlFactory.controlFor(group));
            this.initMembersAndSubgroups(rsrc, info);
        }
        return info;
    }

    private GroupInfo init(GroupDescription.Basic group) {
        GroupInfo info = new GroupInfo();
        info.id = Url.encode(group.getGroupUUID().get());
        info.name = Strings.emptyToNull(group.getName());
        info.url = Strings.emptyToNull(group.getUrl());
        info.options = GroupJson.createOptions(group);
        if (GroupJson.isInternalGroup(group)) {
            GroupDescription.Internal internalGroup = (GroupDescription.Internal)group;
            info.description = Strings.emptyToNull(internalGroup.getDescription());
            info.groupId = internalGroup.getId().get();
            AccountGroup.UUID ownerGroupUUID = internalGroup.getOwnerGroupUUID();
            if (ownerGroupUUID != null) {
                info.ownerId = Url.encode(ownerGroupUUID.get());
                GroupDescription.Basic o = this.groupBackend.get(ownerGroupUUID);
                if (o != null) {
                    info.owner = o.getName();
                }
            }
            info.createdOn = internalGroup.getCreatedOn();
        }
        return info;
    }

    private static boolean isInternalGroup(GroupDescription.Basic group) {
        return group instanceof GroupDescription.Internal;
    }

    private GroupInfo initMembersAndSubgroups(GroupResource rsrc, GroupInfo info) throws OrmException {
        if (!rsrc.isInternalGroup()) {
            return info;
        }
        try {
            if (this.options.contains((Object)ListGroupsOption.MEMBERS)) {
                info.members = this.listMembers.get().apply(rsrc);
            }
            if (this.options.contains((Object)ListGroupsOption.INCLUDES)) {
                info.includes = this.listSubgroups.get().apply(rsrc);
            }
            return info;
        }
        catch (MethodNotAllowedException e) {
            throw new IllegalStateException(e);
        }
    }
}

