/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.group.AddSubgroups;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.Groups;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.ListSubgroups;
import com.google.gerrit.server.group.SubgroupResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class SubgroupsCollection
implements ChildCollection<GroupResource, SubgroupResource>,
AcceptsCreate<GroupResource> {
    private final DynamicMap<RestView<SubgroupResource>> views;
    private final ListSubgroups list;
    private final GroupsCollection groupsCollection;
    private final Provider<ReviewDb> dbProvider;
    private final Groups groups;
    private final AddSubgroups addSubgroups;

    @Inject
    SubgroupsCollection(DynamicMap<RestView<SubgroupResource>> views, ListSubgroups list, GroupsCollection groupsCollection, Provider<ReviewDb> dbProvider, Groups groups, AddSubgroups addSubgroups) {
        this.views = views;
        this.list = list;
        this.groupsCollection = groupsCollection;
        this.dbProvider = dbProvider;
        this.groups = groups;
        this.addSubgroups = addSubgroups;
    }

    @Override
    public RestView<GroupResource> list() {
        return this.list;
    }

    @Override
    public SubgroupResource parse(GroupResource resource, IdString id) throws MethodNotAllowedException, AuthException, ResourceNotFoundException, OrmException {
        GroupDescription.Internal parent = resource.asInternalGroup().orElseThrow(MethodNotAllowedException::new);
        GroupDescription.Basic member = this.groupsCollection.parse(TopLevelResource.INSTANCE, id).getGroup();
        if (resource.getControl().canSeeGroup() && this.isSubgroup(parent, member)) {
            return new SubgroupResource(resource, member);
        }
        throw new ResourceNotFoundException(id);
    }

    private boolean isSubgroup(GroupDescription.Internal parent, GroupDescription.Basic member) throws OrmException, ResourceNotFoundException {
        try {
            return this.groups.isSubgroup(this.dbProvider.get(), parent.getGroupUUID(), member.getGroupUUID());
        }
        catch (NoSuchGroupException e) {
            throw new ResourceNotFoundException(String.format("Group %s not found", parent.getGroupUUID()));
        }
    }

    public AddSubgroups.PutSubgroup create(GroupResource group, IdString id) {
        return new AddSubgroups.PutSubgroup(this.addSubgroups, id.get());
    }

    @Override
    public DynamicMap<RestView<SubgroupResource>> views() {
        return this.views;
    }
}

