/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.change;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.index.FieldDef;
import com.google.gerrit.index.SchemaUtil;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.OutputFormat;
import com.google.gerrit.server.ReviewerByEmailSet;
import com.google.gerrit.server.ReviewerSet;
import com.google.gerrit.server.StarredChangesUtil;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.index.RefState;
import com.google.gerrit.server.index.change.StalenessChecker;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.notedb.RobotCommentNotes;
import com.google.gerrit.server.project.SubmitRuleOptions;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.ChangeStatusPredicate;
import com.google.gson.Gson;
import com.google.gwtorm.protobuf.CodecFactory;
import com.google.gwtorm.protobuf.ProtobufCodec;
import com.google.gwtorm.server.OrmException;
import com.google.protobuf.CodedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.lib.PersonIdent;

public class ChangeField {
    public static final int NO_ASSIGNEE = -1;
    private static final Gson GSON = OutputFormat.JSON_COMPACT.newGson();
    public static final FieldDef<ChangeData, Integer> LEGACY_ID = FieldDef.integer("legacy_id").stored().build(cd -> cd.getId().get());
    public static final FieldDef<ChangeData, String> ID = FieldDef.prefix("change_id").build(ChangeField.changeGetter(c -> c.getKey().get()));
    public static final FieldDef<ChangeData, String> STATUS = FieldDef.exact("status").build(ChangeField.changeGetter(c -> ChangeStatusPredicate.canonicalize(c.getStatus())));
    public static final FieldDef<ChangeData, String> PROJECT = FieldDef.exact("project").stored().build(ChangeField.changeGetter(c -> c.getProject().get()));
    public static final FieldDef<ChangeData, String> PROJECTS = FieldDef.prefix("projects").build(ChangeField.changeGetter(c -> c.getProject().get()));
    public static final FieldDef<ChangeData, String> REF = FieldDef.exact("ref").build(ChangeField.changeGetter(c -> c.getDest().get()));
    public static final FieldDef<ChangeData, String> EXACT_TOPIC = FieldDef.exact("topic4").build(ChangeField::getTopic);
    public static final FieldDef<ChangeData, String> FUZZY_TOPIC = FieldDef.fullText("topic5").build(ChangeField::getTopic);
    public static final FieldDef<ChangeData, String> SUBMISSIONID = FieldDef.exact("submissionid").build(ChangeField.changeGetter(Change::getSubmissionId));
    public static final FieldDef<ChangeData, Timestamp> UPDATED = FieldDef.timestamp("updated2").stored().build(ChangeField.changeGetter(Change::getLastUpdatedOn));
    public static final FieldDef<ChangeData, Iterable<String>> PATH = FieldDef.exact("file").buildRepeatable(cd -> MoreObjects.firstNonNull(cd.currentFilePaths(), ImmutableList.of()));
    public static final FieldDef<ChangeData, Iterable<String>> HASHTAG = FieldDef.exact("hashtag").buildRepeatable(cd -> cd.hashtags().stream().map(String::toLowerCase).collect(Collectors.toSet()));
    public static final FieldDef<ChangeData, Iterable<byte[]>> HASHTAG_CASE_AWARE = FieldDef.storedOnly("_hashtag").buildRepeatable(cd -> cd.hashtags().stream().map(t -> t.getBytes(StandardCharsets.UTF_8)).collect(Collectors.toSet()));
    public static final FieldDef<ChangeData, Iterable<String>> FILE_PART = FieldDef.exact("filepart").buildRepeatable(ChangeField::getFileParts);
    public static final FieldDef<ChangeData, Integer> OWNER = FieldDef.integer("owner").build(ChangeField.changeGetter(c -> c.getOwner().get()));
    public static final FieldDef<ChangeData, Integer> ASSIGNEE = FieldDef.integer("assignee").build(ChangeField.changeGetter(c -> c.getAssignee() != null ? c.getAssignee().get() : -1));
    public static final FieldDef<ChangeData, Iterable<String>> REVIEWER = FieldDef.exact("reviewer2").stored().buildRepeatable(cd -> ChangeField.getReviewerFieldValues(cd.reviewers()));
    public static final FieldDef<ChangeData, Iterable<String>> REVIEWER_BY_EMAIL = FieldDef.exact("reviewer_by_email").stored().buildRepeatable(cd -> ChangeField.getReviewerByEmailFieldValues(cd.reviewersByEmail()));
    public static final FieldDef<ChangeData, Iterable<String>> PENDING_REVIEWER = FieldDef.exact("pendingreviewer").stored().buildRepeatable(cd -> ChangeField.getReviewerFieldValues(cd.pendingReviewers()));
    public static final FieldDef<ChangeData, Iterable<String>> PENDING_REVIEWER_BY_EMAIL = FieldDef.exact("pendingreviewerbyemail").stored().buildRepeatable(cd -> ChangeField.getReviewerByEmailFieldValues(cd.pendingReviewersByEmail()));
    public static final FieldDef<ChangeData, Integer> REVERT_OF = FieldDef.integer("revertof").build(cd -> cd.change().getRevertOf() != null ? Integer.valueOf(cd.change().getRevertOf().get()) : null);
    public static final FieldDef<ChangeData, Iterable<String>> COMMIT = FieldDef.prefix("commit").buildRepeatable(ChangeField::getRevisions);
    public static final FieldDef<ChangeData, Iterable<String>> EXACT_COMMIT = FieldDef.exact("exactcommit").buildRepeatable(ChangeField::getRevisions);
    public static final FieldDef<ChangeData, Iterable<String>> TR = FieldDef.exact("tr").buildRepeatable(cd -> ImmutableSet.copyOf(cd.trackingFooters().values()));
    public static final FieldDef<ChangeData, Iterable<String>> LABEL = FieldDef.exact("label2").buildRepeatable(cd -> ChangeField.getLabels(cd, true));
    public static final FieldDef<ChangeData, Iterable<String>> AUTHOR = FieldDef.fullText("author").buildRepeatable(ChangeField::getAuthorParts);
    public static final FieldDef<ChangeData, Iterable<String>> EXACT_AUTHOR = FieldDef.exact("exactauthor").buildRepeatable(ChangeField::getAuthorNameAndEmail);
    public static final FieldDef<ChangeData, Iterable<String>> COMMITTER = FieldDef.fullText("committer").buildRepeatable(ChangeField::getCommitterParts);
    public static final FieldDef<ChangeData, Iterable<String>> EXACT_COMMITTER = FieldDef.exact("exactcommitter").buildRepeatable(ChangeField::getCommitterNameAndEmail);
    public static final ProtobufCodec<Change> CHANGE_CODEC = CodecFactory.encoder(Change.class);
    public static final FieldDef<ChangeData, byte[]> CHANGE = FieldDef.storedOnly("_change").build(ChangeField.changeGetter(CHANGE_CODEC::encodeToByteArray));
    public static final ProtobufCodec<PatchSetApproval> APPROVAL_CODEC = CodecFactory.encoder(PatchSetApproval.class);
    public static final FieldDef<ChangeData, Iterable<byte[]>> APPROVAL = FieldDef.storedOnly("_approval").buildRepeatable(cd -> ChangeField.toProtos(APPROVAL_CODEC, cd.currentApprovals()));
    public static final FieldDef<ChangeData, String> COMMIT_MESSAGE = FieldDef.fullText("message").build(ChangeData::commitMessage);
    public static final FieldDef<ChangeData, Iterable<String>> COMMENT = FieldDef.fullText("comment").buildRepeatable(cd -> Stream.concat(cd.publishedComments().stream().map(c -> c.message), cd.messages().stream().map(ChangeMessage::getMessage)).collect(Collectors.toSet()));
    public static final FieldDef<ChangeData, Integer> UNRESOLVED_COMMENT_COUNT = FieldDef.intRange("unresolved").stored().build(ChangeData::unresolvedCommentCount);
    public static final FieldDef<ChangeData, String> MERGEABLE = FieldDef.exact("mergeable2").stored().build(cd -> {
        Boolean m = cd.isMergeable();
        if (m == null) {
            return null;
        }
        return m != false ? "1" : "0";
    });
    public static final FieldDef<ChangeData, Integer> ADDED = FieldDef.intRange("added").stored().build(cd -> cd.changedLines().isPresent() ? Integer.valueOf(cd.changedLines().get().insertions) : null);
    public static final FieldDef<ChangeData, Integer> DELETED = FieldDef.intRange("deleted").stored().build(cd -> cd.changedLines().isPresent() ? Integer.valueOf(cd.changedLines().get().deletions) : null);
    public static final FieldDef<ChangeData, Integer> DELTA = FieldDef.intRange("delta").build(cd -> cd.changedLines().map(c -> c.insertions + c.deletions).orElse(null));
    public static final FieldDef<ChangeData, String> PRIVATE = FieldDef.exact("private").build(cd -> cd.change().isPrivate() ? "1" : "0");
    public static final FieldDef<ChangeData, String> WIP = FieldDef.exact("wip").build(cd -> cd.change().isWorkInProgress() ? "1" : "0");
    public static final FieldDef<ChangeData, String> STARTED = FieldDef.exact("started").build(cd -> cd.change().hasReviewStarted() ? "1" : "0");
    public static final FieldDef<ChangeData, Iterable<Integer>> COMMENTBY = FieldDef.integer("commentby").buildRepeatable(cd -> Stream.concat(cd.messages().stream().map(ChangeMessage::getAuthor), cd.publishedComments().stream().map(c -> c.author.getId())).filter(Objects::nonNull).map(Account.Id::get).collect(Collectors.toSet()));
    public static final FieldDef<ChangeData, Iterable<String>> STAR = FieldDef.exact("star").stored().buildRepeatable(cd -> Iterables.transform(cd.stars().entries(), e -> StarredChangesUtil.StarField.create((Account.Id)e.getKey(), (String)e.getValue()).toString()));
    public static final FieldDef<ChangeData, Iterable<Integer>> STARBY = FieldDef.integer("starby").buildRepeatable(cd -> Iterables.transform(cd.stars().keySet(), Account.Id::get));
    public static final FieldDef<ChangeData, Iterable<String>> GROUP = FieldDef.exact("group").buildRepeatable(cd -> cd.patchSets().stream().flatMap(ps -> ps.getGroups().stream()).collect(Collectors.toSet()));
    public static final ProtobufCodec<PatchSet> PATCH_SET_CODEC = CodecFactory.encoder(PatchSet.class);
    public static final FieldDef<ChangeData, Iterable<byte[]>> PATCH_SET = FieldDef.storedOnly("_patch_set").buildRepeatable(cd -> ChangeField.toProtos(PATCH_SET_CODEC, cd.patchSets()));
    public static final FieldDef<ChangeData, Iterable<Integer>> EDITBY = FieldDef.integer("editby").buildRepeatable(cd -> cd.editsByUser().stream().map(Account.Id::get).collect(Collectors.toSet()));
    public static final FieldDef<ChangeData, Iterable<Integer>> DRAFTBY = FieldDef.integer("draftby").buildRepeatable(cd -> cd.draftsByUser().stream().map(Account.Id::get).collect(Collectors.toSet()));
    public static final Integer NOT_REVIEWED = -1;
    public static final FieldDef<ChangeData, Iterable<Integer>> REVIEWEDBY = FieldDef.integer("reviewedby").stored().buildRepeatable(cd -> {
        Set<Account.Id> reviewedBy = cd.reviewedBy();
        if (reviewedBy.isEmpty()) {
            return ImmutableSet.of(NOT_REVIEWED);
        }
        return reviewedBy.stream().map(Account.Id::get).collect(Collectors.toList());
    });
    public static final SubmitRuleOptions SUBMIT_RULE_OPTIONS_LENIENT = SubmitRuleOptions.defaults().allowClosed(true).build();
    public static final SubmitRuleOptions SUBMIT_RULE_OPTIONS_STRICT = SubmitRuleOptions.defaults().build();
    public static final FieldDef<ChangeData, Iterable<String>> SUBMIT_RECORD = FieldDef.exact("submit_record").buildRepeatable(cd -> ChangeField.formatSubmitRecordValues(cd));
    public static final FieldDef<ChangeData, Iterable<byte[]>> STORED_SUBMIT_RECORD_STRICT = FieldDef.storedOnly("full_submit_record_strict").buildRepeatable(cd -> ChangeField.storedSubmitRecords(cd, SUBMIT_RULE_OPTIONS_STRICT));
    public static final FieldDef<ChangeData, Iterable<byte[]>> STORED_SUBMIT_RECORD_LENIENT = FieldDef.storedOnly("full_submit_record_lenient").buildRepeatable(cd -> ChangeField.storedSubmitRecords(cd, SUBMIT_RULE_OPTIONS_LENIENT));
    public static final FieldDef<ChangeData, Iterable<byte[]>> REF_STATE = FieldDef.storedOnly("ref_state").buildRepeatable(cd -> {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        Project.NameKey project = cd.change().getProject();
        cd.editRefs().values().forEach(r -> result.add(RefState.of(r).toByteArray(project)));
        cd.starRefs().values().forEach(r -> result.add(RefState.of(r.ref()).toByteArray(ChangeField.allUsers(cd))));
        if (NoteDbChangeState.PrimaryStorage.of(cd.change()) == NoteDbChangeState.PrimaryStorage.NOTE_DB) {
            ChangeNotes notes = cd.notes();
            result.add(RefState.create(notes.getRefName(), notes.getMetaId()).toByteArray(project));
            notes.getRobotComments();
            RobotCommentNotes robotNotes = notes.getRobotCommentNotes();
            result.add(RefState.create(robotNotes.getRefName(), robotNotes.getMetaId()).toByteArray(project));
            cd.draftRefs().values().forEach(r -> result.add(RefState.of(r).toByteArray(ChangeField.allUsers(cd))));
        }
        return result;
    });
    public static final FieldDef<ChangeData, Iterable<byte[]>> REF_STATE_PATTERN = FieldDef.storedOnly("ref_state_pattern").buildRepeatable(cd -> {
        Change.Id id = cd.getId();
        Project.NameKey project = cd.change().getProject();
        ArrayList<byte[]> result = new ArrayList<byte[]>(3);
        result.add(StalenessChecker.RefStatePattern.create("refs/users/*/edit-" + id + "/*").toByteArray(project));
        result.add(StalenessChecker.RefStatePattern.create(RefNames.refsStarredChangesPrefix(id) + "*").toByteArray(ChangeField.allUsers(cd)));
        if (NoteDbChangeState.PrimaryStorage.of(cd.change()) == NoteDbChangeState.PrimaryStorage.NOTE_DB) {
            result.add(StalenessChecker.RefStatePattern.create(RefNames.refsDraftCommentsPrefix(id) + "*").toByteArray(ChangeField.allUsers(cd)));
        }
        return result;
    });

    public static Set<String> getFileParts(ChangeData cd) throws OrmException {
        List<String> paths;
        try {
            paths = cd.currentFilePaths();
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
        Splitter s = Splitter.on('/').omitEmptyStrings();
        HashSet<String> r = new HashSet<String>();
        for (String path : paths) {
            for (String part : s.split(path)) {
                r.add(part);
            }
        }
        return r;
    }

    @VisibleForTesting
    static List<String> getReviewerFieldValues(ReviewerSet reviewers) {
        ArrayList<String> r = new ArrayList<String>(reviewers.asTable().size() * 2);
        for (Table.Cell c : reviewers.asTable().cellSet()) {
            String v = ChangeField.getReviewerFieldValue((ReviewerStateInternal)((Object)c.getRowKey()), (Account.Id)c.getColumnKey());
            r.add(v);
            r.add(v + ',' + ((Timestamp)c.getValue()).getTime());
        }
        return r;
    }

    public static String getReviewerFieldValue(ReviewerStateInternal state, Account.Id id) {
        return state.toString() + ',' + id;
    }

    @VisibleForTesting
    static List<String> getReviewerByEmailFieldValues(ReviewerByEmailSet reviewersByEmail) {
        ArrayList<String> r = new ArrayList<String>(reviewersByEmail.asTable().size() * 2);
        for (Table.Cell c : reviewersByEmail.asTable().cellSet()) {
            String v = ChangeField.getReviewerByEmailFieldValue((ReviewerStateInternal)((Object)c.getRowKey()), (Address)c.getColumnKey());
            r.add(v);
            if (((Address)c.getColumnKey()).getName() != null) {
                Address emailOnly = new Address(((Address)c.getColumnKey()).getEmail());
                r.add(ChangeField.getReviewerByEmailFieldValue((ReviewerStateInternal)((Object)c.getRowKey()), emailOnly));
            }
            r.add(v + ',' + ((Timestamp)c.getValue()).getTime());
        }
        return r;
    }

    public static String getReviewerByEmailFieldValue(ReviewerStateInternal state, Address adr) {
        return state.toString() + ',' + adr;
    }

    public static ReviewerSet parseReviewerFieldValues(Iterable<String> values) {
        ImmutableTable.Builder<ReviewerStateInternal, Account.Id, Timestamp> b = ImmutableTable.builder();
        for (String v : values) {
            int l;
            int f = v.indexOf(44);
            if (f < 0 || (l = v.lastIndexOf(44)) == f) continue;
            b.put(ReviewerStateInternal.valueOf(v.substring(0, f)), Account.Id.parse(v.substring(f + 1, l)), new Timestamp(Long.valueOf(v.substring(l + 1, v.length()))));
        }
        return ReviewerSet.fromTable(b.build());
    }

    public static ReviewerByEmailSet parseReviewerByEmailFieldValues(Iterable<String> values) {
        ImmutableTable.Builder<ReviewerStateInternal, Address, Timestamp> b = ImmutableTable.builder();
        for (String v : values) {
            int l;
            int f = v.indexOf(44);
            if (f < 0 || (l = v.lastIndexOf(44)) == f) continue;
            b.put(ReviewerStateInternal.valueOf(v.substring(0, f)), Address.parse(v.substring(f + 1, l)), new Timestamp(Long.valueOf(v.substring(l + 1, v.length()))));
        }
        return ReviewerByEmailSet.fromTable(b.build());
    }

    private static Set<String> getRevisions(ChangeData cd) throws OrmException {
        HashSet<String> revisions = new HashSet<String>();
        for (PatchSet ps : cd.patchSets()) {
            if (ps.getRevision() == null) continue;
            revisions.add(ps.getRevision().get());
        }
        return revisions;
    }

    private static Iterable<String> getLabels(ChangeData cd, boolean owners) throws OrmException {
        HashSet<String> allApprovals = new HashSet<String>();
        HashSet<String> distinctApprovals = new HashSet<String>();
        for (PatchSetApproval a : cd.currentApprovals()) {
            if (a.getValue() == 0 || a.isLegacySubmit()) continue;
            allApprovals.add(ChangeField.formatLabel(a.getLabel(), a.getValue(), a.getAccountId()));
            if (owners && cd.change().getOwner().equals(a.getAccountId())) {
                allApprovals.add(ChangeField.formatLabel(a.getLabel(), a.getValue(), ChangeQueryBuilder.OWNER_ACCOUNT_ID));
            }
            distinctApprovals.add(ChangeField.formatLabel(a.getLabel(), a.getValue()));
        }
        allApprovals.addAll(distinctApprovals);
        return allApprovals;
    }

    public static Set<String> getAuthorParts(ChangeData cd) throws OrmException, IOException {
        return SchemaUtil.getPersonParts(cd.getAuthor());
    }

    public static Set<String> getAuthorNameAndEmail(ChangeData cd) throws OrmException, IOException {
        return ChangeField.getNameAndEmail(cd.getAuthor());
    }

    public static Set<String> getCommitterParts(ChangeData cd) throws OrmException, IOException {
        return SchemaUtil.getPersonParts(cd.getCommitter());
    }

    public static Set<String> getCommitterNameAndEmail(ChangeData cd) throws OrmException, IOException {
        return ChangeField.getNameAndEmail(cd.getCommitter());
    }

    private static Set<String> getNameAndEmail(PersonIdent person) {
        if (person == null) {
            return ImmutableSet.of();
        }
        String name = person.getName().toLowerCase(Locale.US);
        String email = person.getEmailAddress().toLowerCase(Locale.US);
        StringBuilder nameEmailBuilder = new StringBuilder();
        PersonIdent.appendSanitized(nameEmailBuilder, name);
        nameEmailBuilder.append(" <");
        PersonIdent.appendSanitized(nameEmailBuilder, email);
        nameEmailBuilder.append('>');
        return ImmutableSet.of(name, email, nameEmailBuilder.toString());
    }

    public static String formatLabel(String label, int value) {
        return ChangeField.formatLabel(label, value, null);
    }

    public static String formatLabel(String label, int value, Account.Id accountId) {
        return label.toLowerCase() + (value >= 0 ? "+" : "") + value + (accountId != null ? "," + ChangeField.formatAccount(accountId) : "");
    }

    private static String formatAccount(Account.Id accountId) {
        if (ChangeQueryBuilder.OWNER_ACCOUNT_ID.equals(accountId)) {
            return "owner";
        }
        return Integer.toString(accountId.get());
    }

    public static void parseSubmitRecords(Collection<String> values, SubmitRuleOptions opts, ChangeData out) {
        Preconditions.checkArgument(!opts.fastEvalLabels());
        List<SubmitRecord> records = ChangeField.parseSubmitRecords(values);
        if (records.isEmpty()) {
            return;
        }
        out.setSubmitRecords(opts, records);
        out.setSubmitRecords(opts.toBuilder().fastEvalLabels(true).build(), records);
    }

    @VisibleForTesting
    static List<SubmitRecord> parseSubmitRecords(Collection<String> values) {
        return values.stream().map(v -> ChangeField.GSON.fromJson((String)v, StoredSubmitRecord.class).toSubmitRecord()).collect(Collectors.toList());
    }

    @VisibleForTesting
    static List<byte[]> storedSubmitRecords(List<SubmitRecord> records) {
        return Lists.transform(records, r -> GSON.toJson(new StoredSubmitRecord((SubmitRecord)r)).getBytes(StandardCharsets.UTF_8));
    }

    private static Iterable<byte[]> storedSubmitRecords(ChangeData cd, SubmitRuleOptions opts) throws OrmException {
        return ChangeField.storedSubmitRecords(cd.submitRecords(opts));
    }

    public static List<String> formatSubmitRecordValues(ChangeData cd) throws OrmException {
        return ChangeField.formatSubmitRecordValues(cd.submitRecords(SUBMIT_RULE_OPTIONS_STRICT), cd.change().getOwner());
    }

    @VisibleForTesting
    static List<String> formatSubmitRecordValues(List<SubmitRecord> records, Account.Id changeOwner) {
        ArrayList<String> result = new ArrayList<String>();
        for (SubmitRecord rec : records) {
            result.add(rec.status.name());
            if (rec.labels == null) continue;
            for (SubmitRecord.Label label : rec.labels) {
                String sl = label.status.toString() + ',' + label.label.toLowerCase();
                result.add(sl);
                String slc = sl + ',';
                if (label.appliedBy == null) continue;
                result.add(slc + label.appliedBy.get());
                if (!label.appliedBy.equals(changeOwner)) continue;
                result.add(slc + ChangeQueryBuilder.OWNER_ACCOUNT_ID.get());
            }
        }
        return result;
    }

    private static String getTopic(ChangeData cd) throws OrmException {
        Change c = cd.change();
        if (c == null) {
            return null;
        }
        return MoreObjects.firstNonNull(c.getTopic(), "");
    }

    private static <T> List<byte[]> toProtos(ProtobufCodec<T> codec, Collection<T> objs) throws OrmException {
        ArrayList<byte[]> result = Lists.newArrayListWithCapacity(objs.size());
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        try {
            for (T obj : objs) {
                out.reset();
                CodedOutputStream cos = CodedOutputStream.newInstance(out);
                codec.encode(obj, cos);
                cos.flush();
                result.add(out.toByteArray());
            }
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
        return result;
    }

    private static <T> FieldDef.Getter<ChangeData, T> changeGetter(Function<Change, T> func) {
        return in -> in.change() != null ? func.apply(in.change()) : null;
    }

    private static AllUsersName allUsers(ChangeData cd) {
        return cd.getAllUsersNameForIndexing();
    }

    static class StoredSubmitRecord {
        SubmitRecord.Status status;
        List<StoredLabel> labels;
        String errorMessage;

        StoredSubmitRecord(SubmitRecord rec) {
            this.status = rec.status;
            this.errorMessage = rec.errorMessage;
            if (rec.labels != null) {
                this.labels = new ArrayList<StoredLabel>(rec.labels.size());
                for (SubmitRecord.Label label : rec.labels) {
                    StoredLabel sl = new StoredLabel();
                    sl.label = label.label;
                    sl.status = label.status;
                    sl.appliedBy = label.appliedBy != null ? Integer.valueOf(label.appliedBy.get()) : null;
                    this.labels.add(sl);
                }
            }
        }

        private SubmitRecord toSubmitRecord() {
            SubmitRecord rec = new SubmitRecord();
            rec.status = this.status;
            rec.errorMessage = this.errorMessage;
            if (this.labels != null) {
                rec.labels = new ArrayList<SubmitRecord.Label>(this.labels.size());
                for (StoredLabel label : this.labels) {
                    SubmitRecord.Label srl = new SubmitRecord.Label();
                    srl.label = label.label;
                    srl.status = label.status;
                    srl.appliedBy = label.appliedBy != null ? new Account.Id(label.appliedBy) : null;
                    rec.labels.add(srl);
                }
            }
            return rec;
        }

        static class StoredLabel {
            String label;
            SubmitRecord.Label.Status status;
            Integer appliedBy;

            StoredLabel() {
            }
        }
    }
}

