/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.group;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.gerrit.index.SiteIndexer;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.git.QueueProvider;
import com.google.gerrit.server.group.Groups;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.index.IndexExecutor;
import com.google.gerrit.server.index.group.GroupIndex;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AllGroupsIndexer
extends SiteIndexer<AccountGroup.UUID, InternalGroup, GroupIndex> {
    private static final Logger log = LoggerFactory.getLogger(AllGroupsIndexer.class);
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final ListeningExecutorService executor;
    private final GroupCache groupCache;
    private final Groups groups;

    @Inject
    AllGroupsIndexer(SchemaFactory<ReviewDb> schemaFactory, @IndexExecutor(value=QueueProvider.QueueType.BATCH) ListeningExecutorService executor, GroupCache groupCache, Groups groups) {
        this.schemaFactory = schemaFactory;
        this.executor = executor;
        this.groupCache = groupCache;
        this.groups = groups;
    }

    @Override
    public SiteIndexer.Result indexAll(GroupIndex index) {
        List<AccountGroup.UUID> uuids;
        TextProgressMonitor progress = new TextProgressMonitor(this.newPrintWriter(this.progressOut));
        progress.start(2);
        Stopwatch sw = Stopwatch.createStarted();
        try {
            uuids = this.collectGroups(progress);
        }
        catch (OrmException e) {
            log.error("Error collecting groups", e);
            return new SiteIndexer.Result(sw, false, 0, 0);
        }
        return this.reindexGroups(index, uuids, progress);
    }

    private SiteIndexer.Result reindexGroups(GroupIndex index, List<AccountGroup.UUID> uuids, ProgressMonitor progress) {
        progress.beginTask("Reindexing groups", uuids.size());
        ArrayList<Future> futures = new ArrayList<Future>(uuids.size());
        AtomicBoolean ok = new AtomicBoolean(true);
        AtomicInteger done = new AtomicInteger();
        AtomicInteger failed = new AtomicInteger();
        Stopwatch sw = Stopwatch.createStarted();
        for (AccountGroup.UUID uuid : uuids) {
            String desc = "group " + uuid;
            Future future = this.executor.submit(() -> {
                try {
                    Optional<InternalGroup> internalGroup;
                    Optional<InternalGroup> oldGroup = this.groupCache.get(uuid);
                    if (oldGroup.isPresent()) {
                        InternalGroup group = oldGroup.get();
                        this.groupCache.evict(group.getGroupUUID(), group.getId(), group.getNameKey());
                    }
                    if ((internalGroup = this.groupCache.get(uuid)).isPresent()) {
                        index.replace(internalGroup.get());
                    } else {
                        index.delete(uuid);
                    }
                    this.verboseWriter.println("Reindexed " + desc);
                    done.incrementAndGet();
                }
                catch (Exception e) {
                    failed.incrementAndGet();
                    throw e;
                }
                return null;
            });
            this.addErrorListener((ListenableFuture<?>)future, desc, progress, ok);
            futures.add(future);
        }
        try {
            Futures.successfulAsList(futures).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Error waiting on group futures", e);
            return new SiteIndexer.Result(sw, false, 0, 0);
        }
        progress.endTask();
        return new SiteIndexer.Result(sw, ok.get(), done.get(), failed.get());
    }

    /*
     * Loose catch block
     */
    private List<AccountGroup.UUID> collectGroups(ProgressMonitor progress) throws OrmException {
        progress.beginTask("Collecting groups", 0);
        try {
            try (ReviewDb db = this.schemaFactory.open();){
                List list = this.groups.getAll(db).map(AccountGroup::getGroupUUID).collect(ImmutableList.toImmutableList());
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            progress.endTask();
        }
    }
}

