/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.common.base.Strings;
import com.google.gerrit.common.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CommentFormatter {
    public static List<Block> parse(@Nullable String source) {
        if (Strings.isNullOrEmpty(source)) {
            return Collections.emptyList();
        }
        ArrayList<Block> result = new ArrayList<Block>();
        for (String p : source.split("\n\n")) {
            if (CommentFormatter.isQuote(p)) {
                result.add(CommentFormatter.makeQuote(p));
                continue;
            }
            if (CommentFormatter.isPreFormat(p)) {
                result.add(CommentFormatter.makePre(p));
                continue;
            }
            if (CommentFormatter.isList(p)) {
                CommentFormatter.makeList(p, result);
                continue;
            }
            if (p.isEmpty()) continue;
            result.add(CommentFormatter.makeParagraph(p));
        }
        return result;
    }

    private static void makeList(String p, List<Block> out) {
        Block block = null;
        StringBuilder textBuilder = null;
        boolean inList = false;
        boolean inParagraph = false;
        for (String line : p.split("\n")) {
            if (line.startsWith("-") || line.startsWith("*")) {
                if (!inList) {
                    if (inParagraph) {
                        inParagraph = false;
                        block.text = textBuilder.toString();
                        out.add(block);
                    }
                    inList = true;
                    block = new Block();
                    block.type = BlockType.LIST;
                    block.items = new ArrayList<String>();
                }
                line = line.substring(1).trim();
            } else if (!inList) {
                if (!inParagraph) {
                    inParagraph = true;
                    block = new Block();
                    block.type = BlockType.PARAGRAPH;
                    textBuilder = new StringBuilder();
                } else {
                    textBuilder.append(" ");
                }
                textBuilder.append(line);
                continue;
            }
            block.items.add(line);
        }
        if (block != null) {
            out.add(block);
        }
    }

    private static Block makeQuote(String p) {
        String quote = p.replaceAll("\n\\s?>\\s?", "\n");
        if (quote.startsWith("> ")) {
            quote = quote.substring(2);
        } else if (quote.startsWith(" > ")) {
            quote = quote.substring(3);
        }
        Block block = new Block();
        block.type = BlockType.QUOTE;
        block.quotedBlocks = CommentFormatter.parse(quote);
        return block;
    }

    private static Block makePre(String p) {
        Block block = new Block();
        block.type = BlockType.PRE_FORMATTED;
        block.text = p;
        return block;
    }

    private static Block makeParagraph(String p) {
        Block block = new Block();
        block.type = BlockType.PARAGRAPH;
        block.text = p;
        return block;
    }

    private static boolean isQuote(String p) {
        return p.startsWith("> ") || p.startsWith(" > ");
    }

    private static boolean isPreFormat(String p) {
        return p.startsWith(" ") || p.startsWith("\t") || p.contains("\n ") || p.contains("\n\t");
    }

    private static boolean isList(String p) {
        return p.startsWith("- ") || p.startsWith("* ") || p.contains("\n- ") || p.contains("\n* ");
    }

    public static class Block {
        public BlockType type;
        public String text;
        public List<String> items;
        public List<Block> quotedBlocks;
    }

    public static enum BlockType {
        LIST,
        PARAGRAPH,
        PRE_FORMATTED,
        QUOTE;

    }
}

