/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb.rebuild;

import com.google.common.base.Stopwatch;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.index.OnlineUpgrader;
import com.google.gerrit.server.index.VersionManager;
import com.google.gerrit.server.notedb.rebuild.GcAllUsers;
import com.google.gerrit.server.notedb.rebuild.NoteDbMigrator;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OnlineNoteDbMigrator
implements LifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(OnlineNoteDbMigrator.class);
    private static final String TRIAL = "OnlineNoteDbMigrator/trial";
    private final GcAllUsers gcAllUsers;
    private final OnlineUpgrader indexUpgrader;
    private final Provider<NoteDbMigrator.Builder> migratorBuilderProvider;
    private final boolean upgradeIndex;
    private final boolean trial;

    @Inject
    OnlineNoteDbMigrator(@GerritServerConfig Config cfg, GcAllUsers gcAllUsers, OnlineUpgrader indexUpgrader, Provider<NoteDbMigrator.Builder> migratorBuilderProvider, @Named(value="OnlineNoteDbMigrator/trial") boolean trial) {
        this.gcAllUsers = gcAllUsers;
        this.indexUpgrader = indexUpgrader;
        this.migratorBuilderProvider = migratorBuilderProvider;
        this.upgradeIndex = VersionManager.getOnlineUpgrade(cfg);
        this.trial = trial || NoteDbMigrator.getTrialMode(cfg);
    }

    @Override
    public void start() {
        Thread t = new Thread(this::migrate);
        t.setDaemon(true);
        t.setName(this.getClass().getSimpleName());
        t.start();
    }

    private void migrate() {
        log.info("Starting online NoteDb migration");
        if (this.upgradeIndex) {
            log.info("Online index schema upgrades will be deferred until NoteDb migration is complete");
        }
        Stopwatch sw = Stopwatch.createStarted();
        try (NoteDbMigrator migrator = this.migratorBuilderProvider.get().setAutoMigrate(true).setTrialMode(this.trial).build();){
            migrator.migrate();
        }
        catch (Exception e) {
            log.error("Error in online NoteDb migration", e);
        }
        this.gcAllUsers.runWithLogger();
        log.info("Online NoteDb migration completed in {}s", (Object)sw.elapsed(TimeUnit.SECONDS));
        if (this.upgradeIndex) {
            log.info("Starting deferred index schema upgrades");
            this.indexUpgrader.start();
        }
    }

    @Override
    public void stop() {
    }

    public static class Module
    extends LifecycleModule {
        private final boolean trial;

        public Module(boolean trial) {
            this.trial = trial;
        }

        @Override
        public void configure() {
            this.listener().to(OnlineNoteDbMigrator.class);
            this.bindConstant().annotatedWith(Names.named(OnlineNoteDbMigrator.TRIAL)).to(this.trial);
        }
    }
}

