/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.collect.Streams;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.api.plugins.Plugins;
import com.google.gerrit.extensions.common.PluginInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.inject.Inject;
import java.util.Comparator;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kohsuke.args4j.Option;

@RequiresCapability(value="viewPlugins")
public class ListPlugins
implements RestReadView<TopLevelResource> {
    private final PluginLoader pluginLoader;
    private boolean all;
    private int limit;
    private int start;
    private String matchPrefix;
    private String matchSubstring;
    private String matchRegex;

    @Option(name="--all", aliases={"-a"}, usage="List all plugins, including disabled plugins")
    public void setAll(boolean all) {
        this.all = all;
    }

    @Option(name="--limit", aliases={"-n"}, metaVar="CNT", usage="maximum number of plugins to list")
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Option(name="--start", aliases={"-S"}, metaVar="CNT", usage="number of plugins to skip")
    public void setStart(int start) {
        this.start = start;
    }

    @Option(name="--prefix", aliases={"-p"}, metaVar="PREFIX", usage="match plugin prefix")
    public void setMatchPrefix(String matchPrefix) {
        this.matchPrefix = matchPrefix;
    }

    @Option(name="--match", aliases={"-m"}, metaVar="MATCH", usage="match plugin substring")
    public void setMatchSubstring(String matchSubstring) {
        this.matchSubstring = matchSubstring;
    }

    @Option(name="-r", metaVar="REGEX", usage="match plugin regex")
    public void setMatchRegex(String matchRegex) {
        this.matchRegex = matchRegex;
    }

    @Inject
    protected ListPlugins(PluginLoader pluginLoader) {
        this.pluginLoader = pluginLoader;
    }

    public ListPlugins request(Plugins.ListRequest request) {
        this.setAll(request.getAll());
        this.setStart(request.getStart());
        this.setLimit(request.getLimit());
        this.setMatchPrefix(request.getPrefix());
        this.setMatchSubstring(request.getSubstring());
        this.setMatchRegex(request.getRegex());
        return this;
    }

    public SortedMap<String, PluginInfo> apply(TopLevelResource resource) throws BadRequestException {
        Stream<Plugin> s = Streams.stream(this.pluginLoader.getPlugins(this.all));
        if (this.matchPrefix != null) {
            this.checkMatchOptions(this.matchSubstring == null && this.matchRegex == null);
            s = s.filter(p -> p.getName().startsWith(this.matchPrefix));
        } else if (this.matchSubstring != null) {
            this.checkMatchOptions(this.matchPrefix == null && this.matchRegex == null);
            String substring = this.matchSubstring.toLowerCase(Locale.US);
            s = s.filter(p -> p.getName().toLowerCase(Locale.US).contains(substring));
        } else if (this.matchRegex != null) {
            this.checkMatchOptions(this.matchPrefix == null && this.matchSubstring == null);
            Pattern pattern = Pattern.compile(this.matchRegex);
            s = s.filter(p -> pattern.matcher(p.getName()).matches());
        }
        s = s.sorted(Comparator.comparing(Plugin::getName));
        if (this.start > 0) {
            s = s.skip(this.start);
        }
        if (this.limit > 0) {
            s = s.limit(this.limit);
        }
        return new TreeMap<String, PluginInfo>(s.collect(Collectors.toMap(p -> p.getName(), p -> ListPlugins.toPluginInfo(p))));
    }

    private void checkMatchOptions(boolean cond) throws BadRequestException {
        if (!cond) {
            throw new BadRequestException("specify exactly one of p/m/r");
        }
    }

    public static PluginInfo toPluginInfo(Plugin p) {
        String filename;
        String indexUrl;
        Boolean disabled;
        String id = Url.encode(p.getName());
        String version = p.getVersion();
        Boolean bl = disabled = p.isDisabled() ? Boolean.valueOf(true) : null;
        if (p.getSrcFile() != null) {
            indexUrl = String.format("plugins/%s/", p.getName());
            filename = p.getSrcFile().getFileName().toString();
        } else {
            indexUrl = null;
            filename = null;
        }
        return new PluginInfo(id, version, indexUrl, filename, disabled);
    }
}

