/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.collect.Streams;
import com.google.gerrit.server.plugins.ServerPluginProvider;
import java.nio.file.Path;
import java.util.stream.Collectors;

class MultipleProvidersForPluginException
extends IllegalArgumentException {
    private static final long serialVersionUID = 1L;

    MultipleProvidersForPluginException(Path pluginSrcPath, Iterable<ServerPluginProvider> providersHandlers) {
        super(pluginSrcPath.toAbsolutePath() + " is claimed to be handled by more than one plugin provider: " + MultipleProvidersForPluginException.providersListToString(providersHandlers));
    }

    private static String providersListToString(Iterable<ServerPluginProvider> providersHandlers) {
        return Streams.stream(providersHandlers).map(ServerPluginProvider::getProviderPluginName).collect(Collectors.joining(", "));
    }
}

