/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.api.projects.DeleteTagsInput;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.DeleteRef;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class DeleteTags
implements RestModifyView<ProjectResource, DeleteTagsInput> {
    private final DeleteRef.Factory deleteRefFactory;

    @Inject
    DeleteTags(DeleteRef.Factory deleteRefFactory) {
        this.deleteRefFactory = deleteRefFactory;
    }

    public Response<?> apply(ProjectResource project, DeleteTagsInput input) throws OrmException, RestApiException, IOException, PermissionBackendException {
        if (input == null || input.tags == null || input.tags.isEmpty()) {
            throw new BadRequestException("tags must be specified");
        }
        this.deleteRefFactory.create(project).refs(input.tags).prefix("refs/tags/").delete();
        return Response.none();
    }
}

