/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.extensions.client.Theme;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.patch.PatchListKey;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_114;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;

public class Schema_115
extends SchemaVersion {
    private final GitRepositoryManager mgr;
    private final AllUsersName allUsersName;
    private final PersonIdent serverUser;

    @Inject
    Schema_115(Provider<Schema_114> prior, GitRepositoryManager mgr, AllUsersName allUsersName, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.mgr = mgr;
        this.allUsersName = allUsersName;
        this.serverUser = serverUser;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        Throwable throwable;
        HashMap<Account.Id, DiffPreferencesInfo> imports = new HashMap<Account.Id, DiffPreferencesInfo>();
        try (Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();){
            throwable = null;
            try (ResultSet rs = stmt.executeQuery("SELECT * FROM account_diff_preferences");){
                Set<String> availableColumns = this.getColumns(rs);
                while (rs.next()) {
                    Account.Id accountId = new Account.Id(rs.getInt("id"));
                    DiffPreferencesInfo prefs = new DiffPreferencesInfo();
                    if (availableColumns.contains("context")) {
                        prefs.context = rs.getShort("context");
                    }
                    if (availableColumns.contains("expand_all_comments")) {
                        prefs.expandAllComments = Schema_115.toBoolean(rs.getString("expand_all_comments"));
                    }
                    if (availableColumns.contains("hide_line_numbers")) {
                        prefs.hideLineNumbers = Schema_115.toBoolean(rs.getString("hide_line_numbers"));
                    }
                    if (availableColumns.contains("hide_top_menu")) {
                        prefs.hideTopMenu = Schema_115.toBoolean(rs.getString("hide_top_menu"));
                    }
                    if (availableColumns.contains("ignore_whitespace")) {
                        prefs.ignoreWhitespace = Schema_115.toWhitespace(rs.getString("ignore_whitespace"));
                    }
                    if (availableColumns.contains("intraline_difference")) {
                        prefs.intralineDifference = Schema_115.toBoolean(rs.getString("intraline_difference"));
                    }
                    if (availableColumns.contains("line_length")) {
                        prefs.lineLength = rs.getInt("line_length");
                    }
                    if (availableColumns.contains("manual_review")) {
                        prefs.manualReview = Schema_115.toBoolean(rs.getString("manual_review"));
                    }
                    if (availableColumns.contains("render_entire_file")) {
                        prefs.renderEntireFile = Schema_115.toBoolean(rs.getString("render_entire_file"));
                    }
                    if (availableColumns.contains("retain_header")) {
                        prefs.retainHeader = Schema_115.toBoolean(rs.getString("retain_header"));
                    }
                    if (availableColumns.contains("show_line_endings")) {
                        prefs.showLineEndings = Schema_115.toBoolean(rs.getString("show_line_endings"));
                    }
                    if (availableColumns.contains("show_tabs")) {
                        prefs.showTabs = Schema_115.toBoolean(rs.getString("show_tabs"));
                    }
                    if (availableColumns.contains("show_whitespace_errors")) {
                        prefs.showWhitespaceErrors = Schema_115.toBoolean(rs.getString("show_whitespace_errors"));
                    }
                    if (availableColumns.contains("skip_deleted")) {
                        prefs.skipDeleted = Schema_115.toBoolean(rs.getString("skip_deleted"));
                    }
                    if (availableColumns.contains("skip_uncommented")) {
                        prefs.skipUncommented = Schema_115.toBoolean(rs.getString("skip_uncommented"));
                    }
                    if (availableColumns.contains("syntax_highlighting")) {
                        prefs.syntaxHighlighting = Schema_115.toBoolean(rs.getString("syntax_highlighting"));
                    }
                    if (availableColumns.contains("tab_size")) {
                        prefs.tabSize = rs.getInt("tab_size");
                    }
                    if (availableColumns.contains("theme")) {
                        prefs.theme = Schema_115.toTheme(rs.getString("theme"));
                    }
                    if (availableColumns.contains("hide_empty_pane")) {
                        prefs.hideEmptyPane = Schema_115.toBoolean(rs.getString("hide_empty_pane"));
                    }
                    if (availableColumns.contains("auto_hide_diff_table_header")) {
                        prefs.autoHideDiffTableHeader = Schema_115.toBoolean(rs.getString("auto_hide_diff_table_header"));
                    }
                    imports.put(accountId, prefs);
                }
            }
            catch (Throwable availableColumns) {
                throwable = availableColumns;
                throw availableColumns;
            }
        }
        if (imports.isEmpty()) {
            return;
        }
        try {
            var5_6 = null;
            try (Repository git = this.mgr.openRepository(this.allUsersName);){
                throwable = null;
                try (RevWalk rw = new RevWalk(git);){
                    BatchRefUpdate bru = git.getRefDatabase().newBatchUpdate();
                    for (Map.Entry e : imports.entrySet()) {
                        try (MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allUsersName, git, bru);){
                            md.getCommitBuilder().setAuthor(this.serverUser);
                            md.getCommitBuilder().setCommitter(this.serverUser);
                            VersionedAccountPreferences p = VersionedAccountPreferences.forUser((Account.Id)e.getKey());
                            p.load(md);
                            ConfigUtil.storeSection(p.getConfig(), "diff", null, (DiffPreferencesInfo)e.getValue(), DiffPreferencesInfo.defaults());
                            p.commit(md);
                        }
                    }
                    bru.execute(rw, NullProgressMonitor.INSTANCE);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                var5_6 = throwable3;
                throw throwable3;
            }
        }
        catch (IOException | ConfigInvalidException ex) {
            throw new OrmException(ex);
        }
    }

    private Set<String> getColumns(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        HashSet<String> columns = new HashSet<String>(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            columns.add(metaData.getColumnLabel(i).toLowerCase());
        }
        return columns;
    }

    private static Theme toTheme(String v) {
        if (v == null) {
            return Theme.DEFAULT;
        }
        return Theme.valueOf(v);
    }

    private static DiffPreferencesInfo.Whitespace toWhitespace(String v) {
        Preconditions.checkNotNull(v);
        if (v.isEmpty()) {
            return DiffPreferencesInfo.Whitespace.IGNORE_NONE;
        }
        DiffPreferencesInfo.Whitespace r = (DiffPreferencesInfo.Whitespace)((Object)((ImmutableMap)((Object)PatchListKey.WHITESPACE_TYPES.inverse())).get(Character.valueOf(v.charAt(0))));
        if (r == null) {
            throw new IllegalArgumentException("Cannot find Whitespace type for: " + v);
        }
        return r;
    }

    private static boolean toBoolean(String v) {
        Preconditions.checkState(!Strings.isNullOrEmpty(v));
        return v.equals("Y");
    }
}

