/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.primitives.Ints;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.account.externalids.ExternalIdReader;
import com.google.gerrit.server.account.externalids.ExternalIdsUpdate;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_147;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.SQLException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevWalk;

public class Schema_148
extends SchemaVersion {
    private static final String COMMIT_MSG = "Make account IDs of external IDs human-readable";
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;
    private final PersonIdent serverUser;

    @Inject
    Schema_148(Provider<Schema_147> prior, GitRepositoryManager repoManager, AllUsersName allUsersName, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
        this.serverUser = serverUser;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);
             RevWalk rw = new RevWalk(repo);
             ObjectInserter ins = repo.newObjectInserter();){
            ObjectId rev = ExternalIdReader.readRevision(repo);
            NoteMap noteMap = ExternalIdReader.readNoteMap(rw, rev);
            boolean dirty = false;
            for (Note note : noteMap) {
                byte[] raw = rw.getObjectReader().open(note.getData(), 3).getCachedBytes(524288);
                try {
                    ExternalId extId = ExternalId.parse(note.getName(), raw, note.getData());
                    if (!Schema_148.needsUpdate(extId)) continue;
                    ExternalIdsUpdate.upsert(rw, ins, noteMap, extId);
                    dirty = true;
                }
                catch (ConfigInvalidException e) {
                    ui.message(String.format("Warning: Ignoring invalid external ID note %s", note.getName()));
                }
            }
            if (dirty) {
                ExternalIdsUpdate.commit(this.allUsersName, repo, rw, ins, rev, noteMap, COMMIT_MSG, this.serverUser, this.serverUser, null, GitReferenceUpdated.DISABLED);
            }
        }
        catch (IOException e) {
            throw new OrmException("Failed to update external IDs", e);
        }
    }

    private static boolean needsUpdate(ExternalId extId) {
        Config cfg = new Config();
        cfg.setInt("externalId", extId.key().get(), "accountId", extId.accountId().get());
        return Ints.tryParse(cfg.getString("externalId", extId.key().get(), "accountId")) == null;
    }
}

