/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.primitives.Ints;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.StarredChangesUtil;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_160;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

public class Schema_161
extends SchemaVersion {
    private static final String MUTE_LABEL = "mute";
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;

    @Inject
    Schema_161(Provider<Schema_160> prior, GitRepositoryManager repoManager, AllUsersName allUsersName) {
        super(prior);
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException {
        try (Repository git = this.repoManager.openRepository(this.allUsersName);
             RevWalk rw = new RevWalk(git);){
            BatchRefUpdate bru = git.getRefDatabase().newBatchUpdate();
            bru.setAllowNonFastForwards(true);
            for (Ref ref : git.getRefDatabase().getRefs("refs/starred-changes/").values()) {
                StarredChangesUtil.StarRef starRef = StarredChangesUtil.readLabels(git, ref.getName());
                Set<Integer> mutedPatchSets = StarredChangesUtil.getStarredPatchSets(starRef.labels(), MUTE_LABEL);
                if (mutedPatchSets.isEmpty()) continue;
                Set<Integer> reviewedPatchSets = StarredChangesUtil.getStarredPatchSets(starRef.labels(), "reviewed");
                Set<Integer> unreviewedPatchSets = StarredChangesUtil.getStarredPatchSets(starRef.labels(), "unreviewed");
                List<String> newLabels = starRef.labels().stream().map(l -> {
                    if (l.startsWith(MUTE_LABEL)) {
                        Integer mutedPatchSet = Ints.tryParse(l.substring(MUTE_LABEL.length() + 1));
                        if (mutedPatchSet == null) {
                            return l;
                        }
                        if (!reviewedPatchSets.contains(mutedPatchSet) && !unreviewedPatchSets.contains(mutedPatchSet)) {
                            return "reviewed/" + mutedPatchSet;
                        }
                        return null;
                    }
                    return l;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                ObjectId id = StarredChangesUtil.writeLabels(git, newLabels);
                bru.addCommand(new ReceiveCommand(ref.getTarget().getObjectId(), id, ref.getName()));
            }
            bru.execute(rw, new TextProgressMonitor());
        }
        catch (StarredChangesUtil.IllegalLabelException | IOException ex) {
            throw new OrmException(ex);
        }
    }
}

