/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.update;

import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.metrics.Counter0;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.Histogram0;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.LockFailureException;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.update.AutoValue_RetryHelper_Options;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.NoteDbBatchUpdate;
import com.google.gerrit.server.update.ReviewDbBatchUpdate;
import com.google.gerrit.server.update.UpdateException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;

@Singleton
public class RetryHelper {
    private final NotesMigration migration;
    private final Metrics metrics;
    private final BatchUpdate.Factory updateFactory;
    private final Duration defaultTimeout;
    private final WaitStrategy waitStrategy;

    public static Options.Builder options() {
        return new AutoValue_RetryHelper_Options.Builder();
    }

    public static Options defaults() {
        return RetryHelper.options().build();
    }

    @Inject
    RetryHelper(@GerritServerConfig Config cfg, Metrics metrics, NotesMigration migration, ReviewDbBatchUpdate.AssistedFactory reviewDbBatchUpdateFactory, NoteDbBatchUpdate.AssistedFactory noteDbBatchUpdateFactory) {
        this.metrics = metrics;
        this.migration = migration;
        this.updateFactory = new BatchUpdate.Factory(migration, reviewDbBatchUpdateFactory, noteDbBatchUpdateFactory);
        this.defaultTimeout = Duration.ofMillis(cfg.getTimeUnit("noteDb", null, "retryTimeout", TimeUnit.SECONDS.toMillis(20L), TimeUnit.MILLISECONDS));
        this.waitStrategy = WaitStrategies.join(WaitStrategies.exponentialWait(cfg.getTimeUnit("noteDb", null, "retryMaxWait", TimeUnit.SECONDS.toMillis(5L), TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS), WaitStrategies.randomWait(50L, TimeUnit.MILLISECONDS));
    }

    public Duration getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public <T> T execute(Action<T> action) throws RestApiException, UpdateException {
        return this.execute(action, RetryHelper.defaults());
    }

    public <T> T execute(Action<T> action, Options opts) throws RestApiException, UpdateException {
        MetricListener listener = null;
        try {
            RetryerBuilder builder = RetryerBuilder.newBuilder();
            if (this.migration.disableChangeReviewDb()) {
                listener = new MetricListener(opts.listener());
                builder.withRetryListener(listener).withStopStrategy(StopStrategies.stopAfterDelay(MoreObjects.firstNonNull(opts.timeout(), this.defaultTimeout).toMillis(), TimeUnit.MILLISECONDS)).withWaitStrategy(this.waitStrategy).retryIfException(RetryHelper::isLockFailure);
            }
            Object object = builder.build().call(() -> action.call(this.updateFactory));
            return (T)object;
        }
        catch (RetryException | ExecutionException e) {
            if (e instanceof RetryException) {
                this.metrics.timeoutCount.increment();
            }
            if (e.getCause() != null) {
                Throwables.throwIfInstanceOf(e.getCause(), UpdateException.class);
                Throwables.throwIfInstanceOf(e.getCause(), RestApiException.class);
            }
            throw new UpdateException(e);
        }
        finally {
            if (listener != null) {
                this.metrics.attemptCounts.record(listener.getAttemptCount());
            }
        }
    }

    private static boolean isLockFailure(Throwable t) {
        if (t instanceof UpdateException) {
            t = t.getCause();
        }
        return t instanceof LockFailureException;
    }

    private static class MetricListener
    implements RetryListener {
        private final RetryListener delegate;
        private long attemptCount;

        MetricListener(@Nullable RetryListener delegate) {
            this.delegate = delegate;
            this.attemptCount = 1L;
        }

        @Override
        public <V> void onRetry(Attempt<V> attempt) {
            this.attemptCount = attempt.getAttemptNumber();
            if (this.delegate != null) {
                this.delegate.onRetry(attempt);
            }
        }

        long getAttemptCount() {
            return this.attemptCount;
        }
    }

    @Singleton
    private static class Metrics {
        final Histogram0 attemptCounts;
        final Counter0 timeoutCount;

        @Inject
        Metrics(MetricMaker metricMaker) {
            this.attemptCounts = metricMaker.newHistogram("batch_update/retry_attempt_counts", new Description("Distribution of number of attempts made by RetryHelper (1 == single attempt, no retry)").setCumulative().setUnit("attempts"));
            this.timeoutCount = metricMaker.newCounter("batch_update/retry_timeout_count", new Description("Number of executions of RetryHelper that ultimately timed out").setCumulative().setUnit("timeouts"));
        }
    }

    @AutoValue
    public static abstract class Options {
        @Nullable
        abstract RetryListener listener();

        @Nullable
        abstract Duration timeout();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder listener(RetryListener var1);

            public abstract Builder timeout(Duration var1);

            public abstract Options build();
        }
    }

    public static interface Action<T> {
        public T call(BatchUpdate.Factory var1) throws Exception;
    }
}

