/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Provider;
import com.google.inject.util.Providers;

public class ManualRequestContext
implements RequestContext,
AutoCloseable {
    private final Provider<CurrentUser> userProvider;
    private final Provider<ReviewDb> db;
    private final ThreadLocalRequestContext requestContext;
    private final RequestContext old;

    public ManualRequestContext(CurrentUser user, SchemaFactory<ReviewDb> schemaFactory, ThreadLocalRequestContext requestContext) throws OrmException {
        this(Providers.of(user), schemaFactory, requestContext);
    }

    public ManualRequestContext(Provider<CurrentUser> userProvider, SchemaFactory<ReviewDb> schemaFactory, ThreadLocalRequestContext requestContext) throws OrmException {
        this.userProvider = userProvider;
        this.db = Providers.of(schemaFactory.open());
        this.requestContext = requestContext;
        this.old = requestContext.setContext(this);
    }

    @Override
    public CurrentUser getUser() {
        return this.userProvider.get();
    }

    @Override
    public Provider<ReviewDb> getReviewDbProvider() {
        return this.db;
    }

    @Override
    public void close() {
        this.requestContext.setContext(this.old);
        this.db.get().close();
    }
}

