/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.FileUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PeerDaemonUser;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.sshd.SshKeyCacheEntry;
import com.google.gerrit.sshd.SshKeyCacheImpl;
import com.google.gerrit.sshd.SshLog;
import com.google.gerrit.sshd.SshScope;
import com.google.gerrit.sshd.SshSession;
import com.google.gerrit.sshd.SshUtil;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatabasePubKeyAuth
implements PublickeyAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(DatabasePubKeyAuth.class);
    private final SshKeyCacheImpl sshKeyCache;
    private final SshLog sshLog;
    private final IdentifiedUser.GenericFactory userFactory;
    private final PeerDaemonUser.Factory peerFactory;
    private final Config config;
    private final SshScope sshScope;
    private final Set<PublicKey> myHostKeys;
    private volatile PeerKeyCache peerKeyCache;

    @Inject
    DatabasePubKeyAuth(SshKeyCacheImpl skc, SshLog l, IdentifiedUser.GenericFactory uf, PeerDaemonUser.Factory pf, SitePaths site, KeyPairProvider hostKeyProvider, @GerritServerConfig Config cfg, SshScope s) {
        this.sshKeyCache = skc;
        this.sshLog = l;
        this.userFactory = uf;
        this.peerFactory = pf;
        this.config = cfg;
        this.sshScope = s;
        this.myHostKeys = DatabasePubKeyAuth.myHostKeys(hostKeyProvider);
        this.peerKeyCache = new PeerKeyCache(site.peer_keys);
    }

    private static Set<PublicKey> myHostKeys(KeyPairProvider p) {
        HashSet<PublicKey> keys = new HashSet<PublicKey>(6);
        DatabasePubKeyAuth.addPublicKey(keys, p, "ssh-ed25519");
        DatabasePubKeyAuth.addPublicKey(keys, p, KeyPairProvider.ECDSA_SHA2_NISTP256);
        DatabasePubKeyAuth.addPublicKey(keys, p, KeyPairProvider.ECDSA_SHA2_NISTP384);
        DatabasePubKeyAuth.addPublicKey(keys, p, KeyPairProvider.ECDSA_SHA2_NISTP521);
        DatabasePubKeyAuth.addPublicKey(keys, p, "ssh-rsa");
        DatabasePubKeyAuth.addPublicKey(keys, p, "ssh-dss");
        return keys;
    }

    private static void addPublicKey(Collection<PublicKey> out, KeyPairProvider p, String type) {
        KeyPair pair = p.loadKey(type);
        if (pair != null && pair.getPublic() != null) {
            out.add(pair.getPublic());
        }
    }

    @Override
    public boolean authenticate(String username, PublicKey suppliedKey, ServerSession session) {
        Iterable<SshKeyCacheEntry> keyList;
        SshKeyCacheEntry key;
        SshSession sd = session.getAttribute(SshSession.KEY);
        Preconditions.checkState(sd.getUser() == null);
        if ("Gerrit Code Review".equals(username)) {
            if (this.myHostKeys.contains(suppliedKey) || this.getPeerKeys().contains(suppliedKey)) {
                PeerDaemonUser user = this.peerFactory.create(sd.getRemoteAddress());
                return SshUtil.success(username, session, this.sshScope, this.sshLog, sd, user);
            }
            sd.authenticationError(username, "no-matching-key");
            return false;
        }
        if (this.config.getBoolean("auth", "userNameToLowerCase", false)) {
            username = username.toLowerCase(Locale.US);
        }
        if ((key = this.find(keyList = this.sshKeyCache.get(username), suppliedKey)) == null) {
            String err = keyList == SshKeyCacheImpl.NO_SUCH_USER ? "user-not-found" : (keyList == SshKeyCacheImpl.NO_KEYS ? "key-list-empty" : "no-matching-key");
            sd.authenticationError(username, err);
            return false;
        }
        for (SshKeyCacheEntry otherKey : keyList) {
            if (key.getAccount().equals(otherKey.getAccount())) continue;
            sd.authenticationError(username, "keys-cross-accounts");
            return false;
        }
        IdentifiedUser cu = SshUtil.createUser(sd, this.userFactory, key.getAccount());
        if (!cu.getAccount().isActive()) {
            sd.authenticationError(username, "inactive-account");
            return false;
        }
        return SshUtil.success(username, session, this.sshScope, this.sshLog, sd, cu);
    }

    private Set<PublicKey> getPeerKeys() {
        PeerKeyCache p = this.peerKeyCache;
        if (!p.isCurrent()) {
            this.peerKeyCache = p = p.reload();
        }
        return p.keys;
    }

    private SshKeyCacheEntry find(Iterable<SshKeyCacheEntry> keyList, PublicKey suppliedKey) {
        for (SshKeyCacheEntry k : keyList) {
            if (!k.match(suppliedKey)) continue;
            return k;
        }
        return null;
    }

    private static class PeerKeyCache {
        private final Path path;
        private final long modified;
        final Set<PublicKey> keys;

        PeerKeyCache(Path path) {
            this.path = path;
            this.modified = FileUtil.lastModified(path);
            this.keys = PeerKeyCache.read(path);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static Set<PublicKey> read(Path path) {
            try (BufferedReader br = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                String line;
                HashSet<PublicKey> keys = new HashSet<PublicKey>();
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
                    try {
                        byte[] bin = Base64.decodeBase64(line.getBytes(StandardCharsets.ISO_8859_1));
                        keys.add(new ByteArrayBuffer(bin).getRawPublicKey());
                    }
                    catch (RuntimeException | SshException e) {
                        PeerKeyCache.logBadKey(path, line, e);
                    }
                }
                Set<PublicKey> set = Collections.unmodifiableSet(keys);
                return set;
            }
            catch (NoSuchFileException noFile) {
                return Collections.emptySet();
            }
            catch (IOException err) {
                log.error("Cannot read " + path, err);
                return Collections.emptySet();
            }
        }

        private static void logBadKey(Path path, String line, Exception e) {
            log.warn("Invalid key in " + path + ":\n  " + line, e);
        }

        boolean isCurrent() {
            return this.modified == FileUtil.lastModified(this.path);
        }

        PeerKeyCache reload() {
            return new PeerKeyCache(this.path);
        }
    }
}

