/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.sshd.AdminHighPriorityCommand;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gerrit.sshd.commands.QueryShell;
import com.google.inject.Inject;
import org.kohsuke.args4j.Option;

@AdminHighPriorityCommand
@RequiresCapability(value="accessDatabase")
@CommandMetaData(name="gsql", description="Administrative interface to active database")
final class AdminQueryShell
extends SshCommand {
    @Inject
    private PermissionBackend permissionBackend;
    @Inject
    private QueryShell.Factory factory;
    @Inject
    private IdentifiedUser currentUser;
    @Option(name="--format", usage="Set output format")
    private QueryShell.OutputFormat format = QueryShell.OutputFormat.PRETTY;
    @Option(name="-c", metaVar="SQL QUERY", usage="Query to execute")
    private String query;

    AdminQueryShell() {
    }

    @Override
    protected void run() throws BaseCommand.Failure {
        try {
            this.permissionBackend.user(this.currentUser).check(GlobalPermission.ACCESS_DATABASE);
        }
        catch (AuthException err) {
            throw this.die(err.getMessage());
        }
        catch (PermissionBackendException e) {
            throw new BaseCommand.Failure(1, "unavailable", e);
        }
        QueryShell shell = this.factory.create(this.in, this.out);
        shell.setOutputFormat(this.format);
        if (this.query != null) {
            shell.execute(this.query);
        } else {
            shell.run();
        }
    }
}

