/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.server.index.ReindexerAlreadyRunningException;
import com.google.gerrit.server.index.VersionManager;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@RequiresCapability(value="administrateServer")
@CommandMetaData(name="start", description="Start the online reindexer")
public class IndexStartCommand
extends SshCommand {
    @Option(name="--force", usage="force a re-index")
    private boolean force;
    @Argument(index=0, required=true, metaVar="INDEX", usage="index name to start")
    private String name;
    @Inject
    private VersionManager versionManager;

    @Override
    protected void run() throws BaseCommand.UnloggedFailure {
        try {
            if (this.versionManager.isKnownIndex(this.name)) {
                if (this.versionManager.startReindexer(this.name, this.force)) {
                    this.stdout.println("Reindexer started");
                } else {
                    this.stdout.println("Nothing to reindex, index is already the latest version");
                }
            } else {
                this.stderr.println(String.format("Cannot reindex %s: unknown", this.name));
            }
        }
        catch (ReindexerAlreadyRunningException e) {
            throw this.die("Failed to start reindexer: " + e.getMessage());
        }
    }
}

