/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.plugin;

import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandModule;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.Config;
import org.kohsuke.args4j.Argument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LfsPluginAuthCommand
extends SshCommand {
    private static final Logger log = LoggerFactory.getLogger(LfsPluginAuthCommand.class);
    private static final String CONFIGURATION_ERROR = "Server configuration error: LFS auth over SSH is not properly configured.";
    private final DynamicItem<LfsSshPluginAuth> auth;
    private final Provider<CurrentUser> user;
    @Argument(index=0, multiValued=true, metaVar="PARAMS")
    private List<String> args = new ArrayList<String>();

    @Inject
    LfsPluginAuthCommand(DynamicItem<LfsSshPluginAuth> auth, Provider<CurrentUser> user) {
        this.auth = auth;
        this.user = user;
    }

    @Override
    protected void run() throws BaseCommand.UnloggedFailure, Exception {
        LfsSshPluginAuth pluginAuth = this.auth.get();
        if (pluginAuth == null) {
            log.warn(CONFIGURATION_ERROR);
            throw new BaseCommand.UnloggedFailure(1, CONFIGURATION_ERROR);
        }
        this.stdout.print(pluginAuth.authenticate(this.user.get(), this.args));
    }

    public static class Module
    extends CommandModule {
        private final boolean pluginProvided;

        @Inject
        Module(@GerritServerConfig Config cfg) {
            this.pluginProvided = cfg.getString("lfs", null, "plugin") != null;
        }

        @Override
        protected void configure() {
            if (this.pluginProvided) {
                this.command("git-lfs-authenticate").to(LfsPluginAuthCommand.class);
                DynamicItem.itemOf(this.binder(), LfsSshPluginAuth.class);
            }
        }
    }

    public static interface LfsSshPluginAuth {
        public String authenticate(CurrentUser var1, List<String> var2) throws BaseCommand.UnloggedFailure, BaseCommand.Failure;
    }
}

