/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.jdbc;

import com.google.gwtorm.client.Key;
import com.google.gwtorm.jdbc.JdbcAccess;
import com.google.gwtorm.server.AbstractResultSet;
import com.google.gwtorm.server.OrmRuntimeException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;

class JdbcResultSet<T, K extends Key<?>>
extends AbstractResultSet<T> {
    private final JdbcAccess<T, K> access;
    private final ResultSet rs;
    private final PreparedStatement ps;
    private Boolean haveRow;
    private boolean closed;

    JdbcResultSet(JdbcAccess<T, K> jdbcAccess, ResultSet rs, PreparedStatement ps) {
        this.access = jdbcAccess;
        this.rs = rs;
        this.ps = ps;
        this.haveRow = Boolean.TRUE;
    }

    @Override
    protected boolean hasNext() {
        if (this.closed) {
            return false;
        }
        if (this.haveRow == null) {
            try {
                if (this.rs.next()) {
                    this.haveRow = Boolean.TRUE;
                } else {
                    this.haveRow = Boolean.FALSE;
                    this.close();
                }
            }
            catch (SQLException err) {
                this.close();
                throw new OrmRuntimeException(this.access.convertError("fetch", err));
            }
        }
        return this.haveRow;
    }

    @Override
    protected T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T o = this.access.newEntityInstance();
        try {
            this.access.bindOneFetch(this.rs, o);
        }
        catch (SQLException err) {
            this.close();
            throw new OrmRuntimeException(this.access.convertError("fetch", err));
        }
        this.haveRow = null;
        this.hasNext();
        return o;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

