/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema;

import com.google.gwtorm.client.Column;
import com.google.gwtorm.schema.Util;
import com.google.gwtorm.server.OrmException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public abstract class ColumnModel {
    protected ColumnModel parent;
    private String origName;
    protected int columnId;
    protected String columnName;
    protected Column column;
    protected Collection<ColumnModel> nestedColumns = Collections.emptyList();
    protected boolean rowVersion;
    protected boolean inPrimaryKey;
    protected boolean notNull;

    protected ColumnModel() {
    }

    protected void initName(String fieldName, Column col) throws OrmException {
        if (col == null) {
            throw new OrmException("Field " + fieldName + " is missing " + Column.class.getName() + " annotation");
        }
        this.column = col;
        this.columnName = this.origName = Util.any(this.column.name(), Util.makeSqlFriendly(fieldName));
        this.columnId = this.column.id();
        if (this.columnId < 1) {
            throw new OrmException("Field " + fieldName + " cannot have id < 1");
        }
        this.notNull = this.column.notNull();
    }

    protected void initNestedColumns(Collection<? extends ColumnModel> col) throws OrmException {
        this.nestedColumns = new ArrayList<ColumnModel>(col);
        this.recomputeColumnNames();
        if (!this.isNotNull()) {
            for (ColumnModel c : this.getAllLeafColumns()) {
                c.notNull = false;
            }
        }
        HashSet<Integer> ids = new HashSet<Integer>();
        for (ColumnModel c : this.nestedColumns) {
            if (ids.add(c.columnId)) continue;
            throw new OrmException("Duplicate @Column id " + c.columnId + " in " + c.getPathToFieldName());
        }
    }

    private void recomputeColumnNames() {
        boolean thisHasName = !this.columnName.equals("--NONE--");
        for (ColumnModel c : this.nestedColumns) {
            c.parent = this;
            c.columnName = this.nestedColumns.size() == 1 ? (thisHasName ? this.columnName : c.origName) : (thisHasName ? this.columnName + "_" + c.origName : c.origName);
            c.recomputeColumnNames();
        }
    }

    public Collection<ColumnModel> getNestedColumns() {
        return this.nestedColumns;
    }

    public ColumnModel getField(String name) {
        for (ColumnModel c : this.nestedColumns) {
            if (!c.getFieldName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public Collection<ColumnModel> getAllLeafColumns() {
        ArrayList<ColumnModel> r = new ArrayList<ColumnModel>();
        for (ColumnModel c : this.nestedColumns) {
            if (c.isNested()) {
                r.addAll(c.getAllLeafColumns());
                continue;
            }
            r.add(c);
        }
        return r;
    }

    public ColumnModel getParent() {
        return this.parent;
    }

    public String getPathToFieldName() {
        if (this.getParent() == null) {
            return this.getFieldName();
        }
        return this.getParent().getPathToFieldName() + "." + this.getFieldName();
    }

    public int getColumnID() {
        return this.columnId;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isSqlPrimitive() {
        return this.getPrimitiveType() != null;
    }

    public boolean isNested() {
        return !this.isCollection() && this.getPrimitiveType() == null;
    }

    public boolean isRowVersion() {
        return this.rowVersion;
    }

    public Column getColumnAnnotation() {
        return this.column;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public abstract boolean isCollection();

    public abstract String getFieldName();

    public abstract Class<?> getPrimitiveType();

    public abstract Type[] getArgumentTypes();

    public abstract String getNestedClassName();

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Column[\n");
        r.append("  id:       " + this.getColumnID() + "\n");
        r.append("  field:    " + this.getPathToFieldName() + "\n");
        r.append("  column:   " + this.getColumnName() + "\n");
        if (this.isSqlPrimitive()) {
            r.append("  type:     " + this.getPrimitiveType().getName() + "\n");
        } else {
            r.append("  contains: " + this.getNestedClassName() + "\n");
        }
        r.append("]");
        return r.toString();
    }
}

