/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.CaseFormat;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;

final class ResolvePackageRelativeCssNamesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind PACKAGE_RELATIVE_CLASS_NAME_USED_WITH_COMPONENT_NAME = SoyErrorKind.of("Package-relative class name ''{0}'' cannot be used with component expression");
    private static final SoyErrorKind NO_CSS_PACKAGE = SoyErrorKind.of("No CSS package defined for package-relative class name ''{0}''");
    private final ErrorReporter errorReporter;
    private String packagePrefix = null;

    ResolvePackageRelativeCssNamesVisitor(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.packagePrefix = null;
        if (node.getCssBaseNamespace() != null) {
            this.packagePrefix = ResolvePackageRelativeCssNamesVisitor.toCamelCase(node.getCssBaseNamespace());
        } else if (node.getParent().getCssBaseNamespace() != null) {
            this.packagePrefix = ResolvePackageRelativeCssNamesVisitor.toCamelCase(node.getParent().getCssBaseNamespace());
        } else if (!node.getParent().getRequiredCssNamespaces().isEmpty()) {
            this.packagePrefix = ResolvePackageRelativeCssNamesVisitor.toCamelCase((String)node.getParent().getRequiredCssNamespaces().get(0));
        }
        super.visitTemplateNode(node);
    }

    @Override
    protected void visitCssNode(CssNode node) {
        String selectorText = node.getSelectorText();
        if (!selectorText.startsWith("%")) {
            return;
        }
        if (node.getComponentNameExpr() != null) {
            this.errorReporter.report(node.getSourceLocation(), PACKAGE_RELATIVE_CLASS_NAME_USED_WITH_COMPONENT_NAME, selectorText);
        }
        if (this.packagePrefix == null) {
            this.errorReporter.report(node.getSourceLocation(), NO_CSS_PACKAGE, selectorText);
        }
        ParentNode parent = node.getParent();
        int indexInParent = parent.getChildIndex(node);
        parent.removeChild(indexInParent);
        CssNode newNode = new CssNode(node, this.packagePrefix + selectorText.substring(1), new CopyState());
        parent.addChild(indexInParent, newNode);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
        }
    }

    private static String toCamelCase(String packageName) {
        String packageNameWithDashes = packageName.replace('.', '-');
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, packageNameWithDashes);
    }
}

