/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import javax.annotation.Nullable;

public class ApiCallScopeUtils {
    private static final Key<String> LOCALE_STRING_KEY = Key.get(String.class, ApiCallScopeBindingAnnotations.LocaleString.class);
    private static final Key<BidiGlobalDir> GLOBAL_DIR_KEY = Key.get(BidiGlobalDir.class);

    private ApiCallScopeUtils() {
    }

    public static void seedSharedParams(GuiceSimpleScope.InScope inScope, @Nullable SoyMsgBundle msgBundle) {
        ApiCallScopeUtils.seedSharedParams(inScope, msgBundle, null);
    }

    public static void seedSharedParams(GuiceSimpleScope.InScope inScope, @Nullable SoyMsgBundle msgBundle, @Nullable BidiGlobalDir bidiGlobalDir) {
        String localeString;
        String string = localeString = msgBundle != null ? msgBundle.getLocaleString() : null;
        if (bidiGlobalDir == null) {
            bidiGlobalDir = BidiGlobalDir.forStaticIsRtl(msgBundle == null ? false : msgBundle.isRtl());
        }
        ApiCallScopeUtils.seedSharedParams(inScope, bidiGlobalDir, localeString);
    }

    public static void seedSharedParams(GuiceSimpleScope.InScope inScope, BidiGlobalDir bidiGlobalDir, @Nullable String localeString) {
        inScope.seed(LOCALE_STRING_KEY, localeString);
        inScope.seed(GLOBAL_DIR_KEY, Preconditions.checkNotNull(bidiGlobalDir));
    }
}

