/*
 * Decompiled with CFR 0.152.
 */
package gerrit;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.rules.PrologEnvironment;
import com.google.gerrit.rules.StoredValues;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.googlecode.prolog_cafe.exceptions.IllegalTypeException;
import com.googlecode.prolog_cafe.exceptions.PInstantiationException;
import com.googlecode.prolog_cafe.exceptions.PrologException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.VariableTerm;
import java.util.Map;

class PRED_current_user_2
extends Predicate.P2 {
    private static final SymbolTerm user = SymbolTerm.intern("user", 1);
    private static final SymbolTerm anonymous = SymbolTerm.intern("anonymous");

    PRED_current_user_2(Term a1, Term a2, Operation n) {
        this.arg1 = a1;
        this.arg2 = a2;
        this.cont = n;
    }

    @Override
    public Operation exec(Prolog engine) throws PrologException {
        engine.setB0();
        Term a1 = this.arg1.dereference();
        Term a2 = this.arg2.dereference();
        if (a1 instanceof VariableTerm) {
            throw new PInstantiationException(this, 1);
        }
        if (!a2.unify(this.createUser(engine, a1), engine.trail)) {
            return engine.fail();
        }
        return this.cont;
    }

    public Term createUser(Prolog engine, Term key) {
        CurrentUser user;
        if (!(key instanceof StructureTerm) || key.arity() != 1 || !((StructureTerm)key).functor().equals(PRED_current_user_2.user)) {
            throw new IllegalTypeException(this, 1, "user(int)", key);
        }
        Term idTerm = key.arg(0);
        if (idTerm instanceof IntegerTerm) {
            Account.Id accountId;
            Map<Account.Id, IdentifiedUser> cache = StoredValues.USERS.get(engine);
            user = cache.get(accountId = new Account.Id(((IntegerTerm)idTerm).intValue()));
            if (user == null) {
                IdentifiedUser.GenericFactory userFactory = PRED_current_user_2.userFactory(engine);
                IdentifiedUser who = userFactory.create(accountId);
                cache.put(accountId, who);
                user = who;
            }
        } else if (idTerm.equals(anonymous)) {
            user = StoredValues.ANONYMOUS_USER.get(engine);
        } else {
            throw new IllegalTypeException(this, 1, "user(int)", key);
        }
        return new JavaObjectTerm(user);
    }

    private static IdentifiedUser.GenericFactory userFactory(Prolog engine) {
        return ((PrologEnvironment)engine.control).getArgs().getUserFactory();
    }
}

