/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard.processors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.core.nodes.BooleanQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.FieldQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.FuzzyQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.GroupQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.ModifierQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.NoTokenFoundQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNodeImpl;
import org.apache.lucene.queryparser.flexible.core.nodes.QuotedFieldQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.RangeQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.TextableQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.TokenizedPhraseQueryNode;
import org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.queryparser.flexible.standard.nodes.MultiPhraseQueryNode;
import org.apache.lucene.queryparser.flexible.standard.nodes.RegexpQueryNode;
import org.apache.lucene.queryparser.flexible.standard.nodes.StandardBooleanQueryNode;
import org.apache.lucene.queryparser.flexible.standard.nodes.WildcardQueryNode;

public class AnalyzerQueryNodeProcessor
extends QueryNodeProcessorImpl {
    private Analyzer analyzer;
    private boolean positionIncrementsEnabled;
    private StandardQueryConfigHandler.Operator defaultOperator;

    @Override
    public QueryNode process(QueryNode queryTree) throws QueryNodeException {
        Analyzer analyzer = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.ANALYZER);
        if (analyzer != null) {
            this.analyzer = analyzer;
            this.positionIncrementsEnabled = false;
            Boolean positionIncrementsEnabled = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.ENABLE_POSITION_INCREMENTS);
            StandardQueryConfigHandler.Operator defaultOperator = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.DEFAULT_OPERATOR);
            StandardQueryConfigHandler.Operator operator = this.defaultOperator = defaultOperator != null ? defaultOperator : StandardQueryConfigHandler.Operator.OR;
            if (positionIncrementsEnabled != null) {
                this.positionIncrementsEnabled = positionIncrementsEnabled;
            }
            if (this.analyzer != null) {
                return super.process(queryTree);
            }
        }
        return queryTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        if (!(node instanceof TextableQueryNode)) return node;
        if (node instanceof WildcardQueryNode) return node;
        if (node instanceof FuzzyQueryNode) return node;
        if (node instanceof RegexpQueryNode) return node;
        if (node.getParent() instanceof RangeQueryNode) return node;
        FieldQueryNode fieldNode = (FieldQueryNode)node;
        String text = fieldNode.getTextAsString();
        String field = fieldNode.getFieldAsString();
        TokenFilter buffer = null;
        PositionIncrementAttribute posIncrAtt = null;
        int numTokens = 0;
        int positionCount = 0;
        boolean severalTokensAtSamePosition = false;
        try {
            TokenizedPhraseQueryNode pq;
            CharTermAttribute termAtt;
            block94: {
                block90: {
                    QueryNodeImpl currentQuery;
                    QueryNodeImpl q;
                    block93: {
                        LinkedList<QueryNode> children;
                        block92: {
                            block89: {
                                block91: {
                                    Object object;
                                    block88: {
                                        TokenStream source;
                                        try {
                                            source = this.analyzer.tokenStream(field, text);
                                            object = null;
                                            try {
                                                buffer = new CachingTokenFilter(source);
                                                ((CachingTokenFilter)buffer).reset();
                                                if (buffer.hasAttribute(PositionIncrementAttribute.class)) {
                                                    posIncrAtt = buffer.getAttribute(PositionIncrementAttribute.class);
                                                }
                                                try {}
                                                catch (IOException positionIncrement) {
                                                    // empty catch block
                                                    break block88;
                                                }
                                            }
                                            catch (Throwable x2) {
                                                object = x2;
                                                throw x2;
                                            }
                                        }
                                        catch (IOException e) {
                                            throw new RuntimeException(e);
                                        }
                                        while (((CachingTokenFilter)buffer).incrementToken()) {
                                            int positionIncrement;
                                            ++numTokens;
                                            int n = positionIncrement = posIncrAtt != null ? posIncrAtt.getPositionIncrement() : 1;
                                            if (positionIncrement != 0) {
                                                positionCount += positionIncrement;
                                                continue;
                                            }
                                            severalTokensAtSamePosition = true;
                                        }
                                        break block88;
                                        finally {
                                            if (source != null) {
                                                if (object != null) {
                                                    try {
                                                        source.close();
                                                    }
                                                    catch (Throwable x2) {
                                                        ((Throwable)object).addSuppressed(x2);
                                                    }
                                                } else {
                                                    source.close();
                                                }
                                            }
                                        }
                                    }
                                    ((CachingTokenFilter)buffer).reset();
                                    if (!buffer.hasAttribute(CharTermAttribute.class)) {
                                        NoTokenFoundQueryNode e = new NoTokenFoundQueryNode();
                                        return e;
                                    }
                                    termAtt = buffer.getAttribute(CharTermAttribute.class);
                                    if (numTokens == 0) {
                                        object = new NoTokenFoundQueryNode();
                                        return object;
                                    }
                                    if (numTokens == 1) {
                                        String term = null;
                                        try {
                                            boolean hasNext = ((CachingTokenFilter)buffer).incrementToken();
                                            assert (hasNext);
                                            term = termAtt.toString();
                                        }
                                        catch (IOException hasNext) {
                                            // empty catch block
                                        }
                                        fieldNode.setText(term);
                                        FieldQueryNode hasNext = fieldNode;
                                        return hasNext;
                                    }
                                    if (!severalTokensAtSamePosition && node instanceof QuotedFieldQueryNode) break block89;
                                    if (positionCount != 1 && node instanceof QuotedFieldQueryNode) break block90;
                                    if (positionCount != 1) break block91;
                                    children = new LinkedList<QueryNode>();
                                    break block92;
                                }
                                q = new StandardBooleanQueryNode(Collections.emptyList(), false);
                                currentQuery = null;
                                break block93;
                            }
                            pq = new TokenizedPhraseQueryNode();
                            int position = -1;
                            break block94;
                        }
                        for (int i = 0; i < numTokens; ++i) {
                            String term = null;
                            try {
                                boolean hasNext = ((CachingTokenFilter)buffer).incrementToken();
                                assert (hasNext);
                                term = termAtt.toString();
                            }
                            catch (IOException hasNext) {
                                // empty catch block
                            }
                            children.add(new FieldQueryNode(field, term, -1, -1));
                        }
                        GroupQueryNode i = new GroupQueryNode(new StandardBooleanQueryNode(children, positionCount == 1));
                        return i;
                    }
                    for (int i = 0; i < numTokens; ++i) {
                        String term = null;
                        try {
                            boolean hasNext = ((CachingTokenFilter)buffer).incrementToken();
                            assert (hasNext);
                            term = termAtt.toString();
                        }
                        catch (IOException hasNext) {
                            // empty catch block
                        }
                        if (posIncrAtt != null && posIncrAtt.getPositionIncrement() == 0) {
                            if (!(currentQuery instanceof BooleanQueryNode)) {
                                FieldQueryNode t = currentQuery;
                                currentQuery = new StandardBooleanQueryNode(Collections.emptyList(), true);
                                ((BooleanQueryNode)currentQuery).add(t);
                            }
                            ((BooleanQueryNode)currentQuery).add(new FieldQueryNode(field, term, -1, -1));
                            continue;
                        }
                        if (currentQuery != null) {
                            if (this.defaultOperator == StandardQueryConfigHandler.Operator.OR) {
                                q.add(currentQuery);
                            } else {
                                q.add(new ModifierQueryNode(currentQuery, ModifierQueryNode.Modifier.MOD_REQ));
                            }
                        }
                        currentQuery = new FieldQueryNode(field, term, -1, -1);
                    }
                    if (this.defaultOperator == StandardQueryConfigHandler.Operator.OR) {
                        q.add(currentQuery);
                    } else {
                        q.add(new ModifierQueryNode(currentQuery, ModifierQueryNode.Modifier.MOD_REQ));
                    }
                    if (q instanceof BooleanQueryNode) {
                        q = new GroupQueryNode(q);
                    }
                    StandardBooleanQueryNode i = q;
                    return i;
                }
                MultiPhraseQueryNode mpq = new MultiPhraseQueryNode();
                ArrayList<FieldQueryNode> multiTerms = new ArrayList<FieldQueryNode>();
                int position = -1;
                int i = 0;
                int termGroupCount = 0;
                while (true) {
                    if (i >= numTokens) break;
                    String term = null;
                    int positionIncrement = 1;
                    try {
                        boolean hasNext = ((CachingTokenFilter)buffer).incrementToken();
                        assert (hasNext);
                        term = termAtt.toString();
                        if (posIncrAtt != null) {
                            positionIncrement = posIncrAtt.getPositionIncrement();
                        }
                    }
                    catch (IOException hasNext) {
                        // empty catch block
                    }
                    if (positionIncrement > 0 && multiTerms.size() > 0) {
                        for (FieldQueryNode termNode : multiTerms) {
                            if (this.positionIncrementsEnabled) {
                                termNode.setPositionIncrement(position);
                            } else {
                                termNode.setPositionIncrement(termGroupCount);
                            }
                            mpq.add(termNode);
                        }
                        ++termGroupCount;
                        multiTerms.clear();
                    }
                    position += positionIncrement;
                    multiTerms.add(new FieldQueryNode(field, term, -1, -1));
                    ++i;
                }
                Object i$ = multiTerms.iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        i$ = mpq;
                        return i$;
                    }
                    FieldQueryNode termNode = (FieldQueryNode)i$.next();
                    if (this.positionIncrementsEnabled) {
                        termNode.setPositionIncrement(position);
                    } else {
                        termNode.setPositionIncrement(termGroupCount);
                    }
                    mpq.add(termNode);
                }
            }
            for (int i = 0; i < numTokens; ++i) {
                String term = null;
                int positionIncrement = 1;
                try {
                    boolean hasNext = ((CachingTokenFilter)buffer).incrementToken();
                    assert (hasNext);
                    term = termAtt.toString();
                    if (posIncrAtt != null) {
                        positionIncrement = posIncrAtt.getPositionIncrement();
                    }
                }
                catch (IOException hasNext) {
                    // empty catch block
                }
                FieldQueryNode newFieldNode = new FieldQueryNode(field, term, -1, -1);
                if (this.positionIncrementsEnabled) {
                    newFieldNode.setPositionIncrement(position += positionIncrement);
                } else {
                    newFieldNode.setPositionIncrement(i);
                }
                pq.add(newFieldNode);
            }
            TokenizedPhraseQueryNode tokenizedPhraseQueryNode = pq;
            return tokenizedPhraseQueryNode;
        }
        finally {
            if (buffer != null) {
                try {
                    buffer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

