/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.ValidateUtils;

public class Nio2Acceptor
extends Nio2Service
implements IoAcceptor {
    protected final Map<SocketAddress, AsynchronousServerSocketChannel> channels = new ConcurrentHashMap<SocketAddress, AsynchronousServerSocketChannel>();
    private int backlog = 0;

    public Nio2Acceptor(FactoryManager manager, IoHandler handler, AsynchronousChannelGroup group) {
        super(manager, handler, group);
        this.backlog = manager.getIntProperty("socket-backlog", 0);
    }

    @Override
    public void bind(Collection<? extends SocketAddress> addresses) throws IOException {
        AsynchronousChannelGroup group = this.getChannelGroup();
        for (SocketAddress socketAddress : addresses) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Binding Nio2Acceptor to address {}", (Object)socketAddress);
            }
            AsynchronousServerSocketChannel socket = this.setSocketOptions(this.openAsynchronousServerSocketChannel(socketAddress, group));
            socket.bind(socketAddress, this.backlog);
            SocketAddress local = socket.getLocalAddress();
            this.channels.put(local, socket);
            CompletionHandler<AsynchronousSocketChannel, ? super SocketAddress> handler = ValidateUtils.checkNotNull(this.createSocketCompletionHandler(this.channels, socket), "No completion handler created for address=%s", (Object)socketAddress);
            socket.accept(local, handler);
        }
    }

    protected AsynchronousServerSocketChannel openAsynchronousServerSocketChannel(SocketAddress address, AsynchronousChannelGroup group) throws IOException {
        return AsynchronousServerSocketChannel.open(group);
    }

    protected CompletionHandler<AsynchronousSocketChannel, ? super SocketAddress> createSocketCompletionHandler(Map<SocketAddress, AsynchronousServerSocketChannel> channelsMap, AsynchronousServerSocketChannel socket) throws IOException {
        return new AcceptCompletionHandler(socket);
    }

    @Override
    public void bind(SocketAddress address) throws IOException {
        this.bind(Collections.singleton(address));
    }

    @Override
    public void unbind() {
        this.log.debug("Unbinding");
        this.unbind(this.getBoundAddresses());
    }

    @Override
    public void unbind(Collection<? extends SocketAddress> addresses) {
        for (SocketAddress socketAddress : addresses) {
            AsynchronousServerSocketChannel channel = this.channels.remove(socketAddress);
            if (channel != null) {
                try {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("unbind({})", (Object)socketAddress);
                    }
                    channel.close();
                }
                catch (IOException e) {
                    this.log.warn("unbind({}) {} while unbinding channel: {}", socketAddress, e.getClass().getSimpleName(), e.getMessage());
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("unbind(" + socketAddress + ") failure details", e);
                }
                continue;
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("No active channel to unbind {}", (Object)socketAddress);
        }
    }

    @Override
    public void unbind(SocketAddress address) {
        this.unbind(Collections.singleton(address));
    }

    @Override
    public Set<SocketAddress> getBoundAddresses() {
        return new HashSet<SocketAddress>(this.channels.keySet());
    }

    @Override
    public CloseFuture close(boolean immediately) {
        this.unbind();
        return super.close(immediately);
    }

    @Override
    public void doCloseImmediately() {
        for (SocketAddress address : this.channels.keySet()) {
            try {
                this.channels.get(address).close();
            }
            catch (IOException e) {
                this.log.debug("Exception caught while closing channel", e);
            }
        }
        super.doCloseImmediately();
    }

    protected class AcceptCompletionHandler
    extends Nio2CompletionHandler<AsynchronousSocketChannel, SocketAddress> {
        protected final AsynchronousServerSocketChannel socket;

        AcceptCompletionHandler(AsynchronousServerSocketChannel socket) {
            this.socket = socket;
        }

        @Override
        protected void onCompleted(AsynchronousSocketChannel result, SocketAddress address) {
            block7: {
                if (!Nio2Acceptor.this.channels.containsKey(address)) {
                    return;
                }
                Closeable session = null;
                try {
                    IoHandler handler = Nio2Acceptor.this.getIoHandler();
                    Nio2Acceptor.this.setSocketOptions(result);
                    session = Objects.requireNonNull(this.createSession(Nio2Acceptor.this, address, result, handler), "No NIO2 session created");
                    handler.sessionCreated((IoSession)session);
                    Nio2Acceptor.this.sessions.put(((Nio2Session)session).getId(), session);
                    ((Nio2Session)session).startReading();
                }
                catch (Throwable exc) {
                    this.failed(exc, address);
                    if (session == null) break block7;
                    try {
                        session.close();
                    }
                    catch (Throwable t) {
                        Nio2Acceptor.this.log.warn("Failed (" + t.getClass().getSimpleName() + ")" + " to close accepted connection from " + address + ": " + t.getMessage(), t);
                    }
                }
            }
            try {
                this.socket.accept(address, this);
            }
            catch (Throwable exc) {
                this.failed(exc, address);
            }
        }

        protected Nio2Session createSession(Nio2Acceptor acceptor, SocketAddress address, AsynchronousSocketChannel channel, IoHandler handler) throws Throwable {
            if (Nio2Acceptor.this.log.isTraceEnabled()) {
                Nio2Acceptor.this.log.trace("createNio2Session({}) address={}", (Object)acceptor, (Object)address);
            }
            return new Nio2Session(acceptor, Nio2Acceptor.this.getFactoryManager(), handler, channel);
        }

        @Override
        protected void onFailed(Throwable exc, SocketAddress address) {
            if (Nio2Acceptor.this.channels.containsKey(address) && !Nio2Acceptor.this.disposing.get()) {
                Nio2Acceptor.this.log.warn("Caught " + exc.getClass().getSimpleName() + " while accepting incoming connection from " + address + ": " + exc.getMessage(), exc);
            }
        }
    }
}

