/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html.types.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeHtmls;
import com.google.common.html.types.SafeScript;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeScripts;
import com.google.common.html.types.SafeStyle;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheet;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeStyleSheets;
import com.google.common.html.types.SafeStyles;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.SafeUrls;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.common.html.types.TrustedResourceUrls;
import com.google.common.html.types.UncheckedConversions;

@GwtCompatible
public final class HtmlConversions {
    private HtmlConversions() {
    }

    public static SafeHtml newSafeHtmlForTest(String string) {
        return UncheckedConversions.safeHtmlFromStringKnownToSatisfyTypeContract(string);
    }

    public static SafeHtmlProto newSafeHtmlProtoForTest(String string) {
        return SafeHtmls.toProto(HtmlConversions.newSafeHtmlForTest(string));
    }

    public static SafeScript newSafeScriptForTest(String string) {
        return UncheckedConversions.safeScriptFromStringKnownToSatisfyTypeContract(string);
    }

    public static SafeScriptProto newSafeScriptProtoForTest(String string) {
        return SafeScripts.toProto(HtmlConversions.newSafeScriptForTest(string));
    }

    public static SafeStyle newSafeStyleForTest(String string) {
        return UncheckedConversions.safeStyleFromStringKnownToSatisfyTypeContract(string);
    }

    public static SafeStyleProto newSafeStyleProtoForTest(String string) {
        return SafeStyles.toProto(HtmlConversions.newSafeStyleForTest(string));
    }

    public static SafeStyleSheet newSafeStyleSheetForTest(String string) {
        return UncheckedConversions.safeStyleSheetFromStringKnownToSatisfyTypeContract(string);
    }

    public static SafeStyleSheetProto newSafeStyleSheetProtoForTest(String string) {
        return SafeStyleSheets.toProto(HtmlConversions.newSafeStyleSheetForTest(string));
    }

    public static SafeUrl newSafeUrlForTest(String string) {
        return UncheckedConversions.safeUrlFromStringKnownToSatisfyTypeContract(string);
    }

    public static SafeUrlProto newSafeUrlProtoForTest(String string) {
        return SafeUrls.toProto(HtmlConversions.newSafeUrlForTest(string));
    }

    public static TrustedResourceUrl newTrustedResourceUrlForTest(String string) {
        return UncheckedConversions.trustedResourceUrlFromStringKnownToSatisfyTypeContract(string);
    }

    public static TrustedResourceUrlProto newTrustedResourceUrlProtoForTest(String string) {
        return TrustedResourceUrls.toProto(HtmlConversions.newTrustedResourceUrlForTest(string));
    }
}

