/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common;

import com.google.gerrit.common.EventDispatcher;
import com.google.gerrit.common.EventListener;
import com.google.gerrit.common.UserScopedEventListener;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.events.ChangeEvent;
import com.google.gerrit.server.events.Event;
import com.google.gerrit.server.events.ProjectEvent;
import com.google.gerrit.server.events.RefEvent;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EventBroker
implements EventDispatcher {
    private static final Logger log = LoggerFactory.getLogger(EventBroker.class);
    protected final DynamicSet<UserScopedEventListener> listeners;
    protected final DynamicSet<EventListener> unrestrictedListeners;
    private final PermissionBackend permissionBackend;
    protected final ProjectCache projectCache;
    protected final ChangeNotes.Factory notesFactory;
    protected final Provider<ReviewDb> dbProvider;

    @Inject
    public EventBroker(DynamicSet<UserScopedEventListener> listeners, DynamicSet<EventListener> unrestrictedListeners, PermissionBackend permissionBackend, ProjectCache projectCache, ChangeNotes.Factory notesFactory, Provider<ReviewDb> dbProvider) {
        this.listeners = listeners;
        this.unrestrictedListeners = unrestrictedListeners;
        this.permissionBackend = permissionBackend;
        this.projectCache = projectCache;
        this.notesFactory = notesFactory;
        this.dbProvider = dbProvider;
    }

    @Override
    public void postEvent(Change change, ChangeEvent event) throws OrmException, PermissionBackendException {
        this.fireEvent(change, event);
    }

    @Override
    public void postEvent(Branch.NameKey branchName, RefEvent event) throws PermissionBackendException {
        this.fireEvent(branchName, event);
    }

    @Override
    public void postEvent(Project.NameKey projectName, ProjectEvent event) {
        this.fireEvent(projectName, event);
    }

    @Override
    public void postEvent(Event event) throws OrmException, PermissionBackendException {
        this.fireEvent(event);
    }

    protected void fireEventForUnrestrictedListeners(Event event) {
        for (EventListener listener : this.unrestrictedListeners) {
            listener.onEvent(event);
        }
    }

    protected void fireEvent(Change change, ChangeEvent event) throws OrmException, PermissionBackendException {
        for (UserScopedEventListener listener : this.listeners) {
            if (!this.isVisibleTo(change, listener.getUser())) continue;
            listener.onEvent(event);
        }
        this.fireEventForUnrestrictedListeners(event);
    }

    protected void fireEvent(Project.NameKey project, ProjectEvent event) {
        for (UserScopedEventListener listener : this.listeners) {
            if (!this.isVisibleTo(project, listener.getUser())) continue;
            listener.onEvent(event);
        }
        this.fireEventForUnrestrictedListeners(event);
    }

    protected void fireEvent(Branch.NameKey branchName, RefEvent event) throws PermissionBackendException {
        for (UserScopedEventListener listener : this.listeners) {
            if (!this.isVisibleTo(branchName, listener.getUser())) continue;
            listener.onEvent(event);
        }
        this.fireEventForUnrestrictedListeners(event);
    }

    protected void fireEvent(Event event) throws OrmException, PermissionBackendException {
        for (UserScopedEventListener listener : this.listeners) {
            if (!this.isVisibleTo(event, listener.getUser())) continue;
            listener.onEvent(event);
        }
        this.fireEventForUnrestrictedListeners(event);
    }

    protected boolean isVisibleTo(Project.NameKey project, CurrentUser user) {
        try {
            this.permissionBackend.user(user).project(project).check(ProjectPermission.ACCESS);
            return true;
        }
        catch (AuthException | PermissionBackendException e) {
            return false;
        }
    }

    protected boolean isVisibleTo(Change change, CurrentUser user) throws OrmException, PermissionBackendException {
        if (change == null) {
            return false;
        }
        ProjectState pe = this.projectCache.get(change.getProject());
        if (pe == null) {
            return false;
        }
        ReviewDb db = this.dbProvider.get();
        return ((PermissionBackend.ForChange)this.permissionBackend.user(user).change(this.notesFactory.createChecked(db, change)).database(db)).test(ChangePermission.READ);
    }

    protected boolean isVisibleTo(Branch.NameKey branchName, CurrentUser user) throws PermissionBackendException {
        ProjectState pe = this.projectCache.get(branchName.getParentKey());
        if (pe == null) {
            return false;
        }
        return this.permissionBackend.user(user).ref(branchName).test(RefPermission.READ);
    }

    protected boolean isVisibleTo(Event event, CurrentUser user) throws OrmException, PermissionBackendException {
        if (event instanceof RefEvent) {
            RefEvent refEvent = (RefEvent)event;
            String ref = refEvent.getRefName();
            if (PatchSet.isChangeRef(ref)) {
                Change.Id cid = PatchSet.Id.fromRef(ref).getParentKey();
                try {
                    Change change = this.notesFactory.createChecked(this.dbProvider.get(), refEvent.getProjectNameKey(), cid).getChange();
                    return this.isVisibleTo(change, user);
                }
                catch (NoSuchChangeException e) {
                    log.debug("Change {} cannot be found, falling back on ref visibility check", (Object)cid.id);
                }
            }
            return this.isVisibleTo(refEvent.getBranchNameKey(), user);
        }
        if (event instanceof ProjectEvent) {
            return this.isVisibleTo(((ProjectEvent)event).getProjectNameKey(), user);
        }
        return true;
    }

    public static class Module
    extends LifecycleModule {
        @Override
        protected void configure() {
            DynamicItem.itemOf(this.binder(), EventDispatcher.class);
            DynamicItem.bind(this.binder(), EventDispatcher.class).to(EventBroker.class);
        }
    }
}

