/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.gitweb;

import com.google.gerrit.common.FileUtil;
import com.google.gerrit.httpd.HtmlDomUtil;
import com.google.gerrit.server.config.GitwebCgiConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.gwtjsonrpc.server.RPCServletUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

abstract class GitwebCssServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final long modified;
    private final byte[] raw_css;
    private final byte[] gz_css;

    GitwebCssServlet(Path src) throws IOException {
        if (src != null) {
            String name;
            Path dir = src.getParent();
            String raw = HtmlDomUtil.readFile(dir, name = src.getFileName().toString());
            if (raw != null) {
                this.modified = FileUtil.lastModified(src);
                this.raw_css = raw.getBytes(StandardCharsets.UTF_8);
                this.gz_css = HtmlDomUtil.compress(this.raw_css);
            } else {
                this.modified = -1L;
                this.raw_css = null;
                this.gz_css = null;
            }
        } else {
            this.modified = -1L;
            this.raw_css = null;
            this.gz_css = null;
        }
    }

    @Override
    protected long getLastModified(HttpServletRequest req) {
        return this.modified;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        if (this.raw_css != null) {
            byte[] toSend;
            rsp.setContentType("text/css");
            rsp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            if (RPCServletUtils.acceptsGzipEncoding(req)) {
                rsp.setHeader("Content-Encoding", "gzip");
                toSend = this.gz_css;
            } else {
                toSend = this.raw_css;
            }
            rsp.setContentLength(toSend.length);
            rsp.setDateHeader("Last-Modified", this.modified);
            CacheHeaders.setCacheable(req, rsp, 5L, TimeUnit.MINUTES);
            try (ServletOutputStream os = rsp.getOutputStream();){
                os.write(toSend);
            }
        } else {
            CacheHeaders.setNotCacheable(rsp);
            rsp.sendError(404);
        }
    }

    @Singleton
    static class Default
    extends GitwebCssServlet {
        private static final long serialVersionUID = 1L;

        @Inject
        Default(GitwebCgiConfig gwcc) throws IOException {
            super(gwcc.getGitwebCss());
        }
    }

    @Singleton
    static class Site
    extends GitwebCssServlet {
        private static final long serialVersionUID = 1L;

        @Inject
        Site(SitePaths paths) throws IOException {
            super(paths.site_css);
        }
    }
}

