/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.index;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.gerrit.index.AutoValue_IndexConfig;
import java.util.function.IntConsumer;
import org.eclipse.jgit.lib.Config;

@AutoValue
public abstract class IndexConfig {
    private static final int DEFAULT_MAX_TERMS = 1024;

    public static IndexConfig createDefault() {
        return IndexConfig.builder().build();
    }

    public static Builder fromConfig(Config cfg) {
        Builder b = IndexConfig.builder();
        IndexConfig.setIfPresent(cfg, "maxLimit", b::maxLimit);
        IndexConfig.setIfPresent(cfg, "maxPages", b::maxPages);
        IndexConfig.setIfPresent(cfg, "maxTerms", b::maxTerms);
        return b;
    }

    private static void setIfPresent(Config cfg, String name, IntConsumer setter) {
        int n = cfg.getInt("index", null, name, 0);
        if (n != 0) {
            setter.accept(n);
        }
    }

    public static Builder builder() {
        return new AutoValue_IndexConfig.Builder().maxLimit(Integer.MAX_VALUE).maxPages(Integer.MAX_VALUE).maxTerms(1024).separateChangeSubIndexes(false);
    }

    private static void checkLimit(int limit, String name) {
        Preconditions.checkArgument(limit > 0, "%s must be positive: %s", (Object)name, limit);
    }

    public abstract int maxLimit();

    public abstract int maxPages();

    public abstract int maxTerms();

    public abstract boolean separateChangeSubIndexes();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder maxLimit(int var1);

        abstract int maxLimit();

        public abstract Builder maxPages(int var1);

        abstract int maxPages();

        public abstract Builder maxTerms(int var1);

        abstract int maxTerms();

        public abstract Builder separateChangeSubIndexes(boolean var1);

        abstract IndexConfig autoBuild();

        public IndexConfig build() {
            IndexConfig cfg = this.autoBuild();
            IndexConfig.checkLimit(cfg.maxLimit(), "maxLimit");
            IndexConfig.checkLimit(cfg.maxPages(), "maxPages");
            IndexConfig.checkLimit(cfg.maxTerms(), "maxTerms");
            return cfg;
        }
    }
}

