/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.lucene;

import com.google.gerrit.index.QueryOptions;
import com.google.gerrit.index.Schema;
import com.google.gerrit.index.query.DataSource;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.lucene.AbstractLuceneIndex;
import com.google.gerrit.lucene.GerritIndexWriterConfig;
import com.google.gerrit.lucene.LuceneIndexModule;
import com.google.gerrit.lucene.LuceneVersionManager;
import com.google.gerrit.lucene.QueryBuilder;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.index.IndexUtils;
import com.google.gerrit.server.index.account.AccountField;
import com.google.gerrit.server.index.account.AccountIndex;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneAccountIndex
extends AbstractLuceneIndex<Account.Id, AccountState>
implements AccountIndex {
    private static final Logger log = LoggerFactory.getLogger(LuceneAccountIndex.class);
    private static final String ACCOUNTS = "accounts";
    private static final String ID_SORT_FIELD = LuceneAccountIndex.sortFieldName(AccountField.ID);
    private final GerritIndexWriterConfig indexWriterConfig;
    private final QueryBuilder<AccountState> queryBuilder;
    private final Provider<AccountCache> accountCache;

    private static Term idTerm(AccountState as) {
        return LuceneAccountIndex.idTerm(as.getAccount().getId());
    }

    private static Term idTerm(Account.Id id) {
        return QueryBuilder.intTerm(AccountField.ID.getName(), id.get());
    }

    private static Directory dir(Schema<AccountState> schema, Config cfg, SitePaths sitePaths) throws IOException {
        if (LuceneIndexModule.isInMemoryTest(cfg)) {
            return new RAMDirectory();
        }
        Path indexDir = LuceneVersionManager.getDir(sitePaths, ACCOUNTS, schema);
        return FSDirectory.open(indexDir);
    }

    @Inject
    LuceneAccountIndex(@GerritServerConfig Config cfg, SitePaths sitePaths, Provider<AccountCache> accountCache, @Assisted Schema<AccountState> schema) throws IOException {
        super(schema, sitePaths, LuceneAccountIndex.dir(schema, cfg, sitePaths), ACCOUNTS, null, new GerritIndexWriterConfig(cfg, ACCOUNTS), new SearcherFactory());
        this.accountCache = accountCache;
        this.indexWriterConfig = new GerritIndexWriterConfig(cfg, ACCOUNTS);
        this.queryBuilder = new QueryBuilder<AccountState>(schema, this.indexWriterConfig.getAnalyzer());
    }

    @Override
    public void replace(AccountState as) throws IOException {
        try {
            this.replace(LuceneAccountIndex.idTerm(as), this.toDocument(as)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void delete(Account.Id key) throws IOException {
        try {
            this.delete(LuceneAccountIndex.idTerm(key)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public DataSource<AccountState> getSource(Predicate<AccountState> p, QueryOptions opts) throws QueryParseException {
        return new QuerySource(opts, this.queryBuilder.toQuery(p), new Sort(new SortField(ID_SORT_FIELD, SortField.Type.LONG, true)));
    }

    private AccountState toAccountState(Document doc) {
        Account.Id id = new Account.Id(doc.getField(AccountField.ID.getName()).numericValue().intValue());
        return this.accountCache.get().get(id);
    }

    private class QuerySource
    implements DataSource<AccountState> {
        private final QueryOptions opts;
        private final Query query;
        private final Sort sort;

        private QuerySource(QueryOptions opts, Query query, Sort sort) {
            this.opts = opts;
            this.query = query;
            this.sort = sort;
        }

        @Override
        public int getCardinality() {
            return 10;
        }

        @Override
        public ResultSet<AccountState> read() throws OrmException {
            IndexSearcher searcher = null;
            try {
                searcher = LuceneAccountIndex.this.acquire();
                int realLimit = this.opts.start() + this.opts.limit();
                TopFieldDocs docs = searcher.search(this.query, realLimit, this.sort);
                ArrayList<AccountState> result = new ArrayList<AccountState>(docs.scoreDocs.length);
                for (int i = this.opts.start(); i < docs.scoreDocs.length; ++i) {
                    ScoreDoc sd = docs.scoreDocs[i];
                    Document doc = searcher.doc(sd.doc, IndexUtils.accountFields(this.opts));
                    result.add(LuceneAccountIndex.this.toAccountState(doc));
                }
                final List r = Collections.unmodifiableList(result);
                ResultSet<AccountState> resultSet = new ResultSet<AccountState>(){

                    @Override
                    public Iterator<AccountState> iterator() {
                        return r.iterator();
                    }

                    @Override
                    public List<AccountState> toList() {
                        return r;
                    }

                    @Override
                    public void close() {
                    }
                };
                return resultSet;
            }
            catch (IOException e) {
                throw new OrmException(e);
            }
            finally {
                if (searcher != null) {
                    try {
                        LuceneAccountIndex.this.release(searcher);
                    }
                    catch (IOException e) {
                        log.warn("cannot release Lucene searcher", e);
                    }
                }
            }
        }
    }
}

