/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.extensions.client.AccountFieldName;
import com.google.gerrit.extensions.client.AuthType;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AbstractRealm;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.account.EmailExpander;
import com.google.gerrit.server.account.Emails;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class DefaultRealm
extends AbstractRealm {
    private final EmailExpander emailExpander;
    private final Provider<Emails> emails;
    private final AuthConfig authConfig;

    @Inject
    DefaultRealm(EmailExpander emailExpander, Provider<Emails> emails, AuthConfig authConfig) {
        this.emailExpander = emailExpander;
        this.emails = emails;
        this.authConfig = authConfig;
    }

    @Override
    public boolean allowsEdit(AccountFieldName field) {
        if (this.authConfig.getAuthType() == AuthType.HTTP) {
            switch (field) {
                case USER_NAME: {
                    return false;
                }
                case FULL_NAME: {
                    return Strings.emptyToNull(this.authConfig.getHttpDisplaynameHeader()) == null;
                }
                case REGISTER_NEW_EMAIL: {
                    return this.authConfig.isAllowRegisterNewEmail() && Strings.emptyToNull(this.authConfig.getHttpEmailHeader()) == null;
                }
            }
            return true;
        }
        switch (field) {
            case REGISTER_NEW_EMAIL: {
                return this.authConfig.isAllowRegisterNewEmail();
            }
        }
        return true;
    }

    @Override
    public AuthRequest authenticate(AuthRequest who) {
        if (who.getEmailAddress() == null && who.getLocalUser() != null && this.emailExpander.canExpand(who.getLocalUser())) {
            who.setEmailAddress(this.emailExpander.expand(who.getLocalUser()));
        }
        return who;
    }

    @Override
    public void onCreateAccount(AuthRequest who, Account account) {
    }

    @Override
    public Account.Id lookup(String accountName) throws IOException {
        if (this.emailExpander.canExpand(accountName)) {
            try {
                ImmutableSet<Account.Id> c = this.emails.get().getAccountFor(this.emailExpander.expand(accountName));
                if (1 == c.size()) {
                    return (Account.Id)c.iterator().next();
                }
            }
            catch (OrmException e) {
                throw new IOException("Failed to query accounts by email", e);
            }
        }
        return null;
    }
}

