/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.common.EmailInfo;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.account.AccountResource;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@Singleton
public class GetEmails
implements RestReadView<AccountResource> {
    public List<EmailInfo> apply(AccountResource rsrc) {
        ArrayList<EmailInfo> emails = new ArrayList<EmailInfo>();
        for (String email : rsrc.getUser().getEmailAddresses()) {
            if (email == null) continue;
            EmailInfo e = new EmailInfo();
            e.email = email;
            e.preferred(rsrc.getUser().getAccount().getPreferredEmail());
            emails.add(e);
        }
        Collections.sort(emails, new Comparator<EmailInfo>(){

            @Override
            public int compare(EmailInfo a, EmailInfo b) {
                return a.email.compareTo(b.email);
            }
        });
        return emails;
    }
}

