/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GetSshKeys;
import com.google.gerrit.server.account.VersionedAuthorizedKeys;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class SshKeys
implements ChildCollection<AccountResource, AccountResource.SshKey> {
    private final DynamicMap<RestView<AccountResource.SshKey>> views;
    private final GetSshKeys list;
    private final Provider<CurrentUser> self;
    private final PermissionBackend permissionBackend;
    private final VersionedAuthorizedKeys.Accessor authorizedKeys;

    @Inject
    SshKeys(DynamicMap<RestView<AccountResource.SshKey>> views, GetSshKeys list, Provider<CurrentUser> self, PermissionBackend permissionBackend, VersionedAuthorizedKeys.Accessor authorizedKeys) {
        this.views = views;
        this.list = list;
        this.self = self;
        this.permissionBackend = permissionBackend;
        this.authorizedKeys = authorizedKeys;
    }

    @Override
    public RestView<AccountResource> list() {
        return this.list;
    }

    @Override
    public AccountResource.SshKey parse(AccountResource rsrc, IdString id) throws ResourceNotFoundException, OrmException, IOException, ConfigInvalidException, PermissionBackendException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser())) {
            try {
                this.permissionBackend.user(this.self).check(GlobalPermission.MODIFY_ACCOUNT);
            }
            catch (AuthException e) {
                throw new ResourceNotFoundException();
            }
        }
        return this.parse(rsrc.getUser(), id);
    }

    @Override
    public AccountResource.SshKey parse(IdentifiedUser user, IdString id) throws ResourceNotFoundException, IOException, ConfigInvalidException {
        try {
            int seq = Integer.parseInt(id.get(), 10);
            AccountSshKey sshKey = this.authorizedKeys.getKey(user.getAccountId(), seq);
            if (sshKey == null) {
                throw new ResourceNotFoundException(id);
            }
            return new AccountResource.SshKey(user, sshKey);
        }
        catch (NumberFormatException e) {
            throw new ResourceNotFoundException(id);
        }
    }

    @Override
    public DynamicMap<RestView<AccountResource.SshKey>> views() {
        return this.views;
    }
}

