/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account.externalids;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.HashedPassword;
import com.google.gerrit.server.account.externalids.AutoValue_ExternalId;
import com.google.gerrit.server.account.externalids.AutoValue_ExternalId_Key;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;

@AutoValue
public abstract class ExternalId
implements Serializable {
    private static final String USER_NAME_PATTERN_FIRST_REGEX = "[a-zA-Z0-9]";
    private static final String USER_NAME_PATTERN_REST_REGEX = "[a-zA-Z0-9.!#$%&\u2019*+=?^_`\\{|\\}~@-]";
    private static final String USER_NAME_PATTERN_LAST_REGEX = "[a-zA-Z0-9]";
    private static final String USER_NAME_PATTERN_REGEX = "^([a-zA-Z0-9][a-zA-Z0-9.!#$%&\u2019*+=?^_`\\{|\\}~@-]*[a-zA-Z0-9]|[a-zA-Z0-9])$";
    private static final Pattern USER_NAME_PATTERN = Pattern.compile("^([a-zA-Z0-9][a-zA-Z0-9.!#$%&\u2019*+=?^_`\\{|\\}~@-]*[a-zA-Z0-9]|[a-zA-Z0-9])$");
    private static final long serialVersionUID = 1L;
    private static final String EXTERNAL_ID_SECTION = "externalId";
    private static final String ACCOUNT_ID_KEY = "accountId";
    private static final String EMAIL_KEY = "email";
    private static final String PASSWORD_KEY = "password";
    public static final String SCHEME_GERRIT = "gerrit";
    public static final String SCHEME_UUID = "uuid";
    public static final String SCHEME_MAILTO = "mailto";
    public static final String SCHEME_USERNAME = "username";
    public static final String SCHEME_GPGKEY = "gpgkey";
    public static final String SCHEME_EXTERNAL = "external";

    public static boolean isValidUsername(String username) {
        return USER_NAME_PATTERN.matcher(username).matches();
    }

    public static ExternalId create(String scheme, String id, Account.Id accountId) {
        return ExternalId.create(Key.create(scheme, id), accountId, null, null);
    }

    public static ExternalId create(String scheme, String id, Account.Id accountId, @Nullable String email, @Nullable String hashedPassword) {
        return ExternalId.create(Key.create(scheme, id), accountId, email, hashedPassword);
    }

    public static ExternalId create(Key key, Account.Id accountId) {
        return ExternalId.create(key, accountId, null, null);
    }

    public static ExternalId create(Key key, Account.Id accountId, @Nullable String email, @Nullable String hashedPassword) {
        return ExternalId.create(key, accountId, Strings.emptyToNull(email), Strings.emptyToNull(hashedPassword), null);
    }

    public static ExternalId createWithPassword(Key key, Account.Id accountId, @Nullable String email, String plainPassword) {
        String hashedPassword = (plainPassword = Strings.emptyToNull(plainPassword)) != null ? HashedPassword.fromPassword(plainPassword).encode() : null;
        return ExternalId.create(key, accountId, email, hashedPassword);
    }

    public static ExternalId createUsername(String id, Account.Id accountId, String plainPassword) {
        return ExternalId.createWithPassword(Key.create(SCHEME_USERNAME, id), accountId, null, plainPassword);
    }

    public static ExternalId createWithEmail(String scheme, String id, Account.Id accountId, @Nullable String email) {
        return ExternalId.createWithEmail(Key.create(scheme, id), accountId, email);
    }

    public static ExternalId createWithEmail(Key key, Account.Id accountId, @Nullable String email) {
        return ExternalId.create(key, accountId, Strings.emptyToNull(email), null);
    }

    public static ExternalId createEmail(Account.Id accountId, String email) {
        return ExternalId.createWithEmail(SCHEME_MAILTO, email, accountId, Preconditions.checkNotNull(email));
    }

    static ExternalId create(ExternalId extId, @Nullable ObjectId blobId) {
        return new AutoValue_ExternalId(extId.key(), extId.accountId(), extId.email(), extId.password(), blobId);
    }

    @VisibleForTesting
    public static ExternalId create(Key key, Account.Id accountId, @Nullable String email, @Nullable String hashedPassword, @Nullable ObjectId blobId) {
        return new AutoValue_ExternalId(key, accountId, Strings.emptyToNull(email), Strings.emptyToNull(hashedPassword), blobId);
    }

    public static ExternalId parse(String noteId, byte[] raw, ObjectId blobId) throws ConfigInvalidException {
        Preconditions.checkNotNull(blobId);
        Config externalIdConfig = new Config();
        try {
            externalIdConfig.fromText(new String(raw, StandardCharsets.UTF_8));
        }
        catch (ConfigInvalidException e) {
            throw ExternalId.invalidConfig(noteId, e.getMessage());
        }
        Set<String> externalIdKeys = externalIdConfig.getSubsections(EXTERNAL_ID_SECTION);
        if (externalIdKeys.size() != 1) {
            throw ExternalId.invalidConfig(noteId, String.format("Expected exactly 1 '%s' section, found %d", EXTERNAL_ID_SECTION, externalIdKeys.size()));
        }
        String externalIdKeyStr = Iterables.getOnlyElement(externalIdKeys);
        Key externalIdKey = Key.parse(externalIdKeyStr);
        if (externalIdKey == null) {
            throw ExternalId.invalidConfig(noteId, String.format("External ID %s is invalid", externalIdKeyStr));
        }
        if (!externalIdKey.sha1().getName().equals(noteId)) {
            throw ExternalId.invalidConfig(noteId, String.format("SHA1 of external ID '%s' does not match note ID '%s'", externalIdKeyStr, noteId));
        }
        String email = externalIdConfig.getString(EXTERNAL_ID_SECTION, externalIdKeyStr, EMAIL_KEY);
        String password = externalIdConfig.getString(EXTERNAL_ID_SECTION, externalIdKeyStr, PASSWORD_KEY);
        int accountId = ExternalId.readAccountId(noteId, externalIdConfig, externalIdKeyStr);
        return ExternalId.create(externalIdKey, new Account.Id(accountId), Strings.emptyToNull(email), Strings.emptyToNull(password), blobId);
    }

    private static int readAccountId(String noteId, Config externalIdConfig, String externalIdKeyStr) throws ConfigInvalidException {
        String accountIdStr = externalIdConfig.getString(EXTERNAL_ID_SECTION, externalIdKeyStr, ACCOUNT_ID_KEY);
        if (accountIdStr == null) {
            throw ExternalId.invalidConfig(noteId, String.format("Value for '%s.%s.%s' is missing, expected account ID", EXTERNAL_ID_SECTION, externalIdKeyStr, ACCOUNT_ID_KEY));
        }
        try {
            int accountId = externalIdConfig.getInt(EXTERNAL_ID_SECTION, externalIdKeyStr, ACCOUNT_ID_KEY, -1);
            if (accountId < 0) {
                throw ExternalId.invalidConfig(noteId, String.format("Value %s for '%s.%s.%s' is invalid, expected account ID", accountIdStr, EXTERNAL_ID_SECTION, externalIdKeyStr, ACCOUNT_ID_KEY));
            }
            return accountId;
        }
        catch (IllegalArgumentException e) {
            throw ExternalId.invalidConfig(noteId, String.format("Value %s for '%s.%s.%s' is invalid, expected account ID", accountIdStr, EXTERNAL_ID_SECTION, externalIdKeyStr, ACCOUNT_ID_KEY));
        }
    }

    private static ConfigInvalidException invalidConfig(String noteId, String message) {
        return new ConfigInvalidException(String.format("Invalid external ID config for note '%s': %s", noteId, message));
    }

    public abstract Key key();

    public abstract Account.Id accountId();

    @Nullable
    public abstract String email();

    @Nullable
    public abstract String password();

    @Nullable
    public abstract ObjectId blobId();

    public void checkThatBlobIdIsSet() {
        Preconditions.checkState(this.blobId() != null, "No blob ID set for external ID %s", (Object)this.key().get());
    }

    public boolean isScheme(String scheme) {
        return this.key().isScheme(scheme);
    }

    public byte[] toByteArray() {
        Preconditions.checkState(this.blobId() != null, "Missing blobId in external ID %s", (Object)this.key().get());
        byte[] b = new byte[81];
        this.key().sha1().copyTo(b, 0);
        b[40] = 58;
        this.blobId().copyTo(b, 41);
        return b;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExternalId)) {
            return false;
        }
        ExternalId o = (ExternalId)obj;
        return Objects.equals(this.key(), o.key()) && Objects.equals(this.accountId(), o.accountId()) && Objects.equals(this.email(), o.email()) && Objects.equals(this.password(), o.password());
    }

    public int hashCode() {
        return Objects.hash(this.key(), this.accountId(), this.email(), this.password());
    }

    public String toString() {
        Config c = new Config();
        this.writeToConfig(c);
        return c.toText();
    }

    public void writeToConfig(Config c) {
        String externalIdKey = this.key().get();
        c.setString(EXTERNAL_ID_SECTION, externalIdKey, ACCOUNT_ID_KEY, Integer.toString(this.accountId().get()));
        if (this.email() != null) {
            c.setString(EXTERNAL_ID_SECTION, externalIdKey, EMAIL_KEY, this.email());
        } else {
            c.unset(EXTERNAL_ID_SECTION, externalIdKey, EMAIL_KEY);
        }
        if (this.password() != null) {
            c.setString(EXTERNAL_ID_SECTION, externalIdKey, PASSWORD_KEY, this.password());
        } else {
            c.unset(EXTERNAL_ID_SECTION, externalIdKey, PASSWORD_KEY);
        }
    }

    @AutoValue
    public static abstract class Key
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public static Key create(@Nullable String scheme, String id) {
            return new AutoValue_ExternalId_Key(Strings.emptyToNull(scheme), id);
        }

        public static Key parse(String externalId) {
            int c = externalId.indexOf(58);
            if (c < 1 || c >= externalId.length() - 1) {
                return Key.create(null, externalId);
            }
            return Key.create(externalId.substring(0, c), externalId.substring(c + 1));
        }

        @Nullable
        public abstract String scheme();

        public abstract String id();

        public boolean isScheme(String scheme) {
            return scheme.equals(this.scheme());
        }

        public ObjectId sha1() {
            return ObjectId.fromRaw(Hashing.sha1().hashString(this.get(), StandardCharsets.UTF_8).asBytes());
        }

        public String get() {
            if (this.scheme() != null) {
                return this.scheme() + ":" + this.id();
            }
            return this.id();
        }

        public String toString() {
            return this.get();
        }
    }
}

