/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account.externalids;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.externalids.ExternalId;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.lib.ObjectId;

interface ExternalIdCache {
    public void onCreate(ObjectId var1, ObjectId var2, Collection<ExternalId> var3) throws IOException;

    public void onUpdate(ObjectId var1, ObjectId var2, Collection<ExternalId> var3) throws IOException;

    public void onReplace(ObjectId var1, ObjectId var2, Account.Id var3, Collection<ExternalId> var4, Collection<ExternalId> var5) throws IOException;

    public void onReplace(ObjectId var1, ObjectId var2, Collection<ExternalId> var3, Collection<ExternalId> var4) throws IOException;

    public void onRemove(ObjectId var1, ObjectId var2, Collection<ExternalId> var3) throws IOException;

    public ImmutableSet<ExternalId> byAccount(Account.Id var1) throws IOException;

    public ImmutableSetMultimap<Account.Id, ExternalId> allByAccount() throws IOException;

    public ImmutableSetMultimap<String, ExternalId> byEmails(String ... var1) throws IOException;

    public ImmutableSetMultimap<String, ExternalId> allByEmail() throws IOException;

    default public ImmutableSet<ExternalId> byEmail(String email) throws IOException {
        return this.byEmails(email).get((Object)email);
    }

    default public void onCreate(ObjectId oldNotesRev, ObjectId newNotesRev, ExternalId extId) throws IOException {
        this.onCreate(oldNotesRev, newNotesRev, Collections.singleton(extId));
    }

    default public void onRemove(ObjectId oldNotesRev, ObjectId newNotesRev, ExternalId extId) throws IOException {
        this.onRemove(oldNotesRev, newNotesRev, Collections.singleton(extId));
    }

    default public void onUpdate(ObjectId oldNotesRev, ObjectId newNotesRev, ExternalId updatedExtId) throws IOException {
        this.onUpdate(oldNotesRev, newNotesRev, Collections.singleton(updatedExtId));
    }
}

