/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.common.data.SubmitTypeRecord;
import com.google.gerrit.extensions.api.changes.FixInput;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.client.ReviewerState;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ApprovalInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.ChangeMessageInfo;
import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.common.FetchInfo;
import com.google.gerrit.extensions.common.LabelInfo;
import com.google.gerrit.extensions.common.ProblemInfo;
import com.google.gerrit.extensions.common.PushCertificateInfo;
import com.google.gerrit.extensions.common.ReviewerUpdateInfo;
import com.google.gerrit.extensions.common.RevisionInfo;
import com.google.gerrit.extensions.common.TrackingIdInfo;
import com.google.gerrit.extensions.common.VotingRangeInfo;
import com.google.gerrit.extensions.common.WebLinkInfo;
import com.google.gerrit.extensions.config.DownloadCommand;
import com.google.gerrit.extensions.config.DownloadScheme;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.index.query.QueryResult;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.CommonConverters;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.GpgException;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.ReviewerByEmailSet;
import com.google.gerrit.server.ReviewerSet;
import com.google.gerrit.server.ReviewerStatusUpdate;
import com.google.gerrit.server.WebLinks;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.api.accounts.AccountInfoComparator;
import com.google.gerrit.server.api.accounts.GpgApiAdapter;
import com.google.gerrit.server.change.ActionJson;
import com.google.gerrit.server.change.AutoValue_ChangeJson_LabelWithStatus;
import com.google.gerrit.server.change.ChangeKindCache;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.ConsistencyChecker;
import com.google.gerrit.server.change.FileInfoJson;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.config.TrackingFooters;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.index.change.ChangeIndex;
import com.google.gerrit.server.index.change.ChangeIndexCollection;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.LabelPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.RemoveReviewerControl;
import com.google.gerrit.server.project.SubmitRuleOptions;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.PluginDefinedAttributesFactory;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeJson {
    private static final Logger log = LoggerFactory.getLogger(ChangeJson.class);
    public static final SubmitRuleOptions SUBMIT_RULE_OPTIONS_LENIENT = ChangeField.SUBMIT_RULE_OPTIONS_LENIENT.toBuilder().fastEvalLabels(true).build();
    public static final SubmitRuleOptions SUBMIT_RULE_OPTIONS_STRICT = ChangeField.SUBMIT_RULE_OPTIONS_STRICT.toBuilder().fastEvalLabels(true).build();
    public static final ImmutableSet<ListChangesOption> REQUIRE_LAZY_LOAD = ImmutableSet.of(ListChangesOption.ALL_COMMITS, ListChangesOption.ALL_REVISIONS, ListChangesOption.CHANGE_ACTIONS, ListChangesOption.CHECK, ListChangesOption.COMMIT_FOOTERS, ListChangesOption.CURRENT_ACTIONS, new ListChangesOption[]{ListChangesOption.CURRENT_COMMIT, ListChangesOption.MESSAGES});
    private final Provider<ReviewDb> db;
    private final Provider<CurrentUser> userProvider;
    private final AnonymousUser anonymous;
    private final PermissionBackend permissionBackend;
    private final GitRepositoryManager repoManager;
    private final ProjectCache projectCache;
    private final MergeUtil.Factory mergeUtilFactory;
    private final IdentifiedUser.GenericFactory userFactory;
    private final ChangeData.Factory changeDataFactory;
    private final FileInfoJson fileInfoJson;
    private final AccountLoader.Factory accountLoaderFactory;
    private final DynamicMap<DownloadScheme> downloadSchemes;
    private final DynamicMap<DownloadCommand> downloadCommands;
    private final WebLinks webLinks;
    private final ImmutableSet<ListChangesOption> options;
    private final ChangeMessagesUtil cmUtil;
    private final Provider<ConsistencyChecker> checkerProvider;
    private final ActionJson actionJson;
    private final GpgApiAdapter gpgApi;
    private final ChangeNotes.Factory notesFactory;
    private final ChangeResource.Factory changeResourceFactory;
    private final ChangeKindCache changeKindCache;
    private final ChangeIndexCollection indexes;
    private final ApprovalsUtil approvalsUtil;
    private final RemoveReviewerControl removeReviewerControl;
    private final TrackingFooters trackingFooters;
    private boolean lazyLoad = true;
    private AccountLoader accountLoader;
    private FixInput fix;
    private PluginDefinedAttributesFactory pluginDefinedAttributesFactory;

    @Inject
    ChangeJson(Provider<ReviewDb> db, Provider<CurrentUser> user, AnonymousUser au, PermissionBackend permissionBackend, GitRepositoryManager repoManager, ProjectCache projectCache, MergeUtil.Factory mergeUtilFactory, IdentifiedUser.GenericFactory uf, ChangeData.Factory cdf, FileInfoJson fileInfoJson, AccountLoader.Factory ailf, DynamicMap<DownloadScheme> downloadSchemes, DynamicMap<DownloadCommand> downloadCommands, WebLinks webLinks, ChangeMessagesUtil cmUtil, Provider<ConsistencyChecker> checkerProvider, ActionJson actionJson, GpgApiAdapter gpgApi, ChangeNotes.Factory notesFactory, ChangeResource.Factory changeResourceFactory, ChangeKindCache changeKindCache, ChangeIndexCollection indexes, ApprovalsUtil approvalsUtil, RemoveReviewerControl removeReviewerControl, TrackingFooters trackingFooters, @Assisted Iterable<ListChangesOption> options) {
        this.db = db;
        this.userProvider = user;
        this.anonymous = au;
        this.changeDataFactory = cdf;
        this.permissionBackend = permissionBackend;
        this.repoManager = repoManager;
        this.userFactory = uf;
        this.projectCache = projectCache;
        this.mergeUtilFactory = mergeUtilFactory;
        this.fileInfoJson = fileInfoJson;
        this.accountLoaderFactory = ailf;
        this.downloadSchemes = downloadSchemes;
        this.downloadCommands = downloadCommands;
        this.webLinks = webLinks;
        this.cmUtil = cmUtil;
        this.checkerProvider = checkerProvider;
        this.actionJson = actionJson;
        this.gpgApi = gpgApi;
        this.notesFactory = notesFactory;
        this.changeResourceFactory = changeResourceFactory;
        this.changeKindCache = changeKindCache;
        this.indexes = indexes;
        this.approvalsUtil = approvalsUtil;
        this.removeReviewerControl = removeReviewerControl;
        this.options = Sets.immutableEnumSet(options);
        this.trackingFooters = trackingFooters;
    }

    public ChangeJson lazyLoad(boolean load) {
        this.lazyLoad = load;
        return this;
    }

    public ChangeJson fix(FixInput fix) {
        this.fix = fix;
        return this;
    }

    public void setPluginDefinedAttributesFactory(PluginDefinedAttributesFactory pluginsFactory) {
        this.pluginDefinedAttributesFactory = pluginsFactory;
    }

    public ChangeInfo format(ChangeResource rsrc) throws OrmException {
        return this.format(this.changeDataFactory.create(this.db.get(), rsrc.getNotes()));
    }

    public ChangeInfo format(Change change) throws OrmException {
        return this.format(this.changeDataFactory.create(this.db.get(), change));
    }

    public ChangeInfo format(Project.NameKey project, Change.Id id) throws OrmException {
        ChangeNotes notes;
        try {
            notes = this.notesFactory.createChecked(this.db.get(), project, id);
        }
        catch (OrmException e) {
            if (!this.has(ListChangesOption.CHECK)) {
                throw e;
            }
            return this.checkOnly(this.changeDataFactory.create(this.db.get(), project, id));
        }
        return this.format(this.changeDataFactory.create(this.db.get(), notes));
    }

    public ChangeInfo format(ChangeData cd) throws OrmException {
        return this.format(cd, Optional.empty(), true);
    }

    private ChangeInfo format(ChangeData cd, Optional<PatchSet.Id> limitToPsId, boolean fillAccountLoader) throws OrmException {
        try {
            if (fillAccountLoader) {
                this.accountLoader = this.accountLoaderFactory.create(this.has(ListChangesOption.DETAILED_ACCOUNTS));
                ChangeInfo res = this.toChangeInfo(cd, limitToPsId);
                this.accountLoader.fill();
                return res;
            }
            return this.toChangeInfo(cd, limitToPsId);
        }
        catch (GpgException | PatchListNotAvailableException | PermissionBackendException | NoSuchProjectException | OrmException | IOException | RuntimeException e) {
            if (!this.has(ListChangesOption.CHECK)) {
                Throwables.throwIfInstanceOf(e, OrmException.class);
                throw new OrmException(e);
            }
            return this.checkOnly(cd);
        }
    }

    public ChangeInfo format(RevisionResource rsrc) throws OrmException {
        ChangeData cd = this.changeDataFactory.create(this.db.get(), rsrc.getNotes());
        return this.format(cd, Optional.of(rsrc.getPatchSet().getId()), true);
    }

    public List<List<ChangeInfo>> formatQueryResults(List<QueryResult<ChangeData>> in) throws OrmException {
        this.accountLoader = this.accountLoaderFactory.create(this.has(ListChangesOption.DETAILED_ACCOUNTS));
        this.ensureLoaded(FluentIterable.from(in).transformAndConcat(QueryResult::entities));
        ArrayList<List<ChangeInfo>> res = Lists.newArrayListWithCapacity(in.size());
        HashMap<Change.Id, ChangeInfo> out = new HashMap<Change.Id, ChangeInfo>();
        for (QueryResult<ChangeData> r : in) {
            List<ChangeInfo> infos = this.toChangeInfo(out, r.entities());
            if (!infos.isEmpty() && r.more()) {
                infos.get((int)(infos.size() - 1))._moreChanges = true;
            }
            res.add(infos);
        }
        this.accountLoader.fill();
        return res;
    }

    public List<ChangeInfo> formatChangeDatas(Collection<ChangeData> in) throws OrmException {
        this.accountLoader = this.accountLoaderFactory.create(this.has(ListChangesOption.DETAILED_ACCOUNTS));
        this.ensureLoaded(in);
        ArrayList<ChangeInfo> out = new ArrayList<ChangeInfo>(in.size());
        for (ChangeData cd : in) {
            out.add(this.format(cd));
        }
        this.accountLoader.fill();
        return out;
    }

    private void ensureLoaded(Iterable<ChangeData> all) throws OrmException {
        if (this.lazyLoad) {
            ChangeData.ensureChangeLoaded(all);
            if (this.has(ListChangesOption.ALL_REVISIONS)) {
                ChangeData.ensureAllPatchSetsLoaded(all);
            } else if (this.has(ListChangesOption.CURRENT_REVISION) || this.has(ListChangesOption.MESSAGES)) {
                ChangeData.ensureCurrentPatchSetLoaded(all);
            }
            if (this.has(ListChangesOption.REVIEWED) && this.userProvider.get().isIdentifiedUser()) {
                ChangeData.ensureReviewedByLoadedForOpenChanges(all);
            }
            ChangeData.ensureCurrentApprovalsLoaded(all);
        } else {
            for (ChangeData cd : all) {
                cd.setLazyLoad(false);
            }
        }
    }

    private boolean has(ListChangesOption option) {
        return this.options.contains((Object)option);
    }

    private List<ChangeInfo> toChangeInfo(Map<Change.Id, ChangeInfo> out, List<ChangeData> changes) {
        ArrayList<ChangeInfo> info = Lists.newArrayListWithCapacity(changes.size());
        for (ChangeData cd : changes) {
            ChangeInfo i = out.get(cd.getId());
            if (i == null) {
                try {
                    i = this.toChangeInfo(cd, Optional.empty());
                }
                catch (GpgException | PatchListNotAvailableException | PermissionBackendException | NoSuchProjectException | OrmException | IOException | RuntimeException e) {
                    if (this.has(ListChangesOption.CHECK)) {
                        i = this.checkOnly(cd);
                    }
                    if (e instanceof NoSuchChangeException) {
                        log.info("NoSuchChangeException: Omitting corrupt change " + cd.getId() + " from results. Seems to be stale in the index.");
                        continue;
                    }
                    log.warn("Omitting corrupt change " + cd.getId() + " from results", e);
                    continue;
                }
                out.put(cd.getId(), i);
            }
            info.add(i);
        }
        return info;
    }

    private ChangeInfo checkOnly(ChangeData cd) {
        ChangeInfo info;
        ChangeNotes notes;
        try {
            notes = cd.notes();
        }
        catch (OrmException e) {
            String msg = "Error loading change";
            log.warn(msg + " " + cd.getId(), e);
            ChangeInfo info2 = new ChangeInfo();
            info2._number = cd.getId().get();
            ProblemInfo p = new ProblemInfo();
            p.message = msg;
            info2.problems = Lists.newArrayList(p);
            return info2;
        }
        ConsistencyChecker.Result result = this.checkerProvider.get().check(notes, this.fix);
        Change c = result.change();
        if (c != null) {
            info = new ChangeInfo();
            info.project = c.getProject().get();
            info.branch = c.getDest().getShortName();
            info.topic = c.getTopic();
            info.changeId = c.getKey().get();
            info.subject = c.getSubject();
            info.status = c.getStatus().asChangeStatus();
            info.owner = new AccountInfo(c.getOwner().get());
            info.created = c.getCreatedOn();
            info.updated = c.getLastUpdatedOn();
            info._number = c.getId().get();
            info.problems = result.problems();
            info.isPrivate = c.isPrivate() ? Boolean.valueOf(true) : null;
            info.workInProgress = c.isWorkInProgress() ? Boolean.valueOf(true) : null;
            info.hasReviewStarted = c.hasReviewStarted();
            ChangeJson.finish(info);
        } else {
            info = new ChangeInfo();
            info._number = result.id().get();
            info.problems = result.problems();
        }
        return info;
    }

    private ChangeInfo toChangeInfo(ChangeData cd, Optional<PatchSet.Id> limitToPsId) throws PatchListNotAvailableException, GpgException, OrmException, IOException, PermissionBackendException, NoSuchProjectException {
        Optional<ChangeData.ChangedLines> changedLines;
        ChangeInfo out = new ChangeInfo();
        CurrentUser user = this.userProvider.get();
        if (this.has(ListChangesOption.CHECK)) {
            out.problems = this.checkerProvider.get().check(cd.notes(), this.fix).problems();
            for (ProblemInfo p : out.problems) {
                if (p.status != ProblemInfo.Status.FIXED) continue;
                cd = this.changeDataFactory.create(cd.db(), cd.project(), cd.getId());
                break;
            }
        }
        PermissionBackend.ForChange perm = this.permissionBackendForChange(user, cd);
        Change in = cd.change();
        out.project = in.getProject().get();
        out.branch = in.getDest().getShortName();
        out.topic = in.getTopic();
        if (((ChangeIndex)this.indexes.getSearchIndex()).getSchema().hasField(ChangeField.ASSIGNEE) && in.getAssignee() != null) {
            out.assignee = this.accountLoader.get(in.getAssignee());
        }
        out.hashtags = cd.hashtags();
        out.changeId = in.getKey().get();
        if (in.getStatus().isOpen()) {
            SubmitTypeRecord str = cd.submitTypeRecord();
            if (str.isOk()) {
                out.submitType = str.type;
            }
            out.mergeable = cd.isMergeable();
            if (this.has(ListChangesOption.SUBMITTABLE)) {
                out.submittable = this.submittable(cd);
            }
        }
        if ((changedLines = cd.changedLines()).isPresent()) {
            out.insertions = changedLines.get().insertions;
            out.deletions = changedLines.get().deletions;
        }
        out.isPrivate = in.isPrivate() ? Boolean.valueOf(true) : null;
        out.workInProgress = in.isWorkInProgress() ? Boolean.valueOf(true) : null;
        out.hasReviewStarted = in.hasReviewStarted();
        out.subject = in.getSubject();
        out.status = in.getStatus().asChangeStatus();
        out.owner = this.accountLoader.get(in.getOwner());
        out.created = in.getCreatedOn();
        out.updated = in.getLastUpdatedOn();
        out._number = in.getId().get();
        out.unresolvedCommentCount = cd.unresolvedCommentCount();
        if (user.isIdentifiedUser()) {
            Set<String> stars = cd.stars(user.getAccountId());
            Boolean bl = out.starred = stars.contains("star") ? Boolean.valueOf(true) : null;
            if (!stars.isEmpty()) {
                out.stars = stars;
            }
        }
        if (in.getStatus().isOpen() && this.has(ListChangesOption.REVIEWED) && user.isIdentifiedUser()) {
            out.reviewed = cd.isReviewedBy(user.getAccountId()) ? Boolean.valueOf(true) : null;
        }
        out.labels = this.labelsFor(perm, cd, this.has(ListChangesOption.LABELS), this.has(ListChangesOption.DETAILED_LABELS));
        if (out.labels != null && this.has(ListChangesOption.DETAILED_LABELS)) {
            if (user.isIdentifiedUser() && (!limitToPsId.isPresent() || limitToPsId.get().equals(in.currentPatchSetId()))) {
                out.permittedLabels = cd.change().getStatus() != Change.Status.ABANDONED ? this.permittedLabels(perm, cd) : ImmutableMap.of();
            }
            out.reviewers = this.reviewerMap(cd.reviewers(), cd.reviewersByEmail(), false);
            out.pendingReviewers = this.reviewerMap(cd.pendingReviewers(), cd.pendingReviewersByEmail(), true);
            out.removableReviewers = this.removableReviewers(cd, out);
        }
        this.setSubmitter(cd, out);
        out.plugins = this.pluginDefinedAttributesFactory != null ? this.pluginDefinedAttributesFactory.create(cd) : null;
        Integer n = out.revertOf = cd.change().getRevertOf() != null ? Integer.valueOf(cd.change().getRevertOf().get()) : null;
        if (this.has(ListChangesOption.REVIEWER_UPDATES)) {
            out.reviewerUpdates = this.reviewerUpdates(cd);
        }
        boolean needMessages = this.has(ListChangesOption.MESSAGES);
        boolean needRevisions = this.has(ListChangesOption.ALL_REVISIONS) || this.has(ListChangesOption.CURRENT_REVISION) || limitToPsId.isPresent();
        Map<PatchSet.Id, PatchSet> src = needMessages || needRevisions ? this.loadPatchSets(cd, limitToPsId) : null;
        if (needMessages) {
            out.messages = this.messages(cd);
        }
        ChangeJson.finish(out);
        if (needRevisions) {
            out.revisions = this.revisions(cd, src, limitToPsId, out);
            if (out.revisions != null) {
                for (Map.Entry<String, RevisionInfo> entry : out.revisions.entrySet()) {
                    if (!entry.getValue().isCurrent) continue;
                    out.currentRevision = entry.getKey();
                    break;
                }
            }
        }
        if (this.has(ListChangesOption.CURRENT_ACTIONS) || this.has(ListChangesOption.CHANGE_ACTIONS)) {
            this.actionJson.addChangeActions(out, cd.notes());
        }
        if (this.has(ListChangesOption.TRACKING_IDS)) {
            ListMultimap<String, String> set = this.trackingFooters.extract(cd.commitFooters());
            out.trackingIds = set.entries().stream().map(e -> new TrackingIdInfo((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }
        return out;
    }

    private Map<ReviewerState, Collection<AccountInfo>> reviewerMap(ReviewerSet reviewers, ReviewerByEmailSet reviewersByEmail, boolean includeRemoved) {
        HashMap<ReviewerState, Collection<AccountInfo>> reviewerMap = new HashMap<ReviewerState, Collection<AccountInfo>>();
        for (ReviewerStateInternal state : ReviewerStateInternal.values()) {
            if (!includeRemoved && state == ReviewerStateInternal.REMOVED) continue;
            Collection<AccountInfo> reviewersByState = this.toAccountInfo(reviewers.byState(state));
            reviewersByState.addAll(this.toAccountInfoByEmail(reviewersByEmail.byState(state)));
            if (reviewersByState.isEmpty()) continue;
            reviewerMap.put(state.asReviewerState(), reviewersByState);
        }
        return reviewerMap;
    }

    private Collection<ReviewerUpdateInfo> reviewerUpdates(ChangeData cd) throws OrmException {
        List<ReviewerStatusUpdate> reviewerUpdates = cd.reviewerUpdates();
        ArrayList<ReviewerUpdateInfo> result = new ArrayList<ReviewerUpdateInfo>(reviewerUpdates.size());
        for (ReviewerStatusUpdate c : reviewerUpdates) {
            ReviewerUpdateInfo change = new ReviewerUpdateInfo();
            change.updated = c.date();
            change.state = c.state().asReviewerState();
            change.updatedBy = this.accountLoader.get(c.updatedBy());
            change.reviewer = this.accountLoader.get(c.reviewer());
            result.add(change);
        }
        return result;
    }

    private boolean submittable(ChangeData cd) throws OrmException {
        return SubmitRecord.findOkRecord(cd.submitRecords(SUBMIT_RULE_OPTIONS_STRICT)).isPresent();
    }

    private List<SubmitRecord> submitRecords(ChangeData cd) throws OrmException {
        return cd.submitRecords(SUBMIT_RULE_OPTIONS_LENIENT);
    }

    private Map<String, LabelInfo> labelsFor(PermissionBackend.ForChange perm, ChangeData cd, boolean standard, boolean detailed) throws OrmException, PermissionBackendException {
        if (!standard && !detailed) {
            return null;
        }
        LabelTypes labelTypes = cd.getLabelTypes();
        Map<String, LabelWithStatus> withStatus = cd.change().getStatus() == Change.Status.MERGED ? this.labelsForSubmittedChange(perm, cd, labelTypes, standard, detailed) : this.labelsForUnsubmittedChange(perm, cd, labelTypes, standard, detailed);
        return ImmutableMap.copyOf(Maps.transformValues(withStatus, LabelWithStatus::label));
    }

    private Map<String, LabelWithStatus> labelsForUnsubmittedChange(PermissionBackend.ForChange perm, ChangeData cd, LabelTypes labelTypes, boolean standard, boolean detailed) throws OrmException, PermissionBackendException {
        Map<String, LabelWithStatus> labels = this.initLabels(cd, labelTypes, standard);
        if (detailed) {
            this.setAllApprovals(perm, cd, labels);
        }
        for (Map.Entry<String, LabelWithStatus> e : labels.entrySet()) {
            LabelType type = labelTypes.byLabel(e.getKey());
            if (type == null) continue;
            if (standard) {
                for (PatchSetApproval psa : cd.currentApprovals()) {
                    if (!type.matches(psa)) continue;
                    short val = psa.getValue();
                    Account.Id accountId = psa.getAccountId();
                    this.setLabelScores(type, e.getValue(), val, accountId);
                }
            }
            if (!detailed) continue;
            this.setLabelValues(type, e.getValue());
        }
        return labels;
    }

    private Map<String, LabelWithStatus> initLabels(ChangeData cd, LabelTypes labelTypes, boolean standard) throws OrmException {
        TreeMap<String, LabelWithStatus> labels = new TreeMap<String, LabelWithStatus>(labelTypes.nameComparator());
        for (SubmitRecord rec : this.submitRecords(cd)) {
            if (rec.labels == null) continue;
            for (SubmitRecord.Label r : rec.labels) {
                LabelWithStatus p = (LabelWithStatus)labels.get(r.label);
                if (p != null && p.status().compareTo(r.status) >= 0) continue;
                LabelInfo n = new LabelInfo();
                if (standard) {
                    switch (r.status) {
                        case OK: {
                            n.approved = this.accountLoader.get(r.appliedBy);
                            break;
                        }
                        case REJECT: {
                            n.rejected = this.accountLoader.get(r.appliedBy);
                            n.blocking = true;
                            break;
                        }
                    }
                }
                n.optional = r.status == SubmitRecord.Label.Status.MAY ? Boolean.valueOf(true) : null;
                labels.put(r.label, LabelWithStatus.create(n, r.status));
            }
        }
        return labels;
    }

    private void setLabelScores(LabelType type, LabelWithStatus l, short score, Account.Id accountId) {
        if (l.label().approved != null || l.label().rejected != null) {
            return;
        }
        if (type.getMin() == null || type.getMax() == null) {
            return;
        }
        if (score != 0) {
            if (score == type.getMin().getValue()) {
                l.label().rejected = this.accountLoader.get(accountId);
            } else if (score == type.getMax().getValue()) {
                l.label().approved = this.accountLoader.get(accountId);
            } else if (score < 0) {
                l.label().disliked = this.accountLoader.get(accountId);
                l.label().value = score;
            } else if (score > 0 && l.label().disliked == null) {
                l.label().recommended = this.accountLoader.get(accountId);
                l.label().value = score;
            }
        }
    }

    private void setAllApprovals(PermissionBackend.ForChange basePerm, ChangeData cd, Map<String, LabelWithStatus> labels) throws OrmException, PermissionBackendException {
        Change.Status status = cd.change().getStatus();
        Preconditions.checkState(status != Change.Status.MERGED, "should not call setAllApprovals on %s change", (Object)status);
        HashSet<Account.Id> allUsers = new HashSet<Account.Id>();
        allUsers.addAll(cd.reviewers().byState(ReviewerStateInternal.REVIEWER));
        for (Object psa : cd.approvals().values()) {
            allUsers.add(((PatchSetApproval)psa).getAccountId());
        }
        HashBasedTable<Account.Id, String, PatchSetApproval> current = HashBasedTable.create(allUsers.size(), cd.getLabelTypes().getLabelTypes().size());
        for (PatchSetApproval psa : cd.currentApprovals()) {
            current.put(psa.getAccountId(), psa.getLabel(), psa);
        }
        LabelTypes labelTypes = cd.getLabelTypes();
        for (Account.Id accountId : allUsers) {
            PermissionBackend.ForChange perm = basePerm.user(this.userFactory.create(accountId));
            Map<String, VotingRangeInfo> pvr = this.getPermittedVotingRanges(this.permittedLabels(perm, cd));
            for (Map.Entry<String, LabelWithStatus> e : labels.entrySet()) {
                Integer value;
                LabelType lt = labelTypes.byLabel(e.getKey());
                if (lt == null) continue;
                VotingRangeInfo permittedVotingRange = pvr.getOrDefault(lt.getName(), null);
                String tag = null;
                Timestamp date = null;
                PatchSetApproval psa = (PatchSetApproval)current.get(accountId, lt.getName());
                if (psa != null) {
                    value = psa.getValue();
                    if (value == 0) {
                        value = perm.test(new LabelPermission(lt)) ? Integer.valueOf(0) : null;
                    }
                    tag = psa.getTag();
                    date = psa.getGranted();
                    if (psa.isPostSubmit()) {
                        log.warn("unexpected post-submit approval on open change: {}", (Object)psa);
                    }
                } else {
                    value = perm.test(new LabelPermission(lt)) ? Integer.valueOf(0) : null;
                }
                ChangeJson.addApproval(e.getValue().label(), this.approvalInfo(accountId, value, permittedVotingRange, tag, date));
            }
        }
    }

    private Map<String, VotingRangeInfo> getPermittedVotingRanges(Map<String, Collection<String>> permittedLabels) {
        HashMap<String, VotingRangeInfo> permittedVotingRanges = Maps.newHashMapWithExpectedSize(permittedLabels.size());
        for (String label : permittedLabels.keySet()) {
            List permittedVotingRange = permittedLabels.get(label).stream().map(this::parseRangeValue).filter(Objects::nonNull).sorted().collect(Collectors.toList());
            if (permittedVotingRange.isEmpty()) {
                permittedVotingRanges.put(label, null);
                continue;
            }
            int minPermittedValue = (Integer)permittedVotingRange.get(0);
            int maxPermittedValue = (Integer)Iterables.getLast(permittedVotingRange);
            permittedVotingRanges.put(label, new VotingRangeInfo(minPermittedValue, maxPermittedValue));
        }
        return permittedVotingRanges;
    }

    private Integer parseRangeValue(String value) {
        if (value.startsWith("+")) {
            value = value.substring(1);
        } else if (value.startsWith(" ")) {
            value = value.trim();
        }
        return Ints.tryParse(value);
    }

    private void setSubmitter(ChangeData cd, ChangeInfo out) throws OrmException {
        Optional<PatchSetApproval> s = cd.getSubmitApproval();
        if (!s.isPresent()) {
            return;
        }
        out.submitted = s.get().getGranted();
        out.submitter = this.accountLoader.get(s.get().getAccountId());
    }

    private Map<String, LabelWithStatus> labelsForSubmittedChange(PermissionBackend.ForChange basePerm, ChangeData cd, LabelTypes labelTypes, boolean standard, boolean detailed) throws OrmException, PermissionBackendException {
        HashSet<Account.Id> allUsers = new HashSet<Account.Id>();
        if (detailed) {
            for (PatchSetApproval psa : cd.approvals().values()) {
                allUsers.add(psa.getAccountId());
            }
        }
        HashSet<String> labelNames = new HashSet<String>();
        Multimap current = MultimapBuilder.hashKeys().hashSetValues().build();
        for (PatchSetApproval a : cd.currentApprovals()) {
            allUsers.add(a.getAccountId());
            LabelType type = labelTypes.byLabel(a.getLabelId());
            if (type == null) continue;
            labelNames.add(type.getName());
            current.put(a.getAccountId(), a);
        }
        Map<String, LabelWithStatus> labels = this.initLabels(cd, labelTypes, standard);
        for (String name : labelNames) {
            if (labels.containsKey(name)) continue;
            labels.put(name, LabelWithStatus.create(new LabelInfo(), null));
        }
        if (detailed) {
            labels.entrySet().stream().filter(e -> labelTypes.byLabel((String)e.getKey()) != null).forEach(e -> this.setLabelValues(labelTypes.byLabel((String)e.getKey()), (LabelWithStatus)e.getValue()));
        }
        for (Account.Id accountId : allUsers) {
            HashMap<String, ApprovalInfo> byLabel = Maps.newHashMapWithExpectedSize(labels.size());
            Map<Object, Object> pvr = Collections.emptyMap();
            if (detailed) {
                PermissionBackend.ForChange perm = basePerm.user(this.userFactory.create(accountId));
                pvr = this.getPermittedVotingRanges(this.permittedLabels(perm, cd));
                for (Map.Entry<String, LabelWithStatus> entry : labels.entrySet()) {
                    ApprovalInfo ai = this.approvalInfo(accountId, 0, null, null, null);
                    byLabel.put(entry.getKey(), ai);
                    ChangeJson.addApproval(entry.getValue().label(), ai);
                }
            }
            for (PatchSetApproval psa : current.get(accountId)) {
                LabelType type = labelTypes.byLabel(psa.getLabelId());
                if (type == null) continue;
                short val = psa.getValue();
                ApprovalInfo info = (ApprovalInfo)byLabel.get(type.getName());
                if (info != null) {
                    info.value = val;
                    info.permittedVotingRange = pvr.getOrDefault(type.getName(), null);
                    info.date = psa.getGranted();
                    info.tag = psa.getTag();
                    if (psa.isPostSubmit()) {
                        info.postSubmit = true;
                    }
                }
                if (!standard) continue;
                this.setLabelScores(type, labels.get(type.getName()), val, accountId);
            }
        }
        return labels;
    }

    private ApprovalInfo approvalInfo(Account.Id id, Integer value, VotingRangeInfo permittedVotingRange, String tag, Timestamp date) {
        ApprovalInfo ai = ChangeJson.getApprovalInfo(id, value, permittedVotingRange, tag, date);
        this.accountLoader.put(ai);
        return ai;
    }

    public static ApprovalInfo getApprovalInfo(Account.Id id, Integer value, @Nullable VotingRangeInfo permittedVotingRange, @Nullable String tag, Timestamp date) {
        ApprovalInfo ai = new ApprovalInfo(id.get());
        ai.value = value;
        ai.permittedVotingRange = permittedVotingRange;
        ai.date = date;
        ai.tag = tag;
        return ai;
    }

    private static boolean isOnlyZero(Collection<String> values) {
        return values.isEmpty() || values.size() == 1 && values.contains(" 0");
    }

    private void setLabelValues(LabelType type, LabelWithStatus l) {
        l.label().defaultValue = type.getDefaultValue();
        l.label().values = new LinkedHashMap<String, String>();
        for (LabelValue v : type.getValues()) {
            l.label().values.put(v.formatValue(), v.getText());
        }
        if (ChangeJson.isOnlyZero(l.label().values.keySet())) {
            l.label().values = null;
        }
    }

    private Map<String, Collection<String>> permittedLabels(PermissionBackend.ForChange perm, ChangeData cd) throws OrmException, PermissionBackendException {
        boolean isMerged = cd.change().getStatus() == Change.Status.MERGED;
        LabelTypes labelTypes = cd.getLabelTypes();
        HashMap<String, LabelType> toCheck = new HashMap<String, LabelType>();
        for (SubmitRecord rec : this.submitRecords(cd)) {
            if (rec.labels == null) continue;
            for (SubmitRecord.Label label : rec.labels) {
                LabelType type = labelTypes.byLabel(label.label);
                if (type == null || isMerged && !type.allowPostSubmit()) continue;
                toCheck.put(type.getName(), type);
            }
        }
        Map<String, Short> labels = null;
        Set<LabelPermission.WithValue> can = perm.testLabels(toCheck.values());
        LinkedHashMultimap<String, String> permitted = LinkedHashMultimap.create();
        for (SubmitRecord rec : this.submitRecords(cd)) {
            if (rec.labels == null) continue;
            for (SubmitRecord.Label r : rec.labels) {
                LabelType type = labelTypes.byLabel(r.label);
                if (type == null || isMerged && !type.allowPostSubmit()) continue;
                for (LabelValue v : type.getValues()) {
                    boolean ok = can.contains(new LabelPermission.WithValue(type, v));
                    if (isMerged) {
                        if (labels == null) {
                            labels = this.currentLabels(perm, cd);
                        }
                        short prev = labels.getOrDefault(type.getName(), (short)0);
                        ok &= v.getValue() >= prev;
                    }
                    if (!ok) continue;
                    permitted.put(r.label, v.formatValue());
                }
            }
        }
        ArrayList<String> arrayList = Lists.newArrayListWithCapacity(permitted.keySet().size());
        for (Map.Entry e : permitted.asMap().entrySet()) {
            if (!ChangeJson.isOnlyZero(e.getValue())) continue;
            arrayList.add((String)e.getKey());
        }
        for (String label : arrayList) {
            permitted.removeAll(label);
        }
        return permitted.asMap();
    }

    private Map<String, Short> currentLabels(PermissionBackend.ForChange perm, ChangeData cd) throws OrmException {
        IdentifiedUser user = perm.user().asIdentifiedUser();
        HashMap<String, Short> result = new HashMap<String, Short>();
        for (PatchSetApproval psa : this.approvalsUtil.byPatchSetUser(this.db.get(), this.lazyLoad ? cd.notes() : this.notesFactory.createFromIndexedChange(cd.change()), user, cd.change().currentPatchSetId(), user.getAccountId(), null, null)) {
            result.put(psa.getLabel(), psa.getValue());
        }
        return result;
    }

    private Collection<ChangeMessageInfo> messages(ChangeData cd) throws OrmException {
        List<ChangeMessage> messages = this.cmUtil.byChange(this.db.get(), cd.notes());
        if (messages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ChangeMessageInfo> result = Lists.newArrayListWithCapacity(messages.size());
        for (ChangeMessage message : messages) {
            PatchSet.Id patchNum = message.getPatchSetId();
            ChangeMessageInfo cmi = new ChangeMessageInfo();
            cmi.id = message.getKey().get();
            cmi.author = this.accountLoader.get(message.getAuthor());
            cmi.date = message.getWrittenOn();
            cmi.message = message.getMessage();
            cmi.tag = message.getTag();
            cmi._revisionNumber = patchNum != null ? Integer.valueOf(patchNum.get()) : null;
            Account.Id realAuthor = message.getRealAuthor();
            if (realAuthor != null) {
                cmi.realAuthor = this.accountLoader.get(realAuthor);
            }
            result.add(cmi);
        }
        return result;
    }

    private Collection<AccountInfo> removableReviewers(ChangeData cd, ChangeInfo out) throws PermissionBackendException, NoSuchProjectException, OrmException, IOException {
        Collection<LabelInfo> labels = out.labels.values();
        HashSet<Account.Id> fixed = Sets.newHashSetWithExpectedSize(labels.size());
        HashSet<Account.Id> removable = Sets.newHashSetWithExpectedSize(labels.size());
        for (LabelInfo labelInfo : labels) {
            if (labelInfo.all == null) continue;
            for (ApprovalInfo approvalInfo : labelInfo.all) {
                Account.Id id = new Account.Id(approvalInfo._accountId);
                if (this.removeReviewerControl.testRemoveReviewer(cd, this.userProvider.get(), id, MoreObjects.firstNonNull(approvalInfo.value, 0))) {
                    removable.add(id);
                    continue;
                }
                fixed.add(id);
            }
        }
        Collection<AccountInfo> ccs = out.reviewers.get((Object)ReviewerState.CC);
        if (ccs != null) {
            for (AccountInfo ai : ccs) {
                if (ai._accountId == null) continue;
                Account.Id id = new Account.Id(ai._accountId);
                if (!this.removeReviewerControl.testRemoveReviewer(cd, this.userProvider.get(), id, 0)) continue;
                removable.add(id);
            }
        }
        removable.removeAll(fixed);
        ArrayList<AccountInfo> arrayList = Lists.newArrayListWithCapacity(removable.size());
        for (Account.Id id : removable) {
            arrayList.add(this.accountLoader.get(id));
        }
        for (Collection collection : out.reviewers.values()) {
            for (AccountInfo info : collection) {
                if (info._accountId != null) continue;
                arrayList.add(info);
            }
        }
        return arrayList;
    }

    private Collection<AccountInfo> toAccountInfo(Collection<Account.Id> accounts) {
        return accounts.stream().map(this.accountLoader::get).sorted(AccountInfoComparator.ORDER_NULLS_FIRST).collect(Collectors.toList());
    }

    private Collection<AccountInfo> toAccountInfoByEmail(Collection<Address> addresses) {
        return addresses.stream().map(a -> new AccountInfo(a.getName(), a.getEmail())).sorted(AccountInfoComparator.ORDER_NULLS_FIRST).collect(Collectors.toList());
    }

    @Nullable
    private Repository openRepoIfNecessary(Project.NameKey project) throws IOException {
        if (this.has(ListChangesOption.ALL_COMMITS) || this.has(ListChangesOption.CURRENT_COMMIT) || this.has(ListChangesOption.COMMIT_FOOTERS)) {
            return this.repoManager.openRepository(project);
        }
        return null;
    }

    @Nullable
    private RevWalk newRevWalk(@Nullable Repository repo) {
        return repo != null ? new RevWalk(repo) : null;
    }

    /*
     * Exception decompiling
     */
    private Map<String, RevisionInfo> revisions(ChangeData cd, Map<PatchSet.Id, PatchSet> map, Optional<PatchSet.Id> limitToPsId, ChangeInfo changeInfo) throws PatchListNotAvailableException, GpgException, OrmException, IOException, PermissionBackendException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<PatchSet.Id, PatchSet> loadPatchSets(ChangeData cd, Optional<PatchSet.Id> limitToPsId) throws OrmException {
        Collection<PatchSet> src;
        if (this.has(ListChangesOption.ALL_REVISIONS) || this.has(ListChangesOption.MESSAGES)) {
            src = cd.patchSets();
        } else {
            PatchSet ps;
            if (limitToPsId.isPresent()) {
                ps = cd.patchSet(limitToPsId.get());
                if (ps == null) {
                    throw new OrmException("missing patch set " + limitToPsId.get());
                }
            } else {
                ps = cd.currentPatchSet();
                if (ps == null) {
                    throw new OrmException("missing current patch set for change " + cd.getId());
                }
            }
            src = Collections.singletonList(ps);
        }
        HashMap<PatchSet.Id, PatchSet> map = Maps.newHashMapWithExpectedSize(src.size());
        for (PatchSet patchSet : src) {
            map.put(patchSet.getId(), patchSet);
        }
        return map;
    }

    /*
     * Exception decompiling
     */
    public RevisionInfo getRevisionInfo(ChangeData cd, PatchSet in) throws PatchListNotAvailableException, GpgException, OrmException, IOException, PermissionBackendException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private RevisionInfo toRevisionInfo(ChangeData cd, PatchSet in, @Nullable Repository repo, @Nullable RevWalk rw, boolean fillCommit, @Nullable ChangeInfo changeInfo, boolean isWorldReadable) throws PatchListNotAvailableException, GpgException, OrmException, IOException {
        boolean addFooters;
        Change c = cd.change();
        RevisionInfo out = new RevisionInfo();
        out.isCurrent = in.getId().equals(c.currentPatchSetId());
        out._number = in.getId().get();
        out.ref = in.getRefName();
        out.created = in.getCreatedOn();
        out.uploader = this.accountLoader.get(in.getUploader());
        out.fetch = this.makeFetchMap(cd, in, isWorldReadable);
        out.kind = this.changeKindCache.getChangeKind(rw, repo != null ? repo.getConfig() : null, cd, in);
        out.description = in.getDescription();
        boolean setCommit = this.has(ListChangesOption.ALL_COMMITS) || out.isCurrent && this.has(ListChangesOption.CURRENT_COMMIT);
        boolean bl = addFooters = out.isCurrent && this.has(ListChangesOption.COMMIT_FOOTERS);
        if (setCommit || addFooters) {
            Preconditions.checkState(rw != null);
            Preconditions.checkState(repo != null);
            Project.NameKey project = c.getProject();
            String rev = in.getRevision().get();
            RevCommit commit = rw.parseCommit(ObjectId.fromString(rev));
            rw.parseBody(commit);
            if (setCommit) {
                out.commit = this.toCommit(project, rw, commit, this.has(ListChangesOption.WEB_LINKS), fillCommit);
            }
            if (addFooters) {
                Ref ref = repo.exactRef(cd.change().getDest().get());
                RevCommit mergeTip = null;
                if (ref != null) {
                    mergeTip = rw.parseCommit(ref.getObjectId());
                    rw.parseBody(mergeTip);
                }
                out.commitWithFooters = this.mergeUtilFactory.create(this.projectCache.get(project)).createCommitMessageOnSubmit(commit, mergeTip, cd.notes(), this.userProvider.get(), in.getId());
            }
        }
        if (this.has(ListChangesOption.ALL_FILES) || out.isCurrent && this.has(ListChangesOption.CURRENT_FILES)) {
            out.files = this.fileInfoJson.toFileInfoMap(c, in);
            out.files.remove("/COMMIT_MSG");
            out.files.remove("/MERGE_LIST");
        }
        if (out.isCurrent && this.has(ListChangesOption.CURRENT_ACTIONS) && this.userProvider.get().isIdentifiedUser()) {
            this.actionJson.addRevisionActions(changeInfo, out, new RevisionResource(this.changeResourceFactory.create(cd.notes(), this.userProvider.get()), in));
        }
        if (this.gpgApi.isEnabled() && this.has(ListChangesOption.PUSH_CERTIFICATES)) {
            out.pushCertificate = in.getPushCertificate() != null ? this.gpgApi.checkPushCertificate(in.getPushCertificate(), this.userFactory.create(in.getUploader())) : new PushCertificateInfo();
        }
        return out;
    }

    CommitInfo toCommit(Project.NameKey project, RevWalk rw, RevCommit commit, boolean addLinks, boolean fillCommit) throws IOException {
        CommitInfo info = new CommitInfo();
        if (fillCommit) {
            info.commit = commit.name();
        }
        info.parents = new ArrayList<CommitInfo>(commit.getParentCount());
        info.author = CommonConverters.toGitPerson(commit.getAuthorIdent());
        info.committer = CommonConverters.toGitPerson(commit.getCommitterIdent());
        info.subject = commit.getShortMessage();
        info.message = commit.getFullMessage();
        if (addLinks) {
            List<WebLinkInfo> links = this.webLinks.getPatchSetLinks(project, commit.name());
            info.webLinks = links.isEmpty() ? null : links;
        }
        for (RevCommit parent : commit.getParents()) {
            rw.parseBody(parent);
            CommitInfo i = new CommitInfo();
            i.commit = parent.name();
            i.subject = parent.getShortMessage();
            if (addLinks) {
                List<WebLinkInfo> parentLinks = this.webLinks.getParentLinks(project, parent.name());
                i.webLinks = parentLinks.isEmpty() ? null : parentLinks;
            }
            info.parents.add(i);
        }
        return info;
    }

    private Map<String, FetchInfo> makeFetchMap(ChangeData cd, PatchSet in, boolean isWorldReadable) {
        LinkedHashMap<String, FetchInfo> r = new LinkedHashMap<String, FetchInfo>();
        for (DynamicMap.Entry<DownloadScheme> entry : this.downloadSchemes) {
            String schemeName = entry.getExportName();
            DownloadScheme scheme = entry.getProvider().get();
            if (!scheme.isEnabled() || scheme.isAuthRequired() && !this.userProvider.get().isIdentifiedUser() || !scheme.isAuthSupported() && !isWorldReadable) continue;
            String projectName = cd.project().get();
            String url = scheme.getUrl(projectName);
            String refName = in.getRefName();
            FetchInfo fetchInfo = new FetchInfo(url, refName);
            r.put(schemeName, fetchInfo);
            if (!this.has(ListChangesOption.DOWNLOAD_COMMANDS)) continue;
            ChangeJson.populateFetchMap(scheme, this.downloadCommands, projectName, refName, fetchInfo);
        }
        return r;
    }

    public static void populateFetchMap(DownloadScheme scheme, DynamicMap<DownloadCommand> commands, String projectName, String refName, FetchInfo fetchInfo) {
        for (DynamicMap.Entry<DownloadCommand> entry : commands) {
            String commandName = entry.getExportName();
            DownloadCommand command = entry.getProvider().get();
            String c = command.getCommand(scheme, projectName, refName);
            if (c == null) continue;
            ChangeJson.addCommand(fetchInfo, commandName, c);
        }
    }

    private static void addCommand(FetchInfo fetchInfo, String commandName, String c) {
        if (fetchInfo.commands == null) {
            fetchInfo.commands = new TreeMap<String, String>();
        }
        fetchInfo.commands.put(commandName, c);
    }

    static void finish(ChangeInfo info) {
        info.id = Joiner.on('~').join(Url.encode(info.project), Url.encode(info.branch), Url.encode(info.changeId));
    }

    private static void addApproval(LabelInfo label, ApprovalInfo approval) {
        if (label.all == null) {
            label.all = new ArrayList<ApprovalInfo>();
        }
        label.all.add(approval);
    }

    private PermissionBackend.ForChange permissionBackendForChange(CurrentUser user, ChangeData cd) throws OrmException {
        PermissionBackend.WithUser withUser = (PermissionBackend.WithUser)this.permissionBackend.user(user).database(this.db);
        return this.lazyLoad ? withUser.change(cd) : withUser.indexedChange(cd, this.notesFactory.createFromIndexedChange(cd.change()));
    }

    private boolean isWorldReadable(ChangeData cd) throws OrmException, PermissionBackendException {
        try {
            this.permissionBackendForChange(this.anonymous, cd).check(ChangePermission.READ);
            return true;
        }
        catch (AuthException ae) {
            return false;
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    @AutoValue
    static abstract class LabelWithStatus {
        LabelWithStatus() {
        }

        private static LabelWithStatus create(LabelInfo label, SubmitRecord.Label.Status status) {
            return new AutoValue_ChangeJson_LabelWithStatus(label, status);
        }

        abstract LabelInfo label();

        @Nullable
        abstract SubmitRecord.Label.Status status();
    }

    public static interface AssistedFactory {
        public ChangeJson create(Iterable<ListChangesOption> var1);
    }

    @Singleton
    public static class Factory {
        private final AssistedFactory factory;

        @Inject
        Factory(AssistedFactory factory) {
            this.factory = factory;
        }

        public ChangeJson noOptions() {
            return this.create(ImmutableSet.of());
        }

        public ChangeJson create(Iterable<ListChangesOption> options) {
            return this.factory.create(options);
        }

        public ChangeJson create(ListChangesOption first, ListChangesOption ... rest) {
            return this.create(Sets.immutableEnumSet((Enum)first, (Enum[])rest));
        }
    }
}

