/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.extensions.common.BlameInfo;
import com.google.gerrit.extensions.common.RangeInfo;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.change.FileResource;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.patch.AutoMerger;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gitiles.blame.cache.BlameCache;
import com.google.gitiles.blame.cache.Region;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ThreeWayMergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Option;

public class GetBlame
implements RestReadView<FileResource> {
    private final GitRepositoryManager repoManager;
    private final BlameCache blameCache;
    private final boolean allowBlame;
    private final ThreeWayMergeStrategy mergeStrategy;
    private final AutoMerger autoMerger;
    @Option(name="--base", aliases={"-b"}, usage="whether to load the blame of the base revision (the direct parent of the change) instead of the change")
    private boolean base;

    @Inject
    GetBlame(GitRepositoryManager repoManager, BlameCache blameCache, @GerritServerConfig Config cfg, AutoMerger autoMerger) {
        this.repoManager = repoManager;
        this.blameCache = blameCache;
        this.mergeStrategy = MergeUtil.getMergeStrategy(cfg);
        this.autoMerger = autoMerger;
        this.allowBlame = cfg.getBoolean("change", "allowBlame", true);
    }

    /*
     * Exception decompiling
     */
    public Response<List<BlameInfo>> apply(FileResource resource) throws RestApiException, OrmException, IOException, InvalidChangeOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<BlameInfo> blame(ObjectId id, String path, Repository repository, RevWalk revWalk) throws IOException {
        Multimap ranges = MultimapBuilder.hashKeys().arrayListValues().build();
        ArrayList<BlameInfo> result = new ArrayList<BlameInfo>();
        if (this.blameCache.findLastCommit(repository, id, path) == null) {
            return result;
        }
        List<Region> blameRegions = this.blameCache.get(repository, id, path);
        int from = 1;
        for (Region region : blameRegions) {
            RevCommit commit = revWalk.parseCommit(region.getSourceCommit());
            BlameInfo blameInfo = GetBlame.toBlameInfo(commit, region.getSourceAuthor());
            ranges.put(blameInfo, new RangeInfo(from, from + region.getCount() - 1));
            from += region.getCount();
        }
        for (BlameInfo key : ranges.keySet()) {
            key.ranges = ranges.get(key);
            result.add(key);
        }
        return result;
    }

    private static BlameInfo toBlameInfo(RevCommit commit, PersonIdent sourceAuthor) {
        BlameInfo blameInfo = new BlameInfo();
        blameInfo.author = sourceAuthor.getName();
        blameInfo.id = commit.getName();
        blameInfo.commitMsg = commit.getFullMessage();
        blameInfo.time = commit.getCommitTime();
        return blameInfo;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

