/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.api.changes.ReviewerInfo;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.ReviewerJson;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.LinkedHashMap;
import java.util.List;

@Singleton
public class ListReviewers
implements RestReadView<ChangeResource> {
    private final Provider<ReviewDb> dbProvider;
    private final ApprovalsUtil approvalsUtil;
    private final ReviewerJson json;
    private final ReviewerResource.Factory resourceFactory;

    @Inject
    ListReviewers(Provider<ReviewDb> dbProvider, ApprovalsUtil approvalsUtil, ReviewerResource.Factory resourceFactory, ReviewerJson json) {
        this.dbProvider = dbProvider;
        this.approvalsUtil = approvalsUtil;
        this.resourceFactory = resourceFactory;
        this.json = json;
    }

    public List<ReviewerInfo> apply(ChangeResource rsrc) throws OrmException, PermissionBackendException {
        LinkedHashMap<String, ReviewerResource> reviewers = new LinkedHashMap<String, ReviewerResource>();
        ReviewDb db = this.dbProvider.get();
        for (Account.Id accountId : this.approvalsUtil.getReviewers(db, rsrc.getNotes()).all()) {
            if (reviewers.containsKey(accountId.toString())) continue;
            reviewers.put(accountId.toString(), this.resourceFactory.create(rsrc, accountId));
        }
        for (Address adr : rsrc.getNotes().getReviewersByEmail().all()) {
            if (reviewers.containsKey(adr.toString())) continue;
            reviewers.put(adr.toString(), new ReviewerResource(rsrc, adr));
        }
        return this.json.format(reviewers.values());
    }
}

