/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.edit.ChangeEdit;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.inject.TypeLiteral;
import java.util.Optional;

public class RevisionResource
implements RestResource,
RestResource.HasETag {
    public static final TypeLiteral<RestView<RevisionResource>> REVISION_KIND = new TypeLiteral<RestView<RevisionResource>>(){};
    private final ChangeResource change;
    private final PatchSet ps;
    private final Optional<ChangeEdit> edit;
    private boolean cacheable = true;

    public RevisionResource(ChangeResource change, PatchSet ps) {
        this(change, ps, Optional.empty());
    }

    public RevisionResource(ChangeResource change, PatchSet ps, Optional<ChangeEdit> edit) {
        this.change = change;
        this.ps = ps;
        this.edit = edit;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public PermissionBackend.ForChange permissions() {
        return this.change.permissions();
    }

    public ChangeResource getChangeResource() {
        return this.change;
    }

    public Change getChange() {
        return this.getChangeResource().getChange();
    }

    public Project.NameKey getProject() {
        return this.getChange().getProject();
    }

    public ChangeNotes getNotes() {
        return this.getChangeResource().getNotes();
    }

    public PatchSet getPatchSet() {
        return this.ps;
    }

    @Override
    public String getETag() {
        Hasher h = Hashing.murmur3_128().newHasher();
        this.prepareETag(h, this.getUser());
        return h.hash().toString();
    }

    void prepareETag(Hasher h, CurrentUser user) {
        this.change.prepareETag(h, user);
    }

    Account.Id getAccountId() {
        return this.getUser().getAccountId();
    }

    CurrentUser getUser() {
        return this.getChangeResource().getUser();
    }

    RevisionResource doNotCache() {
        this.cacheable = false;
        return this;
    }

    public Optional<ChangeEdit> getEdit() {
        return this.edit;
    }

    public String toString() {
        String s = this.ps.getId().toString();
        if (this.edit.isPresent()) {
            s = "edit:" + s;
        }
        return s;
    }

    public boolean isCurrent() {
        return this.ps.getId().equals(this.getChange().currentPatchSetId());
    }
}

