/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GetDiffPreferences;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.lang.reflect.Field;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresCapability(value="administrateServer")
@Singleton
public class SetDiffPreferences
implements RestModifyView<ConfigResource, DiffPreferencesInfo> {
    private static final Logger log = LoggerFactory.getLogger(SetDiffPreferences.class);
    private final Provider<MetaDataUpdate.User> metaDataUpdateFactory;
    private final AllUsersName allUsersName;
    private final GitRepositoryManager gitManager;

    @Inject
    SetDiffPreferences(GitRepositoryManager gitManager, Provider<MetaDataUpdate.User> metaDataUpdateFactory, AllUsersName allUsersName) {
        this.gitManager = gitManager;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.allUsersName = allUsersName;
    }

    public DiffPreferencesInfo apply(ConfigResource configResource, DiffPreferencesInfo in) throws BadRequestException, IOException, ConfigInvalidException {
        if (in == null) {
            throw new BadRequestException("input must be provided");
        }
        if (!SetDiffPreferences.hasSetFields(in)) {
            throw new BadRequestException("unsupported option");
        }
        return this.writeToGit(GetDiffPreferences.readFromGit(this.gitManager, this.allUsersName, in));
    }

    private DiffPreferencesInfo writeToGit(DiffPreferencesInfo in) throws RepositoryNotFoundException, IOException, ConfigInvalidException {
        DiffPreferencesInfo out = new DiffPreferencesInfo();
        try (MetaDataUpdate md = this.metaDataUpdateFactory.get().create(this.allUsersName);){
            VersionedAccountPreferences prefs = VersionedAccountPreferences.forDefault();
            prefs.load(md);
            DiffPreferencesInfo defaults = DiffPreferencesInfo.defaults();
            ConfigUtil.storeSection(prefs.getConfig(), "diff", null, in, defaults);
            prefs.commit(md);
            ConfigUtil.loadSection(prefs.getConfig(), "diff", null, out, DiffPreferencesInfo.defaults(), null);
        }
        return out;
    }

    private static boolean hasSetFields(DiffPreferencesInfo in) {
        try {
            for (Field field : in.getClass().getDeclaredFields()) {
                if (ConfigUtil.skipField(field) || field.get(in) == null) continue;
                return true;
            }
        }
        catch (IllegalAccessException e) {
            log.warn("Unable to verify input", e);
        }
        return false;
    }
}

