/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.events;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ApprovalInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.RevisionInfo;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GpgException;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EventUtil {
    private static final Logger log = LoggerFactory.getLogger(EventUtil.class);
    private static final ImmutableSet<ListChangesOption> CHANGE_OPTIONS;
    private final ChangeData.Factory changeDataFactory;
    private final Provider<ReviewDb> db;
    private final ChangeJson.Factory changeJsonFactory;

    @Inject
    EventUtil(ChangeJson.Factory changeJsonFactory, ChangeData.Factory changeDataFactory, Provider<ReviewDb> db) {
        this.changeDataFactory = changeDataFactory;
        this.db = db;
        this.changeJsonFactory = changeJsonFactory;
    }

    public ChangeInfo changeInfo(Change change) throws OrmException {
        return this.changeJsonFactory.create(CHANGE_OPTIONS).format(change);
    }

    public RevisionInfo revisionInfo(Project project, PatchSet ps) throws OrmException, PatchListNotAvailableException, GpgException, IOException, PermissionBackendException {
        return this.revisionInfo(project.getNameKey(), ps);
    }

    public RevisionInfo revisionInfo(Project.NameKey project, PatchSet ps) throws OrmException, PatchListNotAvailableException, GpgException, IOException, PermissionBackendException {
        ChangeData cd = this.changeDataFactory.create(this.db.get(), project, ps.getId().getParentKey());
        return this.changeJsonFactory.create(CHANGE_OPTIONS).getRevisionInfo(cd, ps);
    }

    public AccountInfo accountInfo(Account a) {
        if (a == null || a.getId() == null) {
            return null;
        }
        AccountInfo accountInfo = new AccountInfo(a.getId().get());
        accountInfo.email = a.getPreferredEmail();
        accountInfo.name = a.getFullName();
        accountInfo.username = a.getUserName();
        return accountInfo;
    }

    public Map<String, ApprovalInfo> approvals(Account a, Map<String, Short> approvals, Timestamp ts) {
        HashMap<String, ApprovalInfo> result = new HashMap<String, ApprovalInfo>();
        for (Map.Entry<String, Short> e : approvals.entrySet()) {
            Integer value = e.getValue() != null ? Integer.valueOf(e.getValue().shortValue()) : null;
            result.put(e.getKey(), ChangeJson.getApprovalInfo(a.getId(), value, null, null, ts));
        }
        return result;
    }

    public void logEventListenerError(Object event, Object listener, Exception error) {
        if (log.isDebugEnabled()) {
            log.debug("Error in event listener {} for event {}", listener.getClass().getName(), event.getClass().getName(), error);
        } else {
            log.warn("Error in event listener {} for event {}: {} - {}", listener.getClass().getName(), event.getClass().getName(), error.getClass().getName(), error.getMessage());
        }
    }

    public static void logEventListenerError(Object listener, Exception error) {
        if (log.isDebugEnabled()) {
            log.debug("Error in event listener {}", (Object)listener.getClass().getName(), (Object)error);
        } else {
            log.warn("Error in event listener {}: {}", (Object)listener.getClass().getName(), (Object)error.getMessage());
        }
    }

    static {
        EnumSet<ListChangesOption> opts = EnumSet.allOf(ListChangesOption.class);
        opts.remove((Object)ListChangesOption.CHANGE_ACTIONS);
        opts.remove((Object)ListChangesOption.CURRENT_ACTIONS);
        opts.remove((Object)ListChangesOption.CHECK);
        CHANGE_OPTIONS = Sets.immutableEnumSet(opts);
    }
}

