/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gwtorm.server.OrmException;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCollector {
    private static final Logger log = LoggerFactory.getLogger(GroupCollector.class);
    private final ListMultimap<ObjectId, PatchSet.Id> patchSetsBySha;
    private final ListMultimap<ObjectId, String> groups;
    private final SetMultimap<String, String> groupAliases;
    private final Lookup groupLookup;
    private boolean done;

    public static List<String> getDefaultGroups(PatchSet ps) {
        return ImmutableList.of(ps.getRevision().get());
    }

    public static List<String> getDefaultGroups(ObjectId commit) {
        return ImmutableList.of(commit.name());
    }

    public static List<String> getGroups(RevisionResource rsrc) {
        if (rsrc.getEdit().isPresent()) {
            return rsrc.getEdit().get().getBasePatchSet().getGroups();
        }
        return rsrc.getPatchSet().getGroups();
    }

    public static GroupCollector create(ListMultimap<ObjectId, Ref> changeRefsById, final ReviewDb db, final PatchSetUtil psUtil, final ChangeNotes.Factory notesFactory, final Project.NameKey project) {
        return new GroupCollector(GroupCollector.transformRefs(changeRefsById), new Lookup(){

            @Override
            public List<String> lookup(PatchSet.Id psId) throws OrmException {
                ChangeNotes notes = notesFactory.createChecked(db, project, psId.getParentKey());
                PatchSet ps = psUtil.get(db, notes, psId);
                return ps != null ? ps.getGroups() : null;
            }
        });
    }

    public static GroupCollector createForSchemaUpgradeOnly(ListMultimap<ObjectId, Ref> changeRefsById, final ReviewDb db) {
        return new GroupCollector(GroupCollector.transformRefs(changeRefsById), new Lookup(){

            @Override
            public List<String> lookup(PatchSet.Id psId) throws OrmException {
                PatchSet ps = db.patchSets().get(psId);
                return ps != null ? ps.getGroups() : null;
            }
        });
    }

    private GroupCollector(ListMultimap<ObjectId, PatchSet.Id> patchSetsBySha, Lookup groupLookup) {
        this.patchSetsBySha = patchSetsBySha;
        this.groupLookup = groupLookup;
        this.groups = MultimapBuilder.hashKeys().arrayListValues().build();
        this.groupAliases = MultimapBuilder.hashKeys().hashSetValues().build();
    }

    private static ListMultimap<ObjectId, PatchSet.Id> transformRefs(ListMultimap<ObjectId, Ref> refs) {
        return Multimaps.transformValues(refs, r -> PatchSet.Id.fromRef(r.getName()));
    }

    @VisibleForTesting
    GroupCollector(ListMultimap<ObjectId, PatchSet.Id> patchSetsBySha, final ListMultimap<PatchSet.Id, String> groupLookup) {
        this(patchSetsBySha, new Lookup(){

            @Override
            public List<String> lookup(PatchSet.Id psId) {
                Collection groups = groupLookup.get(psId);
                return !groups.isEmpty() ? groups : null;
            }
        });
    }

    public void visit(RevCommit c) {
        Iterable<String> toAlias;
        Preconditions.checkState(!this.done, "visit() called after getGroups()");
        Set<RevCommit> interestingParents = this.getInterestingParents(c);
        if (interestingParents.size() == 0) {
            this.groups.put(c, c.name());
            return;
        }
        if (interestingParents.size() == 1) {
            this.groups.putAll(c, this.groups.get((Object)interestingParents.iterator().next()));
            return;
        }
        AbstractCollection thisCommitGroups = new TreeSet();
        LinkedHashSet<String> parentGroupsNewInThisPush = Sets.newLinkedHashSetWithExpectedSize(interestingParents.size());
        for (RevCommit p : interestingParents) {
            Collection parentGroups = this.groups.get((Object)p);
            if (parentGroups.isEmpty()) {
                throw new IllegalStateException(String.format("no group assigned to parent %s of commit %s", p.name(), c.name()));
            }
            for (String parentGroup : parentGroups) {
                if (this.isGroupFromExistingPatchSet(p, parentGroup)) {
                    thisCommitGroups.add(parentGroup);
                    continue;
                }
                parentGroupsNewInThisPush.add(parentGroup);
            }
        }
        if (thisCommitGroups.isEmpty()) {
            String firstParentGroup = (String)parentGroupsNewInThisPush.iterator().next();
            thisCommitGroups = ImmutableSet.of(firstParentGroup);
            toAlias = Iterables.skip(parentGroupsNewInThisPush, 1);
        } else {
            toAlias = parentGroupsNewInThisPush;
        }
        this.groups.putAll(c, thisCommitGroups);
        for (String pg : toAlias) {
            this.groupAliases.putAll(pg, thisCommitGroups);
        }
    }

    public SortedSetMultimap<ObjectId, String> getGroups() throws OrmException {
        this.done = true;
        SetMultimap result = MultimapBuilder.hashKeys(this.groups.keySet().size()).treeSetValues().build();
        for (Map.Entry<ObjectId, Collection<String>> e : this.groups.asMap().entrySet()) {
            ObjectId id = e.getKey();
            result.putAll(id.copy(), this.resolveGroups(id, e.getValue()));
        }
        return result;
    }

    private Set<RevCommit> getInterestingParents(RevCommit commit) {
        LinkedHashSet<RevCommit> result = Sets.newLinkedHashSetWithExpectedSize(commit.getParentCount());
        for (RevCommit p : commit.getParents()) {
            if (p.has(RevFlag.UNINTERESTING)) continue;
            result.add(p);
        }
        return result;
    }

    private boolean isGroupFromExistingPatchSet(RevCommit commit, String group) {
        ObjectId id = this.parseGroup(commit, group);
        return id != null && this.patchSetsBySha.containsKey(id);
    }

    private Set<String> resolveGroups(ObjectId forCommit, Collection<String> candidates) throws OrmException {
        TreeSet<String> actual = Sets.newTreeSet();
        HashSet<String> done = Sets.newHashSetWithExpectedSize(candidates.size());
        HashSet<String> seen = Sets.newHashSetWithExpectedSize(candidates.size());
        ArrayDeque<String> todo = new ArrayDeque<String>(candidates);
        while (!todo.isEmpty()) {
            String g = (String)todo.removeFirst();
            if (!seen.add(g)) continue;
            Collection aliases = this.groupAliases.get((Object)g);
            if (aliases.isEmpty()) {
                if (done.contains(g)) continue;
                Iterables.addAll(actual, this.resolveGroup(forCommit, g));
                done.add(g);
                continue;
            }
            todo.addAll(aliases);
        }
        return actual;
    }

    private ObjectId parseGroup(ObjectId forCommit, String group) {
        try {
            return ObjectId.fromString(group);
        }
        catch (IllegalArgumentException e) {
            log.warn("group for commit {} is not a SHA-1: {}", (Object)forCommit.name(), (Object)group);
            return null;
        }
    }

    private Iterable<String> resolveGroup(ObjectId forCommit, String group) throws OrmException {
        List<String> groups;
        PatchSet.Id psId;
        ObjectId id = this.parseGroup(forCommit, group);
        if (id != null && (psId = (PatchSet.Id)Iterables.getFirst(this.patchSetsBySha.get((Object)id), null)) != null && (groups = this.groupLookup.lookup(psId)) != null && !groups.isEmpty()) {
            return groups;
        }
        return ImmutableList.of(group);
    }

    private static interface Lookup {
        public List<String> lookup(PatchSet.Id var1) throws OrmException;
    }
}

