/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.auto.value.AutoValue;
import com.google.gerrit.server.git.AutoValue_InsertedObject;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;

@AutoValue
public abstract class InsertedObject {
    static InsertedObject create(int type, InputStream in) throws IOException {
        return InsertedObject.create(type, ByteString.readFrom(in));
    }

    static InsertedObject create(int type, ByteString bs) {
        ObjectId id;
        try (ObjectInserter.Formatter fmt = new ObjectInserter.Formatter();){
            id = fmt.idFor(type, bs.size(), bs.newInput());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return new AutoValue_InsertedObject(id, type, bs);
    }

    static InsertedObject create(int type, byte[] src, int off, int len) {
        return InsertedObject.create(type, ByteString.copyFrom(src, off, len));
    }

    public abstract ObjectId id();

    public abstract int type();

    public abstract ByteString data();

    ObjectLoader newLoader() {
        return new ObjectLoader.SmallObject(this.type(), this.data().toByteArray());
    }
}

