/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Shorts;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.ContributorAgreement;
import com.google.gerrit.common.data.GlobalCapability;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.LabelFunction;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.common.data.RefConfigSection;
import com.google.gerrit.common.data.SubscribeSection;
import com.google.gerrit.common.errors.InvalidNameException;
import com.google.gerrit.extensions.client.InheritableBoolean;
import com.google.gerrit.extensions.client.ProjectState;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.PluginConfig;
import com.google.gerrit.server.git.AccountsSection;
import com.google.gerrit.server.git.BranchOrderSection;
import com.google.gerrit.server.git.ConfiguredMimeTypes;
import com.google.gerrit.server.git.GroupList;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.NotifyConfig;
import com.google.gerrit.server.git.ValidationError;
import com.google.gerrit.server.git.VersionedMetaData;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.project.CommentLinkInfoImpl;
import com.google.gerrit.server.project.RefPattern;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.RefSpec;

public class ProjectConfig
extends VersionedMetaData
implements ValidationError.Sink {
    public static final String COMMENTLINK = "commentlink";
    private static final String KEY_MATCH = "match";
    private static final String KEY_HTML = "html";
    private static final String KEY_LINK = "link";
    private static final String KEY_ENABLED = "enabled";
    public static final String PROJECT_CONFIG = "project.config";
    private static final String PROJECT = "project";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_MATCH_AUTHOR_DATE_WITH_COMMITTER_DATE = "matchAuthorToCommitterDate";
    public static final String ACCESS = "access";
    private static final String KEY_INHERIT_FROM = "inheritFrom";
    private static final String KEY_GROUP_PERMISSIONS = "exclusiveGroupPermissions";
    private static final String ACCOUNTS = "accounts";
    private static final String KEY_SAME_GROUP_VISIBILITY = "sameGroupVisibility";
    private static final String BRANCH_ORDER = "branchOrder";
    private static final String BRANCH = "branch";
    private static final String CONTRIBUTOR_AGREEMENT = "contributor-agreement";
    private static final String KEY_ACCEPTED = "accepted";
    private static final String KEY_AUTO_VERIFY = "autoVerify";
    private static final String KEY_AGREEMENT_URL = "agreementUrl";
    private static final String NOTIFY = "notify";
    private static final String KEY_EMAIL = "email";
    private static final String KEY_FILTER = "filter";
    private static final String KEY_TYPE = "type";
    private static final String KEY_HEADER = "header";
    private static final String CAPABILITY = "capability";
    private static final String RECEIVE = "receive";
    private static final String KEY_REQUIRE_SIGNED_OFF_BY = "requireSignedOffBy";
    private static final String KEY_REQUIRE_CHANGE_ID = "requireChangeId";
    private static final String KEY_USE_ALL_NOT_IN_TARGET = "createNewChangeForAllNotInTarget";
    private static final String KEY_MAX_OBJECT_SIZE_LIMIT = "maxObjectSizeLimit";
    private static final String KEY_REQUIRE_CONTRIBUTOR_AGREEMENT = "requireContributorAgreement";
    private static final String KEY_CHECK_RECEIVED_OBJECTS = "checkReceivedObjects";
    private static final String KEY_ENABLE_SIGNED_PUSH = "enableSignedPush";
    private static final String KEY_REQUIRE_SIGNED_PUSH = "requireSignedPush";
    private static final String KEY_REJECT_IMPLICIT_MERGES = "rejectImplicitMerges";
    private static final String CHANGE = "change";
    private static final String KEY_PRIVATE_BY_DEFAULT = "privateByDefault";
    private static final String KEY_WORK_IN_PROGRESS_BY_DEFAULT = "workInProgressByDefault";
    private static final String SUBMIT = "submit";
    private static final String KEY_ACTION = "action";
    private static final String KEY_MERGE_CONTENT = "mergeContent";
    private static final String KEY_STATE = "state";
    private static final String SUBSCRIBE_SECTION = "allowSuperproject";
    private static final String SUBSCRIBE_MATCH_REFS = "matching";
    private static final String SUBSCRIBE_MULTI_MATCH_REFS = "all";
    private static final String DASHBOARD = "dashboard";
    private static final String KEY_DEFAULT = "default";
    private static final String KEY_LOCAL_DEFAULT = "local-default";
    private static final String LABEL = "label";
    private static final String KEY_FUNCTION = "function";
    private static final String KEY_DEFAULT_VALUE = "defaultValue";
    private static final String KEY_COPY_MIN_SCORE = "copyMinScore";
    private static final String KEY_ALLOW_POST_SUBMIT = "allowPostSubmit";
    private static final String KEY_COPY_MAX_SCORE = "copyMaxScore";
    private static final String KEY_COPY_ALL_SCORES_ON_MERGE_FIRST_PARENT_UPDATE = "copyAllScoresOnMergeFirstParentUpdate";
    private static final String KEY_COPY_ALL_SCORES_ON_TRIVIAL_REBASE = "copyAllScoresOnTrivialRebase";
    private static final String KEY_COPY_ALL_SCORES_IF_NO_CODE_CHANGE = "copyAllScoresIfNoCodeChange";
    private static final String KEY_COPY_ALL_SCORES_IF_NO_CHANGE = "copyAllScoresIfNoChange";
    private static final String KEY_VALUE = "value";
    private static final String KEY_CAN_OVERRIDE = "canOverride";
    private static final String KEY_BRANCH = "branch";
    private static final String REVIEWER = "reviewer";
    private static final String KEY_ENABLE_REVIEWER_BY_EMAIL = "enableByEmail";
    private static final String LEGACY_PERMISSION_PUSH_TAG = "pushTag";
    private static final String LEGACY_PERMISSION_PUSH_SIGNED_TAG = "pushSignedTag";
    private static final String PLUGIN = "plugin";
    private static final SubmitType DEFAULT_SUBMIT_ACTION = SubmitType.MERGE_IF_NECESSARY;
    private static final ProjectState DEFAULT_STATE_VALUE = ProjectState.ACTIVE;
    private static final String EXTENSION_PANELS = "extension-panels";
    private static final String KEY_PANEL = "panel";
    private Project.NameKey projectName;
    private Project project;
    private AccountsSection accountsSection;
    private GroupList groupList;
    private Map<String, AccessSection> accessSections;
    private BranchOrderSection branchOrderSection;
    private Map<String, ContributorAgreement> contributorAgreements;
    private Map<String, NotifyConfig> notifySections;
    private Map<String, LabelType> labelSections;
    private ConfiguredMimeTypes mimeTypes;
    private Map<Project.NameKey, SubscribeSection> subscribeSections;
    private List<CommentLinkInfoImpl> commentLinkSections;
    private List<ValidationError> validationErrors;
    private ObjectId rulesId;
    private long maxObjectSizeLimit;
    private Map<String, Config> pluginConfigs;
    private boolean checkReceivedObjects;
    private Set<String> sectionsWithUnknownPermissions;
    private boolean hasLegacyPermissions;
    private Map<String, List<String>> extensionPanelSections;
    private Map<String, GroupReference> groupsByName;

    public static ProjectConfig read(MetaDataUpdate update) throws IOException, ConfigInvalidException {
        ProjectConfig r = new ProjectConfig(update.getProjectName());
        r.load(update);
        return r;
    }

    public static ProjectConfig read(MetaDataUpdate update, ObjectId id) throws IOException, ConfigInvalidException {
        ProjectConfig r = new ProjectConfig(update.getProjectName());
        r.load(update, id);
        return r;
    }

    public static CommentLinkInfoImpl buildCommentLink(Config cfg, String name, boolean allowRaw) throws IllegalArgumentException {
        String match = cfg.getString(COMMENTLINK, name, KEY_MATCH);
        if (match != null) {
            Pattern.compile(match);
        }
        String link = cfg.getString(COMMENTLINK, name, KEY_LINK);
        String html = cfg.getString(COMMENTLINK, name, KEY_HTML);
        boolean hasHtml = !Strings.isNullOrEmpty(html);
        String rawEnabled = cfg.getString(COMMENTLINK, name, KEY_ENABLED);
        Boolean enabled = rawEnabled != null ? Boolean.valueOf(cfg.getBoolean(COMMENTLINK, name, KEY_ENABLED, true)) : null;
        Preconditions.checkArgument(allowRaw || !hasHtml, "Raw html replacement not allowed");
        if (Strings.isNullOrEmpty(match) && Strings.isNullOrEmpty(link) && !hasHtml && enabled != null) {
            if (enabled.booleanValue()) {
                return new CommentLinkInfoImpl.Enabled(name);
            }
            return new CommentLinkInfoImpl.Disabled(name);
        }
        return new CommentLinkInfoImpl(name, match, link, html, enabled);
    }

    public ProjectConfig(Project.NameKey projectName) {
        this.projectName = projectName;
    }

    public Project.NameKey getName() {
        return this.projectName;
    }

    public Project getProject() {
        return this.project;
    }

    public AccountsSection getAccountsSection() {
        return this.accountsSection;
    }

    public Map<String, List<String>> getExtensionPanelSections() {
        return this.extensionPanelSections;
    }

    public AccessSection getAccessSection(String name) {
        return this.getAccessSection(name, false);
    }

    public AccessSection getAccessSection(String name, boolean create) {
        AccessSection as = this.accessSections.get(name);
        if (as == null && create) {
            as = new AccessSection(name);
            this.accessSections.put(name, as);
        }
        return as;
    }

    public Collection<AccessSection> getAccessSections() {
        return ProjectConfig.sort(this.accessSections.values());
    }

    public BranchOrderSection getBranchOrderSection() {
        return this.branchOrderSection;
    }

    public Map<Project.NameKey, SubscribeSection> getSubscribeSections() {
        return this.subscribeSections;
    }

    public Collection<SubscribeSection> getSubscribeSections(Branch.NameKey branch) {
        ArrayList<SubscribeSection> ret = new ArrayList<SubscribeSection>();
        for (SubscribeSection s : this.subscribeSections.values()) {
            if (!s.appliesTo(branch)) continue;
            ret.add(s);
        }
        return ret;
    }

    public void addSubscribeSection(SubscribeSection s) {
        this.subscribeSections.put(s.getProject(), s);
    }

    public void remove(AccessSection section) {
        if (section != null) {
            String name = section.getName();
            if (this.sectionsWithUnknownPermissions.contains(name)) {
                AccessSection a = this.accessSections.get(name);
                a.setPermissions(new ArrayList<Permission>());
            } else {
                this.accessSections.remove(name);
            }
        }
    }

    public void remove(AccessSection section, Permission permission) {
        if (permission == null) {
            this.remove(section);
        } else if (section != null) {
            AccessSection a = this.accessSections.get(section.getName());
            a.remove(permission);
            if (a.getPermissions().isEmpty()) {
                this.remove(a);
            }
        }
    }

    public void remove(AccessSection section, Permission permission, PermissionRule rule) {
        if (rule == null) {
            this.remove(section, permission);
        } else if (section != null && permission != null) {
            AccessSection a = this.accessSections.get(section.getName());
            if (a == null) {
                return;
            }
            Permission p = a.getPermission(permission.getName());
            if (p == null) {
                return;
            }
            p.remove(rule);
            if (p.getRules().isEmpty()) {
                a.remove(permission);
            }
            if (a.getPermissions().isEmpty()) {
                this.remove(a);
            }
        }
    }

    public void replace(AccessSection section) {
        for (Permission permission : section.getPermissions()) {
            for (PermissionRule rule : permission.getRules()) {
                rule.setGroup(this.resolve(rule.getGroup()));
            }
        }
        this.accessSections.put(section.getName(), section);
    }

    public ContributorAgreement getContributorAgreement(String name) {
        return this.getContributorAgreement(name, false);
    }

    public ContributorAgreement getContributorAgreement(String name, boolean create) {
        ContributorAgreement ca = this.contributorAgreements.get(name);
        if (ca == null && create) {
            ca = new ContributorAgreement(name);
            this.contributorAgreements.put(name, ca);
        }
        return ca;
    }

    public Collection<ContributorAgreement> getContributorAgreements() {
        return ProjectConfig.sort(this.contributorAgreements.values());
    }

    public void remove(ContributorAgreement section) {
        if (section != null) {
            this.accessSections.remove(section.getName());
        }
    }

    public void replace(ContributorAgreement section) {
        section.setAutoVerify(this.resolve(section.getAutoVerify()));
        for (PermissionRule rule : section.getAccepted()) {
            rule.setGroup(this.resolve(rule.getGroup()));
        }
        this.contributorAgreements.put(section.getName(), section);
    }

    public Collection<NotifyConfig> getNotifyConfigs() {
        return this.notifySections.values();
    }

    public void putNotifyConfig(String name, NotifyConfig nc) {
        this.notifySections.put(name, nc);
    }

    public Map<String, LabelType> getLabelSections() {
        return this.labelSections;
    }

    public Collection<CommentLinkInfoImpl> getCommentLinkSections() {
        return this.commentLinkSections;
    }

    public void addCommentLinkSection(CommentLinkInfoImpl commentLink) {
        this.commentLinkSections.add(commentLink);
    }

    public ConfiguredMimeTypes getMimeTypes() {
        return this.mimeTypes;
    }

    public GroupReference resolve(AccountGroup group) {
        return this.resolve(GroupReference.forGroup(group));
    }

    public GroupReference resolve(GroupReference group) {
        GroupReference groupRef = this.groupList.resolve(group);
        if (groupRef != null && groupRef.getUUID() != null && !this.groupsByName.containsKey(groupRef.getName())) {
            this.groupsByName.put(groupRef.getName(), groupRef);
        }
        return groupRef;
    }

    public GroupReference getGroup(AccountGroup.UUID uuid) {
        return this.groupList.byUUID(uuid);
    }

    public GroupReference getGroup(String groupName) {
        return this.groupsByName.get(groupName);
    }

    public Set<AccountGroup.UUID> getAllGroupUUIDs() {
        return this.groupList.uuids();
    }

    public ObjectId getRulesId() {
        return this.rulesId;
    }

    public long getMaxObjectSizeLimit() {
        return this.maxObjectSizeLimit;
    }

    public boolean getCheckReceivedObjects() {
        return this.checkReceivedObjects;
    }

    public boolean updateGroupNames(GroupBackend groupBackend) {
        boolean dirty = false;
        for (GroupReference ref : this.groupList.references()) {
            GroupDescription.Basic g = groupBackend.get(ref.getUUID());
            if (g == null || g.getName().equals(ref.getName())) continue;
            dirty = true;
            ref.setName(g.getName());
        }
        return dirty;
    }

    public List<ValidationError> getValidationErrors() {
        if (this.validationErrors != null) {
            return Collections.unmodifiableList(this.validationErrors);
        }
        return Collections.emptyList();
    }

    @Override
    protected String getRefName() {
        return "refs/meta/config";
    }

    @Override
    protected void onLoad() throws IOException, ConfigInvalidException {
        this.readGroupList();
        this.groupsByName = this.mapGroupReferences();
        this.rulesId = this.getObjectId("rules.pl");
        Config rc = this.readConfig(PROJECT_CONFIG);
        Project p = this.project = new Project(this.projectName);
        p.setDescription(rc.getString(PROJECT, null, KEY_DESCRIPTION));
        if (p.getDescription() == null) {
            p.setDescription("");
        }
        if (rc.getStringList(ACCESS, null, KEY_INHERIT_FROM).length > 1) {
            this.error(new ValidationError(PROJECT_CONFIG, "Cannot inherit from multiple projects"));
        }
        p.setParentName(rc.getString(ACCESS, null, KEY_INHERIT_FROM));
        p.setUseContributorAgreements(this.getEnum(rc, RECEIVE, null, KEY_REQUIRE_CONTRIBUTOR_AGREEMENT, InheritableBoolean.INHERIT));
        p.setUseSignedOffBy(this.getEnum(rc, RECEIVE, null, KEY_REQUIRE_SIGNED_OFF_BY, InheritableBoolean.INHERIT));
        p.setRequireChangeID(this.getEnum(rc, RECEIVE, null, KEY_REQUIRE_CHANGE_ID, InheritableBoolean.INHERIT));
        p.setCreateNewChangeForAllNotInTarget(this.getEnum(rc, RECEIVE, null, KEY_USE_ALL_NOT_IN_TARGET, InheritableBoolean.INHERIT));
        p.setEnableSignedPush(this.getEnum(rc, RECEIVE, null, KEY_ENABLE_SIGNED_PUSH, InheritableBoolean.INHERIT));
        p.setRequireSignedPush(this.getEnum(rc, RECEIVE, null, KEY_REQUIRE_SIGNED_PUSH, InheritableBoolean.INHERIT));
        p.setMaxObjectSizeLimit(rc.getString(RECEIVE, null, KEY_MAX_OBJECT_SIZE_LIMIT));
        p.setRejectImplicitMerges(this.getEnum(rc, RECEIVE, null, KEY_REJECT_IMPLICIT_MERGES, InheritableBoolean.INHERIT));
        p.setPrivateByDefault(this.getEnum(rc, CHANGE, null, KEY_PRIVATE_BY_DEFAULT, InheritableBoolean.INHERIT));
        p.setWorkInProgressByDefault(this.getEnum(rc, CHANGE, null, KEY_WORK_IN_PROGRESS_BY_DEFAULT, InheritableBoolean.INHERIT));
        p.setEnableReviewerByEmail(this.getEnum(rc, REVIEWER, null, KEY_ENABLE_REVIEWER_BY_EMAIL, InheritableBoolean.INHERIT));
        p.setSubmitType(this.getEnum(rc, SUBMIT, null, KEY_ACTION, DEFAULT_SUBMIT_ACTION));
        p.setUseContentMerge(this.getEnum(rc, SUBMIT, null, KEY_MERGE_CONTENT, InheritableBoolean.INHERIT));
        p.setMatchAuthorToCommitterDate(this.getEnum(rc, SUBMIT, null, KEY_MATCH_AUTHOR_DATE_WITH_COMMITTER_DATE, InheritableBoolean.INHERIT));
        p.setState(this.getEnum(rc, PROJECT, null, KEY_STATE, DEFAULT_STATE_VALUE));
        p.setDefaultDashboard(rc.getString(DASHBOARD, null, KEY_DEFAULT));
        p.setLocalDefaultDashboard(rc.getString(DASHBOARD, null, KEY_LOCAL_DEFAULT));
        this.loadAccountsSection(rc);
        this.loadContributorAgreements(rc);
        this.loadAccessSections(rc);
        this.loadBranchOrderSection(rc);
        this.loadNotifySections(rc);
        this.loadLabelSections(rc);
        this.loadCommentLinkSections(rc);
        this.loadSubscribeSections(rc);
        this.mimeTypes = new ConfiguredMimeTypes(this.projectName.get(), rc);
        this.loadPluginSections(rc);
        this.loadReceiveSection(rc);
        this.loadExtensionPanelSections(rc);
    }

    private void loadAccountsSection(Config rc) {
        this.accountsSection = new AccountsSection();
        this.accountsSection.setSameGroupVisibility(this.loadPermissionRules(rc, ACCOUNTS, null, KEY_SAME_GROUP_VISIBILITY, this.groupsByName, false));
    }

    private void loadExtensionPanelSections(Config rc) {
        HashMap<String, String> lowerNames = Maps.newHashMapWithExpectedSize(2);
        this.extensionPanelSections = Maps.newLinkedHashMap();
        for (String name : rc.getSubsections(EXTENSION_PANELS)) {
            String lower = name.toLowerCase();
            if (lowerNames.containsKey(lower)) {
                this.error(new ValidationError(PROJECT_CONFIG, String.format("Extension Panels \"%s\" conflicts with \"%s\"", name, lowerNames.get(lower))));
            }
            lowerNames.put(lower, name);
            this.extensionPanelSections.put(name, new ArrayList<String>(Arrays.asList(rc.getStringList(EXTENSION_PANELS, name, KEY_PANEL))));
        }
    }

    private void loadContributorAgreements(Config rc) {
        this.contributorAgreements = new HashMap<String, ContributorAgreement>();
        for (String name : rc.getSubsections(CONTRIBUTOR_AGREEMENT)) {
            ContributorAgreement ca = this.getContributorAgreement(name, true);
            ca.setDescription(rc.getString(CONTRIBUTOR_AGREEMENT, name, KEY_DESCRIPTION));
            ca.setAgreementUrl(rc.getString(CONTRIBUTOR_AGREEMENT, name, KEY_AGREEMENT_URL));
            ca.setAccepted(this.loadPermissionRules(rc, CONTRIBUTOR_AGREEMENT, name, KEY_ACCEPTED, this.groupsByName, false));
            List<PermissionRule> rules = this.loadPermissionRules(rc, CONTRIBUTOR_AGREEMENT, name, KEY_AUTO_VERIFY, this.groupsByName, false);
            if (rules.isEmpty()) {
                ca.setAutoVerify(null);
                continue;
            }
            if (rules.size() > 1) {
                this.error(new ValidationError(PROJECT_CONFIG, "Invalid rule in contributor-agreement." + name + "." + KEY_AUTO_VERIFY + ": at most one group may be set"));
                continue;
            }
            if (rules.get(0).getAction() != PermissionRule.Action.ALLOW) {
                this.error(new ValidationError(PROJECT_CONFIG, "Invalid rule in contributor-agreement." + name + "." + KEY_AUTO_VERIFY + ": the group must be allowed"));
                continue;
            }
            ca.setAutoVerify(rules.get(0).getGroup());
        }
    }

    private void loadNotifySections(Config rc) {
        this.notifySections = new HashMap<String, NotifyConfig>();
        for (String sectionName : rc.getSubsections(NOTIFY)) {
            NotifyConfig n = new NotifyConfig();
            n.setName(sectionName);
            n.setFilter(rc.getString(NOTIFY, sectionName, KEY_FILTER));
            EnumSet<WatchConfig.NotifyType> types = EnumSet.noneOf(WatchConfig.NotifyType.class);
            types.addAll(ConfigUtil.getEnumList(rc, NOTIFY, sectionName, KEY_TYPE, WatchConfig.NotifyType.ALL));
            n.setTypes(types);
            n.setHeader(rc.getEnum(NOTIFY, sectionName, KEY_HEADER, NotifyConfig.Header.BCC));
            for (String dst : rc.getStringList(NOTIFY, sectionName, KEY_EMAIL)) {
                String groupName = GroupReference.extractGroupName(dst);
                if (groupName != null) {
                    GroupReference ref = this.groupsByName.get(groupName);
                    if (ref == null) {
                        ref = new GroupReference(null, groupName);
                        this.groupsByName.put(ref.getName(), ref);
                    }
                    if (ref.getUUID() != null) {
                        n.addEmail(ref);
                        continue;
                    }
                    this.error(new ValidationError(PROJECT_CONFIG, "group \"" + ref.getName() + "\" not in " + "groups"));
                    continue;
                }
                if (dst.startsWith("user ")) {
                    this.error(new ValidationError(PROJECT_CONFIG, dst + " not supported"));
                    continue;
                }
                try {
                    n.addEmail(Address.parse(dst));
                }
                catch (IllegalArgumentException err) {
                    this.error(new ValidationError(PROJECT_CONFIG, "notify section \"" + sectionName + "\" has invalid email \"" + dst + "\""));
                }
            }
            this.notifySections.put(sectionName, n);
        }
    }

    private void loadAccessSections(Config rc) {
        this.accessSections = new HashMap<String, AccessSection>();
        this.sectionsWithUnknownPermissions = new HashSet<String>();
        for (String refName : rc.getSubsections(ACCESS)) {
            if (!RefConfigSection.isValid(refName) || !this.isValidRegex(refName)) continue;
            AccessSection as = this.getAccessSection(refName, true);
            for (String varName : rc.getStringList(ACCESS, refName, KEY_GROUP_PERMISSIONS)) {
                for (String n : varName.split("[, \t]{1,}")) {
                    if (!Permission.isPermission(n = this.convertLegacyPermission(n))) continue;
                    as.getPermission(n, true).setExclusiveGroup(true);
                }
            }
            for (String varName : rc.getNames(ACCESS, refName)) {
                String convertedName = this.convertLegacyPermission(varName);
                if (Permission.isPermission(convertedName)) {
                    Permission perm = as.getPermission(convertedName, true);
                    this.loadPermissionRules(rc, ACCESS, refName, varName, this.groupsByName, perm, Permission.hasRange(convertedName));
                    continue;
                }
                this.sectionsWithUnknownPermissions.add(as.getName());
            }
        }
        AccessSection capability = null;
        for (String varName : rc.getNames(CAPABILITY)) {
            if (capability == null) {
                capability = new AccessSection("GLOBAL_CAPABILITIES");
                this.accessSections.put("GLOBAL_CAPABILITIES", capability);
            }
            Permission perm = capability.getPermission(varName, true);
            this.loadPermissionRules(rc, CAPABILITY, null, varName, this.groupsByName, perm, GlobalCapability.hasRange(varName));
        }
    }

    private boolean isValidRegex(String refPattern) {
        try {
            RefPattern.validateRegExp(refPattern);
        }
        catch (InvalidNameException e) {
            this.error(new ValidationError(PROJECT_CONFIG, "Invalid ref name: " + e.getMessage()));
            return false;
        }
        return true;
    }

    private void loadBranchOrderSection(Config rc) {
        if (rc.getSections().contains(BRANCH_ORDER)) {
            this.branchOrderSection = new BranchOrderSection(rc.getStringList(BRANCH_ORDER, null, "branch"));
        }
    }

    private List<PermissionRule> loadPermissionRules(Config rc, String section, String subsection, String varName, Map<String, GroupReference> groupsByName, boolean useRange) {
        Permission perm = new Permission(varName);
        this.loadPermissionRules(rc, section, subsection, varName, groupsByName, perm, useRange);
        return perm.getRules();
    }

    private void loadPermissionRules(Config rc, String section, String subsection, String varName, Map<String, GroupReference> groupsByName, Permission perm, boolean useRange) {
        for (String ruleString : rc.getStringList(section, subsection, varName)) {
            PermissionRule rule;
            try {
                rule = PermissionRule.fromString(ruleString, useRange);
            }
            catch (IllegalArgumentException notRule) {
                this.error(new ValidationError(PROJECT_CONFIG, "Invalid rule in " + section + (subsection != null ? "." + subsection : "") + "." + varName + ": " + notRule.getMessage()));
                continue;
            }
            GroupReference ref = groupsByName.get(rule.getGroup().getName());
            if (ref == null) {
                ref = rule.getGroup();
                groupsByName.put(ref.getName(), ref);
                this.error(new ValidationError(PROJECT_CONFIG, "group \"" + ref.getName() + "\" not in " + "groups"));
            }
            rule.setGroup(ref);
            perm.add(rule);
        }
    }

    private static LabelValue parseLabelValue(String src) {
        ImmutableList<String> parts = ImmutableList.copyOf(Splitter.on(CharMatcher.whitespace()).omitEmptyStrings().limit(2).split(src));
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("empty value");
        }
        String valueText = parts.size() > 1 ? (String)parts.get(1) : "";
        return new LabelValue(Shorts.checkedCast(PermissionRule.parseInt((String)parts.get(0))), valueText);
    }

    private void loadLabelSections(Config rc) {
        HashMap<String, String> lowerNames = Maps.newHashMapWithExpectedSize(2);
        this.labelSections = new LinkedHashMap<String, LabelType>();
        for (String name : rc.getSubsections(LABEL)) {
            Optional<LabelFunction> function;
            LabelType label;
            String lower = name.toLowerCase();
            if (lowerNames.containsKey(lower)) {
                this.error(new ValidationError(PROJECT_CONFIG, String.format("Label \"%s\" conflicts with \"%s\"", name, lowerNames.get(lower))));
            }
            lowerNames.put(lower, name);
            ArrayList<LabelValue> values = new ArrayList<LabelValue>();
            for (String value : rc.getStringList(LABEL, name, KEY_VALUE)) {
                try {
                    values.add(ProjectConfig.parseLabelValue(value));
                }
                catch (IllegalArgumentException notValue) {
                    this.error(new ValidationError(PROJECT_CONFIG, String.format("Invalid %s \"%s\" for label \"%s\": %s", KEY_VALUE, value, name, notValue.getMessage())));
                }
            }
            try {
                label = new LabelType(name, values);
            }
            catch (IllegalArgumentException badName) {
                this.error(new ValidationError(PROJECT_CONFIG, String.format("Invalid label \"%s\"", name)));
                continue;
            }
            String functionName = rc.getString(LABEL, name, KEY_FUNCTION);
            Optional<LabelFunction> optional = function = functionName != null ? LabelFunction.parse(functionName) : Optional.of(LabelFunction.MAX_WITH_BLOCK);
            if (!function.isPresent()) {
                this.error(new ValidationError(PROJECT_CONFIG, String.format("Invalid %s for label \"%s\". Valid names are: %s", KEY_FUNCTION, name, Joiner.on(", ").join(LabelFunction.ALL.keySet()))));
            }
            label.setFunction(function.orElse(null));
            if (!values.isEmpty()) {
                short dv = (short)rc.getInt(LABEL, name, KEY_DEFAULT_VALUE, 0);
                if (this.isInRange(dv, values)) {
                    label.setDefaultValue(dv);
                } else {
                    this.error(new ValidationError(PROJECT_CONFIG, String.format("Invalid %s \"%s\" for label \"%s\"", KEY_DEFAULT_VALUE, dv, name)));
                }
            }
            label.setAllowPostSubmit(rc.getBoolean(LABEL, name, KEY_ALLOW_POST_SUBMIT, true));
            label.setCopyMinScore(rc.getBoolean(LABEL, name, KEY_COPY_MIN_SCORE, false));
            label.setCopyMaxScore(rc.getBoolean(LABEL, name, KEY_COPY_MAX_SCORE, false));
            label.setCopyAllScoresOnMergeFirstParentUpdate(rc.getBoolean(LABEL, name, KEY_COPY_ALL_SCORES_ON_MERGE_FIRST_PARENT_UPDATE, false));
            label.setCopyAllScoresOnTrivialRebase(rc.getBoolean(LABEL, name, KEY_COPY_ALL_SCORES_ON_TRIVIAL_REBASE, false));
            label.setCopyAllScoresIfNoCodeChange(rc.getBoolean(LABEL, name, KEY_COPY_ALL_SCORES_IF_NO_CODE_CHANGE, false));
            label.setCopyAllScoresIfNoChange(rc.getBoolean(LABEL, name, KEY_COPY_ALL_SCORES_IF_NO_CHANGE, true));
            label.setCanOverride(rc.getBoolean(LABEL, name, KEY_CAN_OVERRIDE, true));
            label.setRefPatterns(this.getStringListOrNull(rc, LABEL, name, "branch"));
            this.labelSections.put(name, label);
        }
    }

    private boolean isInRange(short value, List<LabelValue> labelValues) {
        for (LabelValue lv : labelValues) {
            if (lv.getValue() != value) continue;
            return true;
        }
        return false;
    }

    private List<String> getStringListOrNull(Config rc, String section, String subSection, String name) {
        String[] ac = rc.getStringList(section, subSection, name);
        return ac.length == 0 ? null : Arrays.asList(ac);
    }

    private void loadCommentLinkSections(Config rc) {
        Set<String> subsections = rc.getSubsections(COMMENTLINK);
        this.commentLinkSections = Lists.newArrayListWithCapacity(subsections.size());
        for (String name : subsections) {
            try {
                this.commentLinkSections.add(ProjectConfig.buildCommentLink(rc, name, false));
            }
            catch (PatternSyntaxException e) {
                this.error(new ValidationError(PROJECT_CONFIG, String.format("Invalid pattern \"%s\" in commentlink.%s.match: %s", rc.getString(COMMENTLINK, name, KEY_MATCH), name, e.getMessage())));
            }
            catch (IllegalArgumentException e) {
                this.error(new ValidationError(PROJECT_CONFIG, String.format("Error in pattern \"%s\" in commentlink.%s.match: %s", rc.getString(COMMENTLINK, name, KEY_MATCH), name, e.getMessage())));
            }
        }
    }

    private void loadSubscribeSections(Config rc) throws ConfigInvalidException {
        Set<String> subsections = rc.getSubsections(SUBSCRIBE_SECTION);
        this.subscribeSections = new HashMap<Project.NameKey, SubscribeSection>();
        try {
            for (String projectName : subsections) {
                Project.NameKey p = new Project.NameKey(projectName);
                SubscribeSection ss = new SubscribeSection(p);
                for (String s : rc.getStringList(SUBSCRIBE_SECTION, projectName, SUBSCRIBE_MULTI_MATCH_REFS)) {
                    ss.addMultiMatchRefSpec(s);
                }
                for (String s : rc.getStringList(SUBSCRIBE_SECTION, projectName, SUBSCRIBE_MATCH_REFS)) {
                    ss.addMatchingRefSpec(s);
                }
                this.subscribeSections.put(p, ss);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConfigInvalidException(e.getMessage());
        }
    }

    private void loadReceiveSection(Config rc) {
        this.checkReceivedObjects = rc.getBoolean(RECEIVE, KEY_CHECK_RECEIVED_OBJECTS, true);
        this.maxObjectSizeLimit = rc.getLong(RECEIVE, null, KEY_MAX_OBJECT_SIZE_LIMIT, 0L);
    }

    private void loadPluginSections(Config rc) {
        this.pluginConfigs = new HashMap<String, Config>();
        for (String plugin : rc.getSubsections(PLUGIN)) {
            Config pluginConfig = new Config();
            this.pluginConfigs.put(plugin, pluginConfig);
            for (String name : rc.getNames(PLUGIN, plugin)) {
                String value = rc.getString(PLUGIN, plugin, name);
                String groupName = GroupReference.extractGroupName(value);
                if (groupName != null) {
                    GroupReference ref = this.groupsByName.get(groupName);
                    if (ref == null) {
                        this.error(new ValidationError(PROJECT_CONFIG, "group \"" + groupName + "\" not in " + "groups"));
                    }
                    rc.setString(PLUGIN, plugin, name, value);
                }
                pluginConfig.setStringList(PLUGIN, plugin, name, Arrays.asList(rc.getStringList(PLUGIN, plugin, name)));
            }
        }
    }

    public PluginConfig getPluginConfig(String pluginName) {
        Config pluginConfig = this.pluginConfigs.get(pluginName);
        if (pluginConfig == null) {
            pluginConfig = new Config();
            this.pluginConfigs.put(pluginName, pluginConfig);
        }
        return new PluginConfig(pluginName, pluginConfig, this);
    }

    private void readGroupList() throws IOException {
        this.groupList = GroupList.parse(this.projectName, this.readUTF8("groups"), this);
    }

    private Map<String, GroupReference> mapGroupReferences() {
        Collection<GroupReference> references = this.groupList.references();
        HashMap<String, GroupReference> result = new HashMap<String, GroupReference>(references.size());
        for (GroupReference ref : references) {
            result.put(ref.getName(), ref);
        }
        return result;
    }

    @Override
    protected boolean onSave(CommitBuilder commit) throws IOException, ConfigInvalidException {
        if (commit.getMessage() == null || "".equals(commit.getMessage())) {
            commit.setMessage("Updated project configuration\n");
        }
        Config rc = this.readConfig(PROJECT_CONFIG);
        Project p = this.project;
        if (p.getDescription() != null && !p.getDescription().isEmpty()) {
            rc.setString(PROJECT, null, KEY_DESCRIPTION, p.getDescription());
        } else {
            rc.unset(PROJECT, null, KEY_DESCRIPTION);
        }
        ProjectConfig.set(rc, ACCESS, null, KEY_INHERIT_FROM, p.getParentName());
        ProjectConfig.set(rc, RECEIVE, null, KEY_REQUIRE_CONTRIBUTOR_AGREEMENT, p.getUseContributorAgreements(), InheritableBoolean.INHERIT);
        ProjectConfig.set(rc, RECEIVE, null, KEY_REQUIRE_SIGNED_OFF_BY, p.getUseSignedOffBy(), InheritableBoolean.INHERIT);
        ProjectConfig.set(rc, RECEIVE, null, KEY_REQUIRE_CHANGE_ID, p.getRequireChangeID(), InheritableBoolean.INHERIT);
        ProjectConfig.set(rc, RECEIVE, null, KEY_USE_ALL_NOT_IN_TARGET, p.getCreateNewChangeForAllNotInTarget(), InheritableBoolean.INHERIT);
        ProjectConfig.set(rc, RECEIVE, null, KEY_MAX_OBJECT_SIZE_LIMIT, ProjectConfig.validMaxObjectSizeLimit(p.getMaxObjectSizeLimit()));
        ProjectConfig.set(rc, RECEIVE, null, KEY_ENABLE_SIGNED_PUSH, p.getEnableSignedPush(), InheritableBoolean.INHERIT);
        ProjectConfig.set(rc, RECEIVE, null, KEY_REQUIRE_SIGNED_PUSH, p.getRequireSignedPush(), InheritableBoolean.INHERIT);
        ProjectConfig.set(rc, RECEIVE, null, KEY_REJECT_IMPLICIT_MERGES, p.getRejectImplicitMerges(), InheritableBoolean.INHERIT);
        ProjectConfig.set(rc, CHANGE, null, KEY_PRIVATE_BY_DEFAULT, p.getPrivateByDefault(), InheritableBoolean.INHERIT);
        ProjectConfig.set(rc, CHANGE, null, KEY_WORK_IN_PROGRESS_BY_DEFAULT, p.getWorkInProgressByDefault(), InheritableBoolean.INHERIT);
        ProjectConfig.set(rc, REVIEWER, null, KEY_ENABLE_REVIEWER_BY_EMAIL, p.getEnableReviewerByEmail(), InheritableBoolean.INHERIT);
        ProjectConfig.set(rc, SUBMIT, null, KEY_ACTION, p.getSubmitType(), DEFAULT_SUBMIT_ACTION);
        ProjectConfig.set(rc, SUBMIT, null, KEY_MERGE_CONTENT, p.getUseContentMerge(), InheritableBoolean.INHERIT);
        ProjectConfig.set(rc, SUBMIT, null, KEY_MATCH_AUTHOR_DATE_WITH_COMMITTER_DATE, p.getMatchAuthorToCommitterDate(), InheritableBoolean.INHERIT);
        ProjectConfig.set(rc, PROJECT, null, KEY_STATE, p.getState(), DEFAULT_STATE_VALUE);
        ProjectConfig.set(rc, DASHBOARD, null, KEY_DEFAULT, p.getDefaultDashboard());
        ProjectConfig.set(rc, DASHBOARD, null, KEY_LOCAL_DEFAULT, p.getLocalDefaultDashboard());
        HashSet<AccountGroup.UUID> keepGroups = new HashSet<AccountGroup.UUID>();
        this.saveAccountsSection(rc, keepGroups);
        this.saveContributorAgreements(rc, keepGroups);
        this.saveAccessSections(rc, keepGroups);
        this.saveNotifySections(rc, keepGroups);
        this.savePluginSections(rc, keepGroups);
        this.groupList.retainUUIDs(keepGroups);
        this.saveLabelSections(rc);
        this.saveCommentLinkSections(rc);
        this.saveSubscribeSections(rc);
        this.saveConfig(PROJECT_CONFIG, rc);
        this.saveGroupList();
        return true;
    }

    public static String validMaxObjectSizeLimit(String value) throws ConfigInvalidException {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        Config cfg = new Config();
        cfg.fromText("[s]\nn=" + value);
        try {
            long s = cfg.getLong("s", "n", 0L);
            if (s < 0L) {
                throw new ConfigInvalidException(String.format("Negative value '%s' not allowed as %s", value, KEY_MAX_OBJECT_SIZE_LIMIT));
            }
            if (s == 0L) {
                return null;
            }
            return value;
        }
        catch (IllegalArgumentException e) {
            throw new ConfigInvalidException(String.format("Value '%s' not parseable as a Long", value), e);
        }
    }

    private void saveAccountsSection(Config rc, Set<AccountGroup.UUID> keepGroups) {
        if (this.accountsSection != null) {
            rc.setStringList(ACCOUNTS, null, KEY_SAME_GROUP_VISIBILITY, this.ruleToStringList(this.accountsSection.getSameGroupVisibility(), keepGroups));
        }
    }

    private void saveContributorAgreements(Config rc, Set<AccountGroup.UUID> keepGroups) {
        for (ContributorAgreement ca : ProjectConfig.sort(this.contributorAgreements.values())) {
            ProjectConfig.set(rc, CONTRIBUTOR_AGREEMENT, ca.getName(), KEY_DESCRIPTION, ca.getDescription());
            ProjectConfig.set(rc, CONTRIBUTOR_AGREEMENT, ca.getName(), KEY_AGREEMENT_URL, ca.getAgreementUrl());
            if (ca.getAutoVerify() != null) {
                if (ca.getAutoVerify().getUUID() != null) {
                    keepGroups.add(ca.getAutoVerify().getUUID());
                }
                String autoVerify = new PermissionRule(ca.getAutoVerify()).asString(false);
                ProjectConfig.set(rc, CONTRIBUTOR_AGREEMENT, ca.getName(), KEY_AUTO_VERIFY, autoVerify);
            } else {
                rc.unset(CONTRIBUTOR_AGREEMENT, ca.getName(), KEY_AUTO_VERIFY);
            }
            rc.setStringList(CONTRIBUTOR_AGREEMENT, ca.getName(), KEY_ACCEPTED, this.ruleToStringList(ca.getAccepted(), keepGroups));
        }
    }

    private void saveNotifySections(Config rc, Set<AccountGroup.UUID> keepGroups) {
        for (NotifyConfig nc : ProjectConfig.sort(this.notifySections.values())) {
            ArrayList<String> email = new ArrayList<String>();
            for (GroupReference groupReference : nc.getGroups()) {
                if (groupReference.getUUID() != null) {
                    keepGroups.add(groupReference.getUUID());
                }
                email.add(new PermissionRule(groupReference).asString(false));
            }
            Collections.sort(email);
            ArrayList<String> addrs = new ArrayList<String>();
            for (Address addr : nc.getAddresses()) {
                addrs.add(addr.toString());
            }
            Collections.sort(addrs);
            email.addAll(addrs);
            ProjectConfig.set(rc, NOTIFY, nc.getName(), KEY_HEADER, nc.getHeader(), NotifyConfig.Header.BCC);
            if (email.isEmpty()) {
                rc.unset(NOTIFY, nc.getName(), KEY_EMAIL);
            } else {
                rc.setStringList(NOTIFY, nc.getName(), KEY_EMAIL, email);
            }
            if (nc.getNotify().equals(EnumSet.of(WatchConfig.NotifyType.ALL))) {
                rc.unset(NOTIFY, nc.getName(), KEY_TYPE);
            } else {
                ArrayList<String> arrayList = Lists.newArrayListWithCapacity(4);
                for (WatchConfig.NotifyType t : WatchConfig.NotifyType.values()) {
                    if (!nc.isNotify(t)) continue;
                    arrayList.add(t.name().toLowerCase(Locale.US));
                }
                rc.setStringList(NOTIFY, nc.getName(), KEY_TYPE, arrayList);
            }
            ProjectConfig.set(rc, NOTIFY, nc.getName(), KEY_FILTER, nc.getFilter());
        }
    }

    private List<String> ruleToStringList(List<PermissionRule> list, Set<AccountGroup.UUID> keepGroups) {
        ArrayList<String> rules = new ArrayList<String>();
        for (PermissionRule rule : ProjectConfig.sort(list)) {
            if (rule.getGroup().getUUID() != null) {
                keepGroups.add(rule.getGroup().getUUID());
            }
            rules.add(rule.asString(false));
        }
        return rules;
    }

    private void saveAccessSections(Config rc, Set<AccountGroup.UUID> keepGroups) {
        AccessSection capability = this.accessSections.get("GLOBAL_CAPABILITIES");
        if (capability != null) {
            HashSet<String> have = new HashSet<String>();
            for (Permission permission : ProjectConfig.sort(capability.getPermissions())) {
                have.add(permission.getName().toLowerCase());
                boolean needRange = GlobalCapability.hasRange(permission.getName());
                ArrayList rules = new ArrayList();
                for (PermissionRule rule : ProjectConfig.sort(permission.getRules())) {
                    GroupReference group = this.resolve(rule.getGroup());
                    if (group.getUUID() != null) {
                        keepGroups.add(group.getUUID());
                    }
                    rules.add(rule.asString(needRange));
                }
                rc.setStringList(CAPABILITY, null, permission.getName(), rules);
            }
            for (String varName : rc.getNames(CAPABILITY)) {
                if (have.contains(varName.toLowerCase())) continue;
                rc.unset(CAPABILITY, null, varName);
            }
        } else {
            rc.unsetSection(CAPABILITY, null);
        }
        for (AccessSection as : ProjectConfig.sort(this.accessSections.values())) {
            String refName = as.getName();
            if ("GLOBAL_CAPABILITIES".equals(refName)) continue;
            StringBuilder doNotInherit = new StringBuilder();
            for (Permission perm : ProjectConfig.sort(as.getPermissions())) {
                if (!perm.getExclusiveGroup().booleanValue()) continue;
                if (0 < doNotInherit.length()) {
                    doNotInherit.append(' ');
                }
                doNotInherit.append(perm.getName());
            }
            if (0 < doNotInherit.length()) {
                rc.setString(ACCESS, refName, KEY_GROUP_PERMISSIONS, doNotInherit.toString());
            } else {
                rc.unset(ACCESS, refName, KEY_GROUP_PERMISSIONS);
            }
            HashSet<String> have = new HashSet<String>();
            for (Permission permission : ProjectConfig.sort(as.getPermissions())) {
                have.add(permission.getName().toLowerCase());
                boolean needRange = Permission.hasRange(permission.getName());
                ArrayList<String> rules = new ArrayList<String>();
                for (PermissionRule rule : ProjectConfig.sort(permission.getRules())) {
                    GroupReference group = this.resolve(rule.getGroup());
                    if (group.getUUID() != null) {
                        keepGroups.add(group.getUUID());
                    }
                    rules.add(rule.asString(needRange));
                }
                rc.setStringList(ACCESS, refName, permission.getName(), rules);
            }
            for (String varName : rc.getNames(ACCESS, refName)) {
                if (!Permission.isPermission(this.convertLegacyPermission(varName)) || have.contains(varName.toLowerCase())) continue;
                rc.unset(ACCESS, refName, varName);
            }
        }
        for (String name : rc.getSubsections(ACCESS)) {
            if (!RefConfigSection.isValid(name) || this.accessSections.containsKey(name)) continue;
            rc.unsetSection(ACCESS, name);
        }
    }

    private void saveLabelSections(Config rc) {
        ArrayList<String> existing = Lists.newArrayList(rc.getSubsections(LABEL));
        if (!Lists.newArrayList(this.labelSections.keySet()).equals(existing)) {
            for (String name : existing) {
                rc.unsetSection(LABEL, name);
            }
        }
        HashSet<String> toUnset = Sets.newHashSet(existing);
        for (Map.Entry<String, LabelType> e : this.labelSections.entrySet()) {
            String name = e.getKey();
            LabelType label = e.getValue();
            toUnset.remove(name);
            rc.setString(LABEL, name, KEY_FUNCTION, label.getFunction().getFunctionName());
            rc.setInt(LABEL, name, KEY_DEFAULT_VALUE, label.getDefaultValue());
            ProjectConfig.setBooleanConfigKey(rc, LABEL, name, KEY_ALLOW_POST_SUBMIT, label.allowPostSubmit(), true);
            ProjectConfig.setBooleanConfigKey(rc, LABEL, name, KEY_COPY_MIN_SCORE, label.isCopyMinScore(), false);
            ProjectConfig.setBooleanConfigKey(rc, LABEL, name, KEY_COPY_MAX_SCORE, label.isCopyMaxScore(), false);
            ProjectConfig.setBooleanConfigKey(rc, LABEL, name, KEY_COPY_ALL_SCORES_ON_TRIVIAL_REBASE, label.isCopyAllScoresOnTrivialRebase(), false);
            ProjectConfig.setBooleanConfigKey(rc, LABEL, name, KEY_COPY_ALL_SCORES_IF_NO_CODE_CHANGE, label.isCopyAllScoresIfNoCodeChange(), false);
            ProjectConfig.setBooleanConfigKey(rc, LABEL, name, KEY_COPY_ALL_SCORES_IF_NO_CHANGE, label.isCopyAllScoresIfNoChange(), true);
            ProjectConfig.setBooleanConfigKey(rc, LABEL, name, KEY_COPY_ALL_SCORES_ON_MERGE_FIRST_PARENT_UPDATE, label.isCopyAllScoresOnMergeFirstParentUpdate(), false);
            ProjectConfig.setBooleanConfigKey(rc, LABEL, name, KEY_CAN_OVERRIDE, label.canOverride(), true);
            ArrayList<String> values = Lists.newArrayListWithCapacity(label.getValues().size());
            for (LabelValue value : label.getValues()) {
                values.add(value.format());
            }
            rc.setStringList(LABEL, name, KEY_VALUE, values);
            List<String> refPatterns = label.getRefPatterns();
            if (refPatterns == null || refPatterns.isEmpty()) continue;
            rc.setStringList(LABEL, name, "branch", refPatterns);
        }
        for (String name : toUnset) {
            rc.unsetSection(LABEL, name);
        }
    }

    private void saveCommentLinkSections(Config rc) {
        if (this.commentLinkSections != null) {
            for (CommentLinkInfoImpl cm : this.commentLinkSections) {
                rc.setString(COMMENTLINK, cm.name, KEY_MATCH, cm.match);
                if (!Strings.isNullOrEmpty(cm.html)) {
                    rc.setString(COMMENTLINK, cm.name, KEY_HTML, cm.html);
                }
                if (!Strings.isNullOrEmpty(cm.link)) {
                    rc.setString(COMMENTLINK, cm.name, KEY_LINK, cm.link);
                }
                if (cm.enabled == null || cm.enabled.booleanValue()) continue;
                rc.setBoolean(COMMENTLINK, cm.name, KEY_ENABLED, cm.enabled);
            }
        }
    }

    private static void setBooleanConfigKey(Config rc, String section, String name, String key, boolean value, boolean defaultValue) {
        if (value == defaultValue) {
            rc.unset(section, name, key);
        } else {
            rc.setBoolean(section, name, key, value);
        }
    }

    private void savePluginSections(Config rc, Set<AccountGroup.UUID> keepGroups) {
        ArrayList<String> existing = Lists.newArrayList(rc.getSubsections(PLUGIN));
        for (String string : existing) {
            rc.unsetSection(PLUGIN, string);
        }
        for (Map.Entry entry : this.pluginConfigs.entrySet()) {
            String plugin = (String)entry.getKey();
            Config pluginConfig = (Config)entry.getValue();
            for (String name : pluginConfig.getNames(PLUGIN, plugin)) {
                GroupReference ref;
                String value = pluginConfig.getString(PLUGIN, plugin, name);
                String groupName = GroupReference.extractGroupName(value);
                if (groupName != null && (ref = this.groupsByName.get(groupName)) != null && ref.getUUID() != null) {
                    keepGroups.add(ref.getUUID());
                    pluginConfig.setString(PLUGIN, plugin, name, "group " + ref.getName());
                }
                rc.setStringList(PLUGIN, plugin, name, Arrays.asList(pluginConfig.getStringList(PLUGIN, plugin, name)));
            }
        }
    }

    private void saveGroupList() throws IOException {
        this.saveUTF8("groups", this.groupList.asText());
    }

    private void saveSubscribeSections(Config rc) {
        for (Project.NameKey p : this.subscribeSections.keySet()) {
            SubscribeSection s = this.subscribeSections.get(p);
            ArrayList<String> matchings = new ArrayList<String>();
            for (RefSpec r : s.getMatchingRefSpecs()) {
                matchings.add(r.toString());
            }
            rc.setStringList(SUBSCRIBE_SECTION, p.get(), SUBSCRIBE_MATCH_REFS, matchings);
            ArrayList<String> multimatchs = new ArrayList<String>();
            for (RefSpec r : s.getMultiMatchRefSpecs()) {
                multimatchs.add(r.toString());
            }
            rc.setStringList(SUBSCRIBE_SECTION, p.get(), SUBSCRIBE_MULTI_MATCH_REFS, multimatchs);
        }
    }

    private <E extends Enum<?>> E getEnum(Config rc, String section, String subsection, String name, E defaultValue) {
        try {
            return rc.getEnum(section, subsection, name, defaultValue);
        }
        catch (IllegalArgumentException err) {
            this.error(new ValidationError(PROJECT_CONFIG, err.getMessage()));
            return defaultValue;
        }
    }

    @Override
    public void error(ValidationError error) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>(4);
        }
        this.validationErrors.add(error);
    }

    private static <T extends Comparable<? super T>> List<T> sort(Collection<T> m) {
        ArrayList<T> r = new ArrayList<T>(m);
        Collections.sort(r);
        return r;
    }

    public boolean hasLegacyPermissions() {
        return this.hasLegacyPermissions;
    }

    private String convertLegacyPermission(String permissionName) {
        switch (permissionName) {
            case "pushTag": {
                this.hasLegacyPermissions = true;
                return "createTag";
            }
            case "pushSignedTag": {
                this.hasLegacyPermissions = true;
                return "createSignedTag";
            }
        }
        return permissionName;
    }
}

